<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorIPListRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявление о наличии ИП в банке данных (по должнику) | ЭП
 * @subpackage Structs
 */
class DebtorIPListRequestType extends AbstractStructBase
{
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ЕПГУ или АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС,
     * ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The debtor
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Критерий поиска должника в банке данных исполнительных производств ФССП России
     * @var \StructType\ContragentDatumType
     */
    public $debtor;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorIPListRequestType
     * @uses DebtorIPListRequestType::setRequestKey()
     * @uses DebtorIPListRequestType::setDebtor()
     * @uses DebtorIPListRequestType::setSignature()
     * @uses DebtorIPListRequestType::setId()
     * @param string $requestKey
     * @param \StructType\ContragentDatumType $debtor
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($requestKey = null, \StructType\ContragentDatumType $debtor = null, array $signature = array(), $id = null)
    {
        $this
            ->setRequestKey($requestKey)
            ->setDebtor($debtor)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\DebtorIPListRequestType
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get debtor value
     * @return \StructType\ContragentDatumType|null
     */
    public function getDebtor()
    {
        return $this->debtor;
    }
    /**
     * Set debtor value
     * @param \StructType\ContragentDatumType $debtor
     * @return \StructType\DebtorIPListRequestType
     */
    public function setDebtor(\StructType\ContragentDatumType $debtor = null)
    {
        $this->debtor = $debtor;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DebtorIPListRequestType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DebtorIPListRequestType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DebtorIPListRequestType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtorIPListRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
