<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DebtRequest «Запрос реестра долга» | Данный документ запрашивает реестры задолженности по исполнительным производствам и
 * список ОСП для получения реквизитов для перечисления средств | ЭП
 * - type: tns:DebtRequest
 * @subpackage Structs
 */
class DebtRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор запроса, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак запроса обновления | Если в этом поле стоит false, то запрашивается реестр целиком | Обертка стандартного xs:boolean |
     * Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The LastUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего реестра | Дата последнего выгруженного обновления реестра задолженности, которое есть у платежной системы |
     * Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $LastUnloadDate;
    /**
     * The DueUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время, по которые запрашиваются реестры изменений | Используются только при запросе изменений. При запросе полного
     * реестра игнорируется | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DueUnloadDate;
    /**
     * The MaxResultCount
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество реестров | Используются только при запросе изменений. При запросе полного реестра игнорируется. Для
     * поля MaxResultCount значение по умолчанию 17 | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $MaxResultCount;
    /**
     * The ToFrom
     * Meta informations extracted from the WSDL
     * - documentation: Код территориального органа | Если указан данный код, возвращаются только реестры для определенного региона. | Ведомственный
     * классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ToFrom;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for DebtRequest
     * @uses DebtRequest::setExternalKey()
     * @uses DebtRequest::setIsUpdate()
     * @uses DebtRequest::setLastUnloadDate()
     * @uses DebtRequest::setDueUnloadDate()
     * @uses DebtRequest::setMaxResultCount()
     * @uses DebtRequest::setToFrom()
     * @uses DebtRequest::setSignDateTime()
     * @uses DebtRequest::setSignature()
     * @param string $externalKey
     * @param bool $isUpdate
     * @param string $lastUnloadDate
     * @param string $dueUnloadDate
     * @param int $maxResultCount
     * @param string $toFrom
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $isUpdate = null, $lastUnloadDate = null, $dueUnloadDate = null, $maxResultCount = null, $toFrom = null, $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setIsUpdate($isUpdate)
            ->setLastUnloadDate($lastUnloadDate)
            ->setDueUnloadDate($dueUnloadDate)
            ->setMaxResultCount($maxResultCount)
            ->setToFrom($toFrom)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DebtRequest
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \StructType\DebtRequest
     */
    public function setIsUpdate($isUpdate = null)
    {
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get LastUnloadDate value
     * @return string|null
     */
    public function getLastUnloadDate()
    {
        return $this->LastUnloadDate;
    }
    /**
     * Set LastUnloadDate value
     * @param string $lastUnloadDate
     * @return \StructType\DebtRequest
     */
    public function setLastUnloadDate($lastUnloadDate = null)
    {
        $this->LastUnloadDate = $lastUnloadDate;
        return $this;
    }
    /**
     * Get DueUnloadDate value
     * @return string|null
     */
    public function getDueUnloadDate()
    {
        return $this->DueUnloadDate;
    }
    /**
     * Set DueUnloadDate value
     * @param string $dueUnloadDate
     * @return \StructType\DebtRequest
     */
    public function setDueUnloadDate($dueUnloadDate = null)
    {
        $this->DueUnloadDate = $dueUnloadDate;
        return $this;
    }
    /**
     * Get MaxResultCount value
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return $this->MaxResultCount;
    }
    /**
     * Set MaxResultCount value
     * @param int $maxResultCount
     * @return \StructType\DebtRequest
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        $this->MaxResultCount = $maxResultCount;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \StructType\DebtRequest
     */
    public function setToFrom($toFrom = null)
    {
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\DebtRequest
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DebtRequest
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DebtRequest
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
