<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataBlock StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных DataBlock "Пакет документов" | Запрос о полученных физическим лицом суммах, взысканных по ИП | Ответ на запрос о
 * полученных физическим лицом суммах, взысканных по ИП | Запрос в реестр розыска
 * - type: tns:DataBlock
 * @subpackage Structs
 */
class DataBlock extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Обязательно для исходящего документа. Содержит уникальный идентификатор объекта АИС ФССП России | Ключ
     * объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Обязательно для входящего документа. Содержит идентификатор объекта, присвоенный АИС внешнего
     * контрагента. Уникален в рамках типа документа и конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС
     * внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в
     * пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The FsspTo
     * Meta informations extracted from the WSDL
     * - documentation: ТО | Код территориального органа ФССП России с дополнением до 5 знаков нулями для получения кода ВКСП | Ведомственный
     * классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $FsspTo;
    /**
     * The FsspOsp
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Код структурного подразделения территориального органа ФССП России (5 цифр) по справочнику структурных подразделений
     * ФССП России (ВКСП) | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $FsspOsp;
    /**
     * The OrgAMD
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Код Ведомства по справочнику контрагентов автоматизированного межведомственного документооборота | Код
     * организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrgAMD;
    /**
     * The DivAMD
     * Meta informations extracted from the WSDL
     * - documentation: Подразделение контрагента | Код подразделения Ведомства по справочнику подразделений организации-контрагента
     * автоматизированного документооборота | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DivAMD;
    /**
     * The Signed
     * Meta informations extracted from the WSDL
     * - documentation: Подписал | ФИО подписавшего лица | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Signed;
    /**
     * The Query
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Query[]
     */
    public $Query;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на запрос СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Answer[]
     */
    public $Answer;
    /**
     * The AccountQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ на предоставление сведений об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountQuery[]
     */
    public $AccountQuery;
    /**
     * The AccountAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountAnswer[]
     */
    public $AccountAnswer;
    /**
     * The SalaryWithheldQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ на предоставление сведений об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SalaryWithheldQuery[]
     */
    public $SalaryWithheldQuery;
    /**
     * The SalaryWithheldAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Справка о начисленном денежном довольствии и произведенных удержаниях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SalaryWithheldAnswer[]
     */
    public $SalaryWithheldAnswer;
    /**
     * The Restrictn
     * Meta informations extracted from the WSDL
     * - documentation: Постановление к исполнению | Постановление СПИ о наложении ограничения (ареста) или о снятии ограничения (ареста)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restrictn[]
     */
    public $Restrictn;
    /**
     * The Report
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об исполнении | Уведомление об исполнении постановления СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Report[]
     */
    public $Report;
    /**
     * The DebtorNewAccountNotice
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об открытии должниками по ИП новых счетов в кредитных организациях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtorNewAccountNotice[]
     */
    public $DebtorNewAccountNotice;
    /**
     * The ExtDoc
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительный документ | Сведения о предъявленном в ФССП России исполнительном документе в пользу Ведомства
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExtDoc[]
     */
    public $ExtDoc;
    /**
     * The ProcDoc
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Постановление СПИ, направляемое в адрес Ведомства, представляющего взыскателя
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProcDoc[]
     */
    public $ProcDoc;
    /**
     * The ExtDebtFix
     * Meta informations extracted from the WSDL
     * - documentation: Погашение ИД | Реестр погашенной задолженности по исполнительным документам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExtDebtFix[]
     */
    public $ExtDebtFix;
    /**
     * The RecallDoc
     * Meta informations extracted from the WSDL
     * - documentation: Заявление об отзыве ИД | Заявление об отзыве Постановления о взыскании страховых взносов, пеней и штрафов за счет имущества
     * плательщика страховых взносов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecallDoc[]
     */
    public $RecallDoc;
    /**
     * The DebtorPropertyChange
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об изменении реквизитов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtorPropertyChange[]
     */
    public $DebtorPropertyChange;
    /**
     * The DebtRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестров долга | Запрос реестров долга по ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtRequest[]
     */
    public $DebtRequest;
    /**
     * The Debt
     * Meta informations extracted from the WSDL
     * - documentation: Реестр долга по ИП | Реестр остатков долга по ИП
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Debt
     */
    public $Debt;
    /**
     * The ExtPayments
     * Meta informations extracted from the WSDL
     * - documentation: Оплата долга | Реестр оплаченных сумм
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExtPayments[]
     */
    public $ExtPayments;
    /**
     * The OspRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реквизитов ОСП | Запрос параметров ОСП для использования в качестве реквизитов оплаты долга
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OspRequest[]
     */
    public $OspRequest;
    /**
     * The OspProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты ОСП | Реквизиты отделов СП для платежей
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OspProperties[]
     */
    public $OspProperties;
    /**
     * The BankruptDoc
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об инициировании процедуры банкротства должника | Направляется ФНС в адрес ФССП России
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BankruptDoc[]
     */
    public $BankruptDoc;
    /**
     * The ArrestFourthStageProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление СПИ об аресте имущества 4й очереди
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArrestFourthStagePropertyType[]
     */
    public $ArrestFourthStageProperty;
    /**
     * The DebtorIpNotify
     * Meta informations extracted from the WSDL
     * - documentation: Информация об уведомлении должника о возбуждении ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtorIpNotify[]
     */
    public $DebtorIpNotify;
    /**
     * The NoticeReadinessSaleSeizedProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление о готовности к реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NoticeReadinessSaleSeizedProperty[]
     */
    public $NoticeReadinessSaleSeizedProperty;
    /**
     * The NoticeSaleSeizedProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление о реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NoticeSaleSeizedProperty[]
     */
    public $NoticeSaleSeizedProperty;
    /**
     * The CertificateDeliveryAcceptance
     * Meta informations extracted from the WSDL
     * - documentation: Акт приема-передачи арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CertificateDeliveryAcceptance[]
     */
    public $CertificateDeliveryAcceptance;
    /**
     * The ReportExecutionSale
     * Meta informations extracted from the WSDL
     * - documentation: Отчет о результатах реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReportExecutionSale[]
     */
    public $ReportExecutionSale;
    /**
     * The IPSideQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос стороны ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPSideQuery[]
     */
    public $IPSideQuery;
    /**
     * The IPSideAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ стороне ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPSideAnswer[]
     */
    public $IPSideAnswer;
    /**
     * The exitRestrictionActRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос постановления об ограничении выезда
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExitRestrictionActRequest[]
     */
    public $exitRestrictionActRequest;
    /**
     * The exitRestrictionActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии постановления об ограничении выезда
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExitRestrictionActInfo[]
     */
    public $exitRestrictionActInfo;
    /**
     * The RestrictionActRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос сведений об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RestrictionActRequest[]
     */
    public $RestrictionActRequest;
    /**
     * The RestrictionActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RestrictionActInfo[]
     */
    public $RestrictionActInfo;
    /**
     * The ipDataRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос информации о наличии и реквизитах ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPDataRequest[]
     */
    public $ipDataRequest;
    /**
     * The investigationDataInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация об исполнительных производствах по реестру розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvestigationDataInfo[]
     */
    public $investigationDataInfo;
    /**
     * The ipDataInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация об исполнительных производствах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPDataInfo[]
     */
    public $ipDataInfo;
    /**
     * The RecoveredAmountRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:RecoveredAmountRequest
     * @var \StructType\RecoveredAmountRequest[]
     */
    public $RecoveredAmountRequest;
    /**
     * The RecoveredAmountAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:RecoveredAmountAnswer
     * @var \StructType\RecoveredAmountAnswer[]
     */
    public $RecoveredAmountAnswer;
    /**
     * The InvestigationRegistryQuery
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:InvestigationRegistryQuery
     * @var \StructType\InvestigationRegistryQuery[]
     */
    public $InvestigationRegistryQuery;
    /**
     * The ArrestRegistryQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос в реестр арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArrestRegistryQuery[]
     */
    public $ArrestRegistryQuery;
    /**
     * The ArrestRegistryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArrestRegistryInfo[]
     */
    public $ArrestRegistryInfo;
    /**
     * The ArrestRegistryDetail
     * Meta informations extracted from the WSDL
     * - documentation: Строка выписки из реестра арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArrestRegistryDetail[]
     */
    public $ArrestRegistryDetail;
    /**
     * The CrimeRegistryQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение сведений из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CrimeRegistryQuery[]
     */
    public $CrimeRegistryQuery;
    /**
     * The CrimeRegistryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CrimeRegistryInfo[]
     */
    public $CrimeRegistryInfo;
    /**
     * The CrimeRegistryDetail
     * Meta informations extracted from the WSDL
     * - documentation: Строка выписки из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CrimeRegistryDetail[]
     */
    public $CrimeRegistryDetail;
    /**
     * The caRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос в ВУЦ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CaRequest[]
     */
    public $caRequest;
    /**
     * The caAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ ВУЦ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CaAnswer[]
     */
    public $caAnswer;
    /**
     * The investigationRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvestigationRegistry[]
     */
    public $investigationRegistry;
    /**
     * The PenaltyChargesRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр штрафов по АД
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PenaltyChargesRegistry[]
     */
    public $PenaltyChargesRegistry;
    /**
     * The RestrictionRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр ограничений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RestrictionRegistry[]
     */
    public $RestrictionRegistry;
    /**
     * The ReqAppResult
     * Meta informations extracted from the WSDL
     * - documentation: Запрос получения статуса рассмотрения обращений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReqAppResult[]
     */
    public $ReqAppResult;
    /**
     * The AnswerAppResult
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на запрос статуса рассмотрения обращения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnswerAppResult[]
     */
    public $AnswerAppResult;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Технологическое сообщение | Служебные сообщения об ошибках, квитанции о приеме и прочее
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentNote[]
     */
    public $Message;
    /**
     * The debtorIPListRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестра ИП по должнику
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtorIPListRequestType[]
     */
    public $debtorIPListRequest;
    /**
     * The IPSideRequestExistence
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о наличии ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPSideRequestExistenceType[]
     */
    public $IPSideRequestExistence;
    /**
     * The IPSideRequestCourseID
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по исполнительному документу
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPSideRequestCourseIDType[]
     */
    public $IPSideRequestCourseID;
    /**
     * The IPSideRequestCourseIP
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по номеру ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPSideRequestCourseIPType[]
     */
    public $IPSideRequestCourseIP;
    /**
     * The IPReqAppResultRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение ответов на заявления или запросы в ОСП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPReqAppResultRequestType[]
     */
    public $IPReqAppResultRequest;
    /**
     * The DebtorIPListResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Список исполнительных производств по должнику
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DebtorIPListResponseType[]
     */
    public $DebtorIPListResponseType;
    /**
     * The IPReqAppResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Подтверждение регистрации запроса или заявления в ОСП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPReqAppResponseType[]
     */
    public $IPReqAppResponseType;
    /**
     * The IPReqAppResultReponseType
     * Meta informations extracted from the WSDL
     * - documentation: Ответы ОСП на запросы или заявления
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IPReqAppResultReponseType[]
     */
    public $IPReqAppResultReponseType;
    /**
     * The EApplicationType
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EApplicationType[]
     */
    public $EApplicationType;
    /**
     * The EApplicationResultType
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на электронное обращение
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EApplicationResultType[]
     */
    public $EApplicationResultType;
    /**
     * The MailStateTrackingRequest
     * Meta informations extracted from the WSDL
     * - documentation: Документ MailStateTrackingRequest "Запрос статуса корреспонденции" | Тип данных документа «Запрос статуса корреспонденции» используется
     * для передачи из ПКОСП в МВВ запроса на отслеживание стутуса заказных отправлений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MailStateTrackingRequest[]
     */
    public $MailStateTrackingRequest;
    /**
     * The MailState
     * Meta informations extracted from the WSDL
     * - documentation: Документ MailState "Статус корреспонденции" | Тип данных документа «Статус корреспонденции» используется для передачи из МВВ в
     * ПКОСП информации о статусе заказного отправления.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MailState[]
     */
    public $MailState;
    /**
     * The IncomingForcedExecDocument
     * Meta informations extracted from the WSDL
     * - documentation: Входящий документ принудительного исполнения | Тип данных документа «Входящий документ принудительного исполнения»
     * используется приема документов от внешних контрагентов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IncomingForcedExecDocument[]
     */
    public $IncomingForcedExecDocument;
    /**
     * The OutgoingForcedExecDocument
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OutgoingForcedExecDocument[]
     */
    public $OutgoingForcedExecDocument;
    /**
     * The IncomingEMailMessage
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IncomingEMailMessage[]
     */
    public $IncomingEMailMessage;
    /**
     * The OutgoingEMailMessage
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OutgoingEMailMessage[]
     */
    public $OutgoingEMailMessage;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DataBlock
     * @uses DataBlock::setInternalKey()
     * @uses DataBlock::setExternalKey()
     * @uses DataBlock::setFsspTo()
     * @uses DataBlock::setFsspOsp()
     * @uses DataBlock::setOrgAMD()
     * @uses DataBlock::setDivAMD()
     * @uses DataBlock::setSigned()
     * @uses DataBlock::setQuery()
     * @uses DataBlock::setAnswer()
     * @uses DataBlock::setAccountQuery()
     * @uses DataBlock::setAccountAnswer()
     * @uses DataBlock::setSalaryWithheldQuery()
     * @uses DataBlock::setSalaryWithheldAnswer()
     * @uses DataBlock::setRestrictn()
     * @uses DataBlock::setReport()
     * @uses DataBlock::setDebtorNewAccountNotice()
     * @uses DataBlock::setExtDoc()
     * @uses DataBlock::setProcDoc()
     * @uses DataBlock::setExtDebtFix()
     * @uses DataBlock::setRecallDoc()
     * @uses DataBlock::setDebtorPropertyChange()
     * @uses DataBlock::setDebtRequest()
     * @uses DataBlock::setDebt()
     * @uses DataBlock::setExtPayments()
     * @uses DataBlock::setOspRequest()
     * @uses DataBlock::setOspProperties()
     * @uses DataBlock::setBankruptDoc()
     * @uses DataBlock::setArrestFourthStageProperty()
     * @uses DataBlock::setDebtorIpNotify()
     * @uses DataBlock::setNoticeReadinessSaleSeizedProperty()
     * @uses DataBlock::setNoticeSaleSeizedProperty()
     * @uses DataBlock::setCertificateDeliveryAcceptance()
     * @uses DataBlock::setReportExecutionSale()
     * @uses DataBlock::setIPSideQuery()
     * @uses DataBlock::setIPSideAnswer()
     * @uses DataBlock::setExitRestrictionActRequest()
     * @uses DataBlock::setExitRestrictionActInfo()
     * @uses DataBlock::setRestrictionActRequest()
     * @uses DataBlock::setRestrictionActInfo()
     * @uses DataBlock::setIpDataRequest()
     * @uses DataBlock::setInvestigationDataInfo()
     * @uses DataBlock::setIpDataInfo()
     * @uses DataBlock::setRecoveredAmountRequest()
     * @uses DataBlock::setRecoveredAmountAnswer()
     * @uses DataBlock::setInvestigationRegistryQuery()
     * @uses DataBlock::setArrestRegistryQuery()
     * @uses DataBlock::setArrestRegistryInfo()
     * @uses DataBlock::setArrestRegistryDetail()
     * @uses DataBlock::setCrimeRegistryQuery()
     * @uses DataBlock::setCrimeRegistryInfo()
     * @uses DataBlock::setCrimeRegistryDetail()
     * @uses DataBlock::setCaRequest()
     * @uses DataBlock::setCaAnswer()
     * @uses DataBlock::setInvestigationRegistry()
     * @uses DataBlock::setPenaltyChargesRegistry()
     * @uses DataBlock::setRestrictionRegistry()
     * @uses DataBlock::setReqAppResult()
     * @uses DataBlock::setAnswerAppResult()
     * @uses DataBlock::setMessage()
     * @uses DataBlock::setDebtorIPListRequest()
     * @uses DataBlock::setIPSideRequestExistence()
     * @uses DataBlock::setIPSideRequestCourseID()
     * @uses DataBlock::setIPSideRequestCourseIP()
     * @uses DataBlock::setIPReqAppResultRequest()
     * @uses DataBlock::setDebtorIPListResponseType()
     * @uses DataBlock::setIPReqAppResponseType()
     * @uses DataBlock::setIPReqAppResultReponseType()
     * @uses DataBlock::setEApplicationType()
     * @uses DataBlock::setEApplicationResultType()
     * @uses DataBlock::setMailStateTrackingRequest()
     * @uses DataBlock::setMailState()
     * @uses DataBlock::setIncomingForcedExecDocument()
     * @uses DataBlock::setOutgoingForcedExecDocument()
     * @uses DataBlock::setIncomingEMailMessage()
     * @uses DataBlock::setOutgoingEMailMessage()
     * @uses DataBlock::setId()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $fsspTo
     * @param string $fsspOsp
     * @param string $orgAMD
     * @param string $divAMD
     * @param string $signed
     * @param \StructType\Query[] $query
     * @param \StructType\Answer[] $answer
     * @param \StructType\AccountQuery[] $accountQuery
     * @param \StructType\AccountAnswer[] $accountAnswer
     * @param \StructType\SalaryWithheldQuery[] $salaryWithheldQuery
     * @param \StructType\SalaryWithheldAnswer[] $salaryWithheldAnswer
     * @param \StructType\Restrictn[] $restrictn
     * @param \StructType\Report[] $report
     * @param \StructType\DebtorNewAccountNotice[] $debtorNewAccountNotice
     * @param \StructType\ExtDoc[] $extDoc
     * @param \StructType\ProcDoc[] $procDoc
     * @param \StructType\ExtDebtFix[] $extDebtFix
     * @param \StructType\RecallDoc[] $recallDoc
     * @param \StructType\DebtorPropertyChange[] $debtorPropertyChange
     * @param \StructType\DebtRequest[] $debtRequest
     * @param \StructType\Debt $debt
     * @param \StructType\ExtPayments[] $extPayments
     * @param \StructType\OspRequest[] $ospRequest
     * @param \StructType\OspProperties[] $ospProperties
     * @param \StructType\BankruptDoc[] $bankruptDoc
     * @param \StructType\ArrestFourthStagePropertyType[] $arrestFourthStageProperty
     * @param \StructType\DebtorIpNotify[] $debtorIpNotify
     * @param \StructType\NoticeReadinessSaleSeizedProperty[] $noticeReadinessSaleSeizedProperty
     * @param \StructType\NoticeSaleSeizedProperty[] $noticeSaleSeizedProperty
     * @param \StructType\CertificateDeliveryAcceptance[] $certificateDeliveryAcceptance
     * @param \StructType\ReportExecutionSale[] $reportExecutionSale
     * @param \StructType\IPSideQuery[] $iPSideQuery
     * @param \StructType\IPSideAnswer[] $iPSideAnswer
     * @param \StructType\ExitRestrictionActRequest[] $exitRestrictionActRequest
     * @param \StructType\ExitRestrictionActInfo[] $exitRestrictionActInfo
     * @param \StructType\RestrictionActRequest[] $restrictionActRequest
     * @param \StructType\RestrictionActInfo[] $restrictionActInfo
     * @param \StructType\IPDataRequest[] $ipDataRequest
     * @param \StructType\InvestigationDataInfo[] $investigationDataInfo
     * @param \StructType\IPDataInfo[] $ipDataInfo
     * @param \StructType\RecoveredAmountRequest[] $recoveredAmountRequest
     * @param \StructType\RecoveredAmountAnswer[] $recoveredAmountAnswer
     * @param \StructType\InvestigationRegistryQuery[] $investigationRegistryQuery
     * @param \StructType\ArrestRegistryQuery[] $arrestRegistryQuery
     * @param \StructType\ArrestRegistryInfo[] $arrestRegistryInfo
     * @param \StructType\ArrestRegistryDetail[] $arrestRegistryDetail
     * @param \StructType\CrimeRegistryQuery[] $crimeRegistryQuery
     * @param \StructType\CrimeRegistryInfo[] $crimeRegistryInfo
     * @param \StructType\CrimeRegistryDetail[] $crimeRegistryDetail
     * @param \StructType\CaRequest[] $caRequest
     * @param \StructType\CaAnswer[] $caAnswer
     * @param \StructType\InvestigationRegistry[] $investigationRegistry
     * @param \StructType\PenaltyChargesRegistry[] $penaltyChargesRegistry
     * @param \StructType\RestrictionRegistry[] $restrictionRegistry
     * @param \StructType\ReqAppResult[] $reqAppResult
     * @param \StructType\AnswerAppResult[] $answerAppResult
     * @param \StructType\DocumentNote[] $message
     * @param \StructType\DebtorIPListRequestType[] $debtorIPListRequest
     * @param \StructType\IPSideRequestExistenceType[] $iPSideRequestExistence
     * @param \StructType\IPSideRequestCourseIDType[] $iPSideRequestCourseID
     * @param \StructType\IPSideRequestCourseIPType[] $iPSideRequestCourseIP
     * @param \StructType\IPReqAppResultRequestType[] $iPReqAppResultRequest
     * @param \StructType\DebtorIPListResponseType[] $debtorIPListResponseType
     * @param \StructType\IPReqAppResponseType[] $iPReqAppResponseType
     * @param \StructType\IPReqAppResultReponseType[] $iPReqAppResultReponseType
     * @param \StructType\EApplicationType[] $eApplicationType
     * @param \StructType\EApplicationResultType[] $eApplicationResultType
     * @param \StructType\MailStateTrackingRequest[] $mailStateTrackingRequest
     * @param \StructType\MailState[] $mailState
     * @param \StructType\IncomingForcedExecDocument[] $incomingForcedExecDocument
     * @param \StructType\OutgoingForcedExecDocument[] $outgoingForcedExecDocument
     * @param \StructType\IncomingEMailMessage[] $incomingEMailMessage
     * @param \StructType\OutgoingEMailMessage[] $outgoingEMailMessage
     * @param string $id
     */
    public function __construct($internalKey = null, $externalKey = null, $fsspTo = null, $fsspOsp = null, $orgAMD = null, $divAMD = null, $signed = null, array $query = array(), array $answer = array(), array $accountQuery = array(), array $accountAnswer = array(), array $salaryWithheldQuery = array(), array $salaryWithheldAnswer = array(), array $restrictn = array(), array $report = array(), array $debtorNewAccountNotice = array(), array $extDoc = array(), array $procDoc = array(), array $extDebtFix = array(), array $recallDoc = array(), array $debtorPropertyChange = array(), array $debtRequest = array(), \StructType\Debt $debt = null, array $extPayments = array(), array $ospRequest = array(), array $ospProperties = array(), array $bankruptDoc = array(), array $arrestFourthStageProperty = array(), array $debtorIpNotify = array(), array $noticeReadinessSaleSeizedProperty = array(), array $noticeSaleSeizedProperty = array(), array $certificateDeliveryAcceptance = array(), array $reportExecutionSale = array(), array $iPSideQuery = array(), array $iPSideAnswer = array(), array $exitRestrictionActRequest = array(), array $exitRestrictionActInfo = array(), array $restrictionActRequest = array(), array $restrictionActInfo = array(), array $ipDataRequest = array(), array $investigationDataInfo = array(), array $ipDataInfo = array(), array $recoveredAmountRequest = array(), array $recoveredAmountAnswer = array(), array $investigationRegistryQuery = array(), array $arrestRegistryQuery = array(), array $arrestRegistryInfo = array(), array $arrestRegistryDetail = array(), array $crimeRegistryQuery = array(), array $crimeRegistryInfo = array(), array $crimeRegistryDetail = array(), array $caRequest = array(), array $caAnswer = array(), array $investigationRegistry = array(), array $penaltyChargesRegistry = array(), array $restrictionRegistry = array(), array $reqAppResult = array(), array $answerAppResult = array(), array $message = array(), array $debtorIPListRequest = array(), array $iPSideRequestExistence = array(), array $iPSideRequestCourseID = array(), array $iPSideRequestCourseIP = array(), array $iPReqAppResultRequest = array(), array $debtorIPListResponseType = array(), array $iPReqAppResponseType = array(), array $iPReqAppResultReponseType = array(), array $eApplicationType = array(), array $eApplicationResultType = array(), array $mailStateTrackingRequest = array(), array $mailState = array(), array $incomingForcedExecDocument = array(), array $outgoingForcedExecDocument = array(), array $incomingEMailMessage = array(), array $outgoingEMailMessage = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setFsspTo($fsspTo)
            ->setFsspOsp($fsspOsp)
            ->setOrgAMD($orgAMD)
            ->setDivAMD($divAMD)
            ->setSigned($signed)
            ->setQuery($query)
            ->setAnswer($answer)
            ->setAccountQuery($accountQuery)
            ->setAccountAnswer($accountAnswer)
            ->setSalaryWithheldQuery($salaryWithheldQuery)
            ->setSalaryWithheldAnswer($salaryWithheldAnswer)
            ->setRestrictn($restrictn)
            ->setReport($report)
            ->setDebtorNewAccountNotice($debtorNewAccountNotice)
            ->setExtDoc($extDoc)
            ->setProcDoc($procDoc)
            ->setExtDebtFix($extDebtFix)
            ->setRecallDoc($recallDoc)
            ->setDebtorPropertyChange($debtorPropertyChange)
            ->setDebtRequest($debtRequest)
            ->setDebt($debt)
            ->setExtPayments($extPayments)
            ->setOspRequest($ospRequest)
            ->setOspProperties($ospProperties)
            ->setBankruptDoc($bankruptDoc)
            ->setArrestFourthStageProperty($arrestFourthStageProperty)
            ->setDebtorIpNotify($debtorIpNotify)
            ->setNoticeReadinessSaleSeizedProperty($noticeReadinessSaleSeizedProperty)
            ->setNoticeSaleSeizedProperty($noticeSaleSeizedProperty)
            ->setCertificateDeliveryAcceptance($certificateDeliveryAcceptance)
            ->setReportExecutionSale($reportExecutionSale)
            ->setIPSideQuery($iPSideQuery)
            ->setIPSideAnswer($iPSideAnswer)
            ->setExitRestrictionActRequest($exitRestrictionActRequest)
            ->setExitRestrictionActInfo($exitRestrictionActInfo)
            ->setRestrictionActRequest($restrictionActRequest)
            ->setRestrictionActInfo($restrictionActInfo)
            ->setIpDataRequest($ipDataRequest)
            ->setInvestigationDataInfo($investigationDataInfo)
            ->setIpDataInfo($ipDataInfo)
            ->setRecoveredAmountRequest($recoveredAmountRequest)
            ->setRecoveredAmountAnswer($recoveredAmountAnswer)
            ->setInvestigationRegistryQuery($investigationRegistryQuery)
            ->setArrestRegistryQuery($arrestRegistryQuery)
            ->setArrestRegistryInfo($arrestRegistryInfo)
            ->setArrestRegistryDetail($arrestRegistryDetail)
            ->setCrimeRegistryQuery($crimeRegistryQuery)
            ->setCrimeRegistryInfo($crimeRegistryInfo)
            ->setCrimeRegistryDetail($crimeRegistryDetail)
            ->setCaRequest($caRequest)
            ->setCaAnswer($caAnswer)
            ->setInvestigationRegistry($investigationRegistry)
            ->setPenaltyChargesRegistry($penaltyChargesRegistry)
            ->setRestrictionRegistry($restrictionRegistry)
            ->setReqAppResult($reqAppResult)
            ->setAnswerAppResult($answerAppResult)
            ->setMessage($message)
            ->setDebtorIPListRequest($debtorIPListRequest)
            ->setIPSideRequestExistence($iPSideRequestExistence)
            ->setIPSideRequestCourseID($iPSideRequestCourseID)
            ->setIPSideRequestCourseIP($iPSideRequestCourseIP)
            ->setIPReqAppResultRequest($iPReqAppResultRequest)
            ->setDebtorIPListResponseType($debtorIPListResponseType)
            ->setIPReqAppResponseType($iPReqAppResponseType)
            ->setIPReqAppResultReponseType($iPReqAppResultReponseType)
            ->setEApplicationType($eApplicationType)
            ->setEApplicationResultType($eApplicationResultType)
            ->setMailStateTrackingRequest($mailStateTrackingRequest)
            ->setMailState($mailState)
            ->setIncomingForcedExecDocument($incomingForcedExecDocument)
            ->setOutgoingForcedExecDocument($outgoingForcedExecDocument)
            ->setIncomingEMailMessage($incomingEMailMessage)
            ->setOutgoingEMailMessage($outgoingEMailMessage)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\DataBlock
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DataBlock
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get FsspTo value
     * @return string|null
     */
    public function getFsspTo()
    {
        return $this->FsspTo;
    }
    /**
     * Set FsspTo value
     * @param string $fsspTo
     * @return \StructType\DataBlock
     */
    public function setFsspTo($fsspTo = null)
    {
        $this->FsspTo = $fsspTo;
        return $this;
    }
    /**
     * Get FsspOsp value
     * @return string|null
     */
    public function getFsspOsp()
    {
        return $this->FsspOsp;
    }
    /**
     * Set FsspOsp value
     * @param string $fsspOsp
     * @return \StructType\DataBlock
     */
    public function setFsspOsp($fsspOsp = null)
    {
        $this->FsspOsp = $fsspOsp;
        return $this;
    }
    /**
     * Get OrgAMD value
     * @return string|null
     */
    public function getOrgAMD()
    {
        return $this->OrgAMD;
    }
    /**
     * Set OrgAMD value
     * @param string $orgAMD
     * @return \StructType\DataBlock
     */
    public function setOrgAMD($orgAMD = null)
    {
        $this->OrgAMD = $orgAMD;
        return $this;
    }
    /**
     * Get DivAMD value
     * @return string|null
     */
    public function getDivAMD()
    {
        return $this->DivAMD;
    }
    /**
     * Set DivAMD value
     * @param string $divAMD
     * @return \StructType\DataBlock
     */
    public function setDivAMD($divAMD = null)
    {
        $this->DivAMD = $divAMD;
        return $this;
    }
    /**
     * Get Signed value
     * @return string|null
     */
    public function getSigned()
    {
        return $this->Signed;
    }
    /**
     * Set Signed value
     * @param string $signed
     * @return \StructType\DataBlock
     */
    public function setSigned($signed = null)
    {
        $this->Signed = $signed;
        return $this;
    }
    /**
     * Get Query value
     * @return \StructType\Query[]|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @throws \InvalidArgumentException
     * @param \StructType\Query[] $query
     * @return \StructType\DataBlock
     */
    public function setQuery(array $query = array())
    {
        $this->Query = $query;
        return $this;
    }
    /**
     * Add item to Query value
     * @throws \InvalidArgumentException
     * @param \StructType\Query $item
     * @return \StructType\DataBlock
     */
    public function addToQuery(\StructType\Query $item)
    {
        $this->Query[] = $item;
        return $this;
    }
    /**
     * Get Answer value
     * @return \StructType\Answer[]|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer[] $answer
     * @return \StructType\DataBlock
     */
    public function setAnswer(array $answer = array())
    {
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Add item to Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\Answer $item
     * @return \StructType\DataBlock
     */
    public function addToAnswer(\StructType\Answer $item)
    {
        $this->Answer[] = $item;
        return $this;
    }
    /**
     * Get AccountQuery value
     * @return \StructType\AccountQuery[]|null
     */
    public function getAccountQuery()
    {
        return $this->AccountQuery;
    }
    /**
     * Set AccountQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountQuery[] $accountQuery
     * @return \StructType\DataBlock
     */
    public function setAccountQuery(array $accountQuery = array())
    {
        $this->AccountQuery = $accountQuery;
        return $this;
    }
    /**
     * Add item to AccountQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountQuery $item
     * @return \StructType\DataBlock
     */
    public function addToAccountQuery(\StructType\AccountQuery $item)
    {
        $this->AccountQuery[] = $item;
        return $this;
    }
    /**
     * Get AccountAnswer value
     * @return \StructType\AccountAnswer[]|null
     */
    public function getAccountAnswer()
    {
        return $this->AccountAnswer;
    }
    /**
     * Set AccountAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountAnswer[] $accountAnswer
     * @return \StructType\DataBlock
     */
    public function setAccountAnswer(array $accountAnswer = array())
    {
        $this->AccountAnswer = $accountAnswer;
        return $this;
    }
    /**
     * Add item to AccountAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountAnswer $item
     * @return \StructType\DataBlock
     */
    public function addToAccountAnswer(\StructType\AccountAnswer $item)
    {
        $this->AccountAnswer[] = $item;
        return $this;
    }
    /**
     * Get SalaryWithheldQuery value
     * @return \StructType\SalaryWithheldQuery[]|null
     */
    public function getSalaryWithheldQuery()
    {
        return $this->SalaryWithheldQuery;
    }
    /**
     * Set SalaryWithheldQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\SalaryWithheldQuery[] $salaryWithheldQuery
     * @return \StructType\DataBlock
     */
    public function setSalaryWithheldQuery(array $salaryWithheldQuery = array())
    {
        $this->SalaryWithheldQuery = $salaryWithheldQuery;
        return $this;
    }
    /**
     * Add item to SalaryWithheldQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\SalaryWithheldQuery $item
     * @return \StructType\DataBlock
     */
    public function addToSalaryWithheldQuery(\StructType\SalaryWithheldQuery $item)
    {
        $this->SalaryWithheldQuery[] = $item;
        return $this;
    }
    /**
     * Get SalaryWithheldAnswer value
     * @return \StructType\SalaryWithheldAnswer[]|null
     */
    public function getSalaryWithheldAnswer()
    {
        return $this->SalaryWithheldAnswer;
    }
    /**
     * Set SalaryWithheldAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\SalaryWithheldAnswer[] $salaryWithheldAnswer
     * @return \StructType\DataBlock
     */
    public function setSalaryWithheldAnswer(array $salaryWithheldAnswer = array())
    {
        $this->SalaryWithheldAnswer = $salaryWithheldAnswer;
        return $this;
    }
    /**
     * Add item to SalaryWithheldAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\SalaryWithheldAnswer $item
     * @return \StructType\DataBlock
     */
    public function addToSalaryWithheldAnswer(\StructType\SalaryWithheldAnswer $item)
    {
        $this->SalaryWithheldAnswer[] = $item;
        return $this;
    }
    /**
     * Get Restrictn value
     * @return \StructType\Restrictn[]|null
     */
    public function getRestrictn()
    {
        return $this->Restrictn;
    }
    /**
     * Set Restrictn value
     * @throws \InvalidArgumentException
     * @param \StructType\Restrictn[] $restrictn
     * @return \StructType\DataBlock
     */
    public function setRestrictn(array $restrictn = array())
    {
        $this->Restrictn = $restrictn;
        return $this;
    }
    /**
     * Add item to Restrictn value
     * @throws \InvalidArgumentException
     * @param \StructType\Restrictn $item
     * @return \StructType\DataBlock
     */
    public function addToRestrictn(\StructType\Restrictn $item)
    {
        $this->Restrictn[] = $item;
        return $this;
    }
    /**
     * Get Report value
     * @return \StructType\Report[]|null
     */
    public function getReport()
    {
        return $this->Report;
    }
    /**
     * Set Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report[] $report
     * @return \StructType\DataBlock
     */
    public function setReport(array $report = array())
    {
        $this->Report = $report;
        return $this;
    }
    /**
     * Add item to Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report $item
     * @return \StructType\DataBlock
     */
    public function addToReport(\StructType\Report $item)
    {
        $this->Report[] = $item;
        return $this;
    }
    /**
     * Get DebtorNewAccountNotice value
     * @return \StructType\DebtorNewAccountNotice[]|null
     */
    public function getDebtorNewAccountNotice()
    {
        return $this->DebtorNewAccountNotice;
    }
    /**
     * Set DebtorNewAccountNotice value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorNewAccountNotice[] $debtorNewAccountNotice
     * @return \StructType\DataBlock
     */
    public function setDebtorNewAccountNotice(array $debtorNewAccountNotice = array())
    {
        $this->DebtorNewAccountNotice = $debtorNewAccountNotice;
        return $this;
    }
    /**
     * Add item to DebtorNewAccountNotice value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorNewAccountNotice $item
     * @return \StructType\DataBlock
     */
    public function addToDebtorNewAccountNotice(\StructType\DebtorNewAccountNotice $item)
    {
        $this->DebtorNewAccountNotice[] = $item;
        return $this;
    }
    /**
     * Get ExtDoc value
     * @return \StructType\ExtDoc[]|null
     */
    public function getExtDoc()
    {
        return $this->ExtDoc;
    }
    /**
     * Set ExtDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtDoc[] $extDoc
     * @return \StructType\DataBlock
     */
    public function setExtDoc(array $extDoc = array())
    {
        $this->ExtDoc = $extDoc;
        return $this;
    }
    /**
     * Add item to ExtDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtDoc $item
     * @return \StructType\DataBlock
     */
    public function addToExtDoc(\StructType\ExtDoc $item)
    {
        $this->ExtDoc[] = $item;
        return $this;
    }
    /**
     * Get ProcDoc value
     * @return \StructType\ProcDoc[]|null
     */
    public function getProcDoc()
    {
        return $this->ProcDoc;
    }
    /**
     * Set ProcDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcDoc[] $procDoc
     * @return \StructType\DataBlock
     */
    public function setProcDoc(array $procDoc = array())
    {
        $this->ProcDoc = $procDoc;
        return $this;
    }
    /**
     * Add item to ProcDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcDoc $item
     * @return \StructType\DataBlock
     */
    public function addToProcDoc(\StructType\ProcDoc $item)
    {
        $this->ProcDoc[] = $item;
        return $this;
    }
    /**
     * Get ExtDebtFix value
     * @return \StructType\ExtDebtFix[]|null
     */
    public function getExtDebtFix()
    {
        return $this->ExtDebtFix;
    }
    /**
     * Set ExtDebtFix value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtDebtFix[] $extDebtFix
     * @return \StructType\DataBlock
     */
    public function setExtDebtFix(array $extDebtFix = array())
    {
        $this->ExtDebtFix = $extDebtFix;
        return $this;
    }
    /**
     * Add item to ExtDebtFix value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtDebtFix $item
     * @return \StructType\DataBlock
     */
    public function addToExtDebtFix(\StructType\ExtDebtFix $item)
    {
        $this->ExtDebtFix[] = $item;
        return $this;
    }
    /**
     * Get RecallDoc value
     * @return \StructType\RecallDoc[]|null
     */
    public function getRecallDoc()
    {
        return $this->RecallDoc;
    }
    /**
     * Set RecallDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\RecallDoc[] $recallDoc
     * @return \StructType\DataBlock
     */
    public function setRecallDoc(array $recallDoc = array())
    {
        $this->RecallDoc = $recallDoc;
        return $this;
    }
    /**
     * Add item to RecallDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\RecallDoc $item
     * @return \StructType\DataBlock
     */
    public function addToRecallDoc(\StructType\RecallDoc $item)
    {
        $this->RecallDoc[] = $item;
        return $this;
    }
    /**
     * Get DebtorPropertyChange value
     * @return \StructType\DebtorPropertyChange[]|null
     */
    public function getDebtorPropertyChange()
    {
        return $this->DebtorPropertyChange;
    }
    /**
     * Set DebtorPropertyChange value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorPropertyChange[] $debtorPropertyChange
     * @return \StructType\DataBlock
     */
    public function setDebtorPropertyChange(array $debtorPropertyChange = array())
    {
        $this->DebtorPropertyChange = $debtorPropertyChange;
        return $this;
    }
    /**
     * Add item to DebtorPropertyChange value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorPropertyChange $item
     * @return \StructType\DataBlock
     */
    public function addToDebtorPropertyChange(\StructType\DebtorPropertyChange $item)
    {
        $this->DebtorPropertyChange[] = $item;
        return $this;
    }
    /**
     * Get DebtRequest value
     * @return \StructType\DebtRequest[]|null
     */
    public function getDebtRequest()
    {
        return $this->DebtRequest;
    }
    /**
     * Set DebtRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtRequest[] $debtRequest
     * @return \StructType\DataBlock
     */
    public function setDebtRequest(array $debtRequest = array())
    {
        $this->DebtRequest = $debtRequest;
        return $this;
    }
    /**
     * Add item to DebtRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtRequest $item
     * @return \StructType\DataBlock
     */
    public function addToDebtRequest(\StructType\DebtRequest $item)
    {
        $this->DebtRequest[] = $item;
        return $this;
    }
    /**
     * Get Debt value
     * @return \StructType\Debt|null
     */
    public function getDebt()
    {
        return $this->Debt;
    }
    /**
     * Set Debt value
     * @param \StructType\Debt $debt
     * @return \StructType\DataBlock
     */
    public function setDebt(\StructType\Debt $debt = null)
    {
        $this->Debt = $debt;
        return $this;
    }
    /**
     * Get ExtPayments value
     * @return \StructType\ExtPayments[]|null
     */
    public function getExtPayments()
    {
        return $this->ExtPayments;
    }
    /**
     * Set ExtPayments value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtPayments[] $extPayments
     * @return \StructType\DataBlock
     */
    public function setExtPayments(array $extPayments = array())
    {
        $this->ExtPayments = $extPayments;
        return $this;
    }
    /**
     * Add item to ExtPayments value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtPayments $item
     * @return \StructType\DataBlock
     */
    public function addToExtPayments(\StructType\ExtPayments $item)
    {
        $this->ExtPayments[] = $item;
        return $this;
    }
    /**
     * Get OspRequest value
     * @return \StructType\OspRequest[]|null
     */
    public function getOspRequest()
    {
        return $this->OspRequest;
    }
    /**
     * Set OspRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OspRequest[] $ospRequest
     * @return \StructType\DataBlock
     */
    public function setOspRequest(array $ospRequest = array())
    {
        $this->OspRequest = $ospRequest;
        return $this;
    }
    /**
     * Add item to OspRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OspRequest $item
     * @return \StructType\DataBlock
     */
    public function addToOspRequest(\StructType\OspRequest $item)
    {
        $this->OspRequest[] = $item;
        return $this;
    }
    /**
     * Get OspProperties value
     * @return \StructType\OspProperties[]|null
     */
    public function getOspProperties()
    {
        return $this->OspProperties;
    }
    /**
     * Set OspProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\OspProperties[] $ospProperties
     * @return \StructType\DataBlock
     */
    public function setOspProperties(array $ospProperties = array())
    {
        $this->OspProperties = $ospProperties;
        return $this;
    }
    /**
     * Add item to OspProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\OspProperties $item
     * @return \StructType\DataBlock
     */
    public function addToOspProperties(\StructType\OspProperties $item)
    {
        $this->OspProperties[] = $item;
        return $this;
    }
    /**
     * Get BankruptDoc value
     * @return \StructType\BankruptDoc[]|null
     */
    public function getBankruptDoc()
    {
        return $this->BankruptDoc;
    }
    /**
     * Set BankruptDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\BankruptDoc[] $bankruptDoc
     * @return \StructType\DataBlock
     */
    public function setBankruptDoc(array $bankruptDoc = array())
    {
        $this->BankruptDoc = $bankruptDoc;
        return $this;
    }
    /**
     * Add item to BankruptDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\BankruptDoc $item
     * @return \StructType\DataBlock
     */
    public function addToBankruptDoc(\StructType\BankruptDoc $item)
    {
        $this->BankruptDoc[] = $item;
        return $this;
    }
    /**
     * Get ArrestFourthStageProperty value
     * @return \StructType\ArrestFourthStagePropertyType[]|null
     */
    public function getArrestFourthStageProperty()
    {
        return $this->ArrestFourthStageProperty;
    }
    /**
     * Set ArrestFourthStageProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestFourthStagePropertyType[] $arrestFourthStageProperty
     * @return \StructType\DataBlock
     */
    public function setArrestFourthStageProperty(array $arrestFourthStageProperty = array())
    {
        $this->ArrestFourthStageProperty = $arrestFourthStageProperty;
        return $this;
    }
    /**
     * Add item to ArrestFourthStageProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestFourthStagePropertyType $item
     * @return \StructType\DataBlock
     */
    public function addToArrestFourthStageProperty(\StructType\ArrestFourthStagePropertyType $item)
    {
        $this->ArrestFourthStageProperty[] = $item;
        return $this;
    }
    /**
     * Get DebtorIpNotify value
     * @return \StructType\DebtorIpNotify[]|null
     */
    public function getDebtorIpNotify()
    {
        return $this->DebtorIpNotify;
    }
    /**
     * Set DebtorIpNotify value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIpNotify[] $debtorIpNotify
     * @return \StructType\DataBlock
     */
    public function setDebtorIpNotify(array $debtorIpNotify = array())
    {
        $this->DebtorIpNotify = $debtorIpNotify;
        return $this;
    }
    /**
     * Add item to DebtorIpNotify value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIpNotify $item
     * @return \StructType\DataBlock
     */
    public function addToDebtorIpNotify(\StructType\DebtorIpNotify $item)
    {
        $this->DebtorIpNotify[] = $item;
        return $this;
    }
    /**
     * Get NoticeReadinessSaleSeizedProperty value
     * @return \StructType\NoticeReadinessSaleSeizedProperty[]|null
     */
    public function getNoticeReadinessSaleSeizedProperty()
    {
        return $this->NoticeReadinessSaleSeizedProperty;
    }
    /**
     * Set NoticeReadinessSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\NoticeReadinessSaleSeizedProperty[] $noticeReadinessSaleSeizedProperty
     * @return \StructType\DataBlock
     */
    public function setNoticeReadinessSaleSeizedProperty(array $noticeReadinessSaleSeizedProperty = array())
    {
        $this->NoticeReadinessSaleSeizedProperty = $noticeReadinessSaleSeizedProperty;
        return $this;
    }
    /**
     * Add item to NoticeReadinessSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\NoticeReadinessSaleSeizedProperty $item
     * @return \StructType\DataBlock
     */
    public function addToNoticeReadinessSaleSeizedProperty(\StructType\NoticeReadinessSaleSeizedProperty $item)
    {
        $this->NoticeReadinessSaleSeizedProperty[] = $item;
        return $this;
    }
    /**
     * Get NoticeSaleSeizedProperty value
     * @return \StructType\NoticeSaleSeizedProperty[]|null
     */
    public function getNoticeSaleSeizedProperty()
    {
        return $this->NoticeSaleSeizedProperty;
    }
    /**
     * Set NoticeSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\NoticeSaleSeizedProperty[] $noticeSaleSeizedProperty
     * @return \StructType\DataBlock
     */
    public function setNoticeSaleSeizedProperty(array $noticeSaleSeizedProperty = array())
    {
        $this->NoticeSaleSeizedProperty = $noticeSaleSeizedProperty;
        return $this;
    }
    /**
     * Add item to NoticeSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\NoticeSaleSeizedProperty $item
     * @return \StructType\DataBlock
     */
    public function addToNoticeSaleSeizedProperty(\StructType\NoticeSaleSeizedProperty $item)
    {
        $this->NoticeSaleSeizedProperty[] = $item;
        return $this;
    }
    /**
     * Get CertificateDeliveryAcceptance value
     * @return \StructType\CertificateDeliveryAcceptance[]|null
     */
    public function getCertificateDeliveryAcceptance()
    {
        return $this->CertificateDeliveryAcceptance;
    }
    /**
     * Set CertificateDeliveryAcceptance value
     * @throws \InvalidArgumentException
     * @param \StructType\CertificateDeliveryAcceptance[] $certificateDeliveryAcceptance
     * @return \StructType\DataBlock
     */
    public function setCertificateDeliveryAcceptance(array $certificateDeliveryAcceptance = array())
    {
        $this->CertificateDeliveryAcceptance = $certificateDeliveryAcceptance;
        return $this;
    }
    /**
     * Add item to CertificateDeliveryAcceptance value
     * @throws \InvalidArgumentException
     * @param \StructType\CertificateDeliveryAcceptance $item
     * @return \StructType\DataBlock
     */
    public function addToCertificateDeliveryAcceptance(\StructType\CertificateDeliveryAcceptance $item)
    {
        $this->CertificateDeliveryAcceptance[] = $item;
        return $this;
    }
    /**
     * Get ReportExecutionSale value
     * @return \StructType\ReportExecutionSale[]|null
     */
    public function getReportExecutionSale()
    {
        return $this->ReportExecutionSale;
    }
    /**
     * Set ReportExecutionSale value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportExecutionSale[] $reportExecutionSale
     * @return \StructType\DataBlock
     */
    public function setReportExecutionSale(array $reportExecutionSale = array())
    {
        $this->ReportExecutionSale = $reportExecutionSale;
        return $this;
    }
    /**
     * Add item to ReportExecutionSale value
     * @throws \InvalidArgumentException
     * @param \StructType\ReportExecutionSale $item
     * @return \StructType\DataBlock
     */
    public function addToReportExecutionSale(\StructType\ReportExecutionSale $item)
    {
        $this->ReportExecutionSale[] = $item;
        return $this;
    }
    /**
     * Get IPSideQuery value
     * @return \StructType\IPSideQuery[]|null
     */
    public function getIPSideQuery()
    {
        return $this->IPSideQuery;
    }
    /**
     * Set IPSideQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideQuery[] $iPSideQuery
     * @return \StructType\DataBlock
     */
    public function setIPSideQuery(array $iPSideQuery = array())
    {
        $this->IPSideQuery = $iPSideQuery;
        return $this;
    }
    /**
     * Add item to IPSideQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideQuery $item
     * @return \StructType\DataBlock
     */
    public function addToIPSideQuery(\StructType\IPSideQuery $item)
    {
        $this->IPSideQuery[] = $item;
        return $this;
    }
    /**
     * Get IPSideAnswer value
     * @return \StructType\IPSideAnswer[]|null
     */
    public function getIPSideAnswer()
    {
        return $this->IPSideAnswer;
    }
    /**
     * Set IPSideAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideAnswer[] $iPSideAnswer
     * @return \StructType\DataBlock
     */
    public function setIPSideAnswer(array $iPSideAnswer = array())
    {
        $this->IPSideAnswer = $iPSideAnswer;
        return $this;
    }
    /**
     * Add item to IPSideAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideAnswer $item
     * @return \StructType\DataBlock
     */
    public function addToIPSideAnswer(\StructType\IPSideAnswer $item)
    {
        $this->IPSideAnswer[] = $item;
        return $this;
    }
    /**
     * Get exitRestrictionActRequest value
     * @return \StructType\ExitRestrictionActRequest[]|null
     */
    public function getExitRestrictionActRequest()
    {
        return $this->exitRestrictionActRequest;
    }
    /**
     * Set exitRestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ExitRestrictionActRequest[] $exitRestrictionActRequest
     * @return \StructType\DataBlock
     */
    public function setExitRestrictionActRequest(array $exitRestrictionActRequest = array())
    {
        $this->exitRestrictionActRequest = $exitRestrictionActRequest;
        return $this;
    }
    /**
     * Add item to exitRestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ExitRestrictionActRequest $item
     * @return \StructType\DataBlock
     */
    public function addToExitRestrictionActRequest(\StructType\ExitRestrictionActRequest $item)
    {
        $this->exitRestrictionActRequest[] = $item;
        return $this;
    }
    /**
     * Get exitRestrictionActInfo value
     * @return \StructType\ExitRestrictionActInfo[]|null
     */
    public function getExitRestrictionActInfo()
    {
        return $this->exitRestrictionActInfo;
    }
    /**
     * Set exitRestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExitRestrictionActInfo[] $exitRestrictionActInfo
     * @return \StructType\DataBlock
     */
    public function setExitRestrictionActInfo(array $exitRestrictionActInfo = array())
    {
        $this->exitRestrictionActInfo = $exitRestrictionActInfo;
        return $this;
    }
    /**
     * Add item to exitRestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExitRestrictionActInfo $item
     * @return \StructType\DataBlock
     */
    public function addToExitRestrictionActInfo(\StructType\ExitRestrictionActInfo $item)
    {
        $this->exitRestrictionActInfo[] = $item;
        return $this;
    }
    /**
     * Get RestrictionActRequest value
     * @return \StructType\RestrictionActRequest[]|null
     */
    public function getRestrictionActRequest()
    {
        return $this->RestrictionActRequest;
    }
    /**
     * Set RestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionActRequest[] $restrictionActRequest
     * @return \StructType\DataBlock
     */
    public function setRestrictionActRequest(array $restrictionActRequest = array())
    {
        $this->RestrictionActRequest = $restrictionActRequest;
        return $this;
    }
    /**
     * Add item to RestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionActRequest $item
     * @return \StructType\DataBlock
     */
    public function addToRestrictionActRequest(\StructType\RestrictionActRequest $item)
    {
        $this->RestrictionActRequest[] = $item;
        return $this;
    }
    /**
     * Get RestrictionActInfo value
     * @return \StructType\RestrictionActInfo[]|null
     */
    public function getRestrictionActInfo()
    {
        return $this->RestrictionActInfo;
    }
    /**
     * Set RestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionActInfo[] $restrictionActInfo
     * @return \StructType\DataBlock
     */
    public function setRestrictionActInfo(array $restrictionActInfo = array())
    {
        $this->RestrictionActInfo = $restrictionActInfo;
        return $this;
    }
    /**
     * Add item to RestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionActInfo $item
     * @return \StructType\DataBlock
     */
    public function addToRestrictionActInfo(\StructType\RestrictionActInfo $item)
    {
        $this->RestrictionActInfo[] = $item;
        return $this;
    }
    /**
     * Get ipDataRequest value
     * @return \StructType\IPDataRequest[]|null
     */
    public function getIpDataRequest()
    {
        return $this->ipDataRequest;
    }
    /**
     * Set ipDataRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDataRequest[] $ipDataRequest
     * @return \StructType\DataBlock
     */
    public function setIpDataRequest(array $ipDataRequest = array())
    {
        $this->ipDataRequest = $ipDataRequest;
        return $this;
    }
    /**
     * Add item to ipDataRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDataRequest $item
     * @return \StructType\DataBlock
     */
    public function addToIpDataRequest(\StructType\IPDataRequest $item)
    {
        $this->ipDataRequest[] = $item;
        return $this;
    }
    /**
     * Get investigationDataInfo value
     * @return \StructType\InvestigationDataInfo[]|null
     */
    public function getInvestigationDataInfo()
    {
        return $this->investigationDataInfo;
    }
    /**
     * Set investigationDataInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationDataInfo[] $investigationDataInfo
     * @return \StructType\DataBlock
     */
    public function setInvestigationDataInfo(array $investigationDataInfo = array())
    {
        $this->investigationDataInfo = $investigationDataInfo;
        return $this;
    }
    /**
     * Add item to investigationDataInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationDataInfo $item
     * @return \StructType\DataBlock
     */
    public function addToInvestigationDataInfo(\StructType\InvestigationDataInfo $item)
    {
        $this->investigationDataInfo[] = $item;
        return $this;
    }
    /**
     * Get ipDataInfo value
     * @return \StructType\IPDataInfo[]|null
     */
    public function getIpDataInfo()
    {
        return $this->ipDataInfo;
    }
    /**
     * Set ipDataInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDataInfo[] $ipDataInfo
     * @return \StructType\DataBlock
     */
    public function setIpDataInfo(array $ipDataInfo = array())
    {
        $this->ipDataInfo = $ipDataInfo;
        return $this;
    }
    /**
     * Add item to ipDataInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IPDataInfo $item
     * @return \StructType\DataBlock
     */
    public function addToIpDataInfo(\StructType\IPDataInfo $item)
    {
        $this->ipDataInfo[] = $item;
        return $this;
    }
    /**
     * Get RecoveredAmountRequest value
     * @return \StructType\RecoveredAmountRequest[]|null
     */
    public function getRecoveredAmountRequest()
    {
        return $this->RecoveredAmountRequest;
    }
    /**
     * Set RecoveredAmountRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountRequest[] $recoveredAmountRequest
     * @return \StructType\DataBlock
     */
    public function setRecoveredAmountRequest(array $recoveredAmountRequest = array())
    {
        $this->RecoveredAmountRequest = $recoveredAmountRequest;
        return $this;
    }
    /**
     * Add item to RecoveredAmountRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountRequest $item
     * @return \StructType\DataBlock
     */
    public function addToRecoveredAmountRequest(\StructType\RecoveredAmountRequest $item)
    {
        $this->RecoveredAmountRequest[] = $item;
        return $this;
    }
    /**
     * Get RecoveredAmountAnswer value
     * @return \StructType\RecoveredAmountAnswer[]|null
     */
    public function getRecoveredAmountAnswer()
    {
        return $this->RecoveredAmountAnswer;
    }
    /**
     * Set RecoveredAmountAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountAnswer[] $recoveredAmountAnswer
     * @return \StructType\DataBlock
     */
    public function setRecoveredAmountAnswer(array $recoveredAmountAnswer = array())
    {
        $this->RecoveredAmountAnswer = $recoveredAmountAnswer;
        return $this;
    }
    /**
     * Add item to RecoveredAmountAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\RecoveredAmountAnswer $item
     * @return \StructType\DataBlock
     */
    public function addToRecoveredAmountAnswer(\StructType\RecoveredAmountAnswer $item)
    {
        $this->RecoveredAmountAnswer[] = $item;
        return $this;
    }
    /**
     * Get InvestigationRegistryQuery value
     * @return \StructType\InvestigationRegistryQuery[]|null
     */
    public function getInvestigationRegistryQuery()
    {
        return $this->InvestigationRegistryQuery;
    }
    /**
     * Set InvestigationRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistryQuery[] $investigationRegistryQuery
     * @return \StructType\DataBlock
     */
    public function setInvestigationRegistryQuery(array $investigationRegistryQuery = array())
    {
        $this->InvestigationRegistryQuery = $investigationRegistryQuery;
        return $this;
    }
    /**
     * Add item to InvestigationRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistryQuery $item
     * @return \StructType\DataBlock
     */
    public function addToInvestigationRegistryQuery(\StructType\InvestigationRegistryQuery $item)
    {
        $this->InvestigationRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryQuery value
     * @return \StructType\ArrestRegistryQuery[]|null
     */
    public function getArrestRegistryQuery()
    {
        return $this->ArrestRegistryQuery;
    }
    /**
     * Set ArrestRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryQuery[] $arrestRegistryQuery
     * @return \StructType\DataBlock
     */
    public function setArrestRegistryQuery(array $arrestRegistryQuery = array())
    {
        $this->ArrestRegistryQuery = $arrestRegistryQuery;
        return $this;
    }
    /**
     * Add item to ArrestRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryQuery $item
     * @return \StructType\DataBlock
     */
    public function addToArrestRegistryQuery(\StructType\ArrestRegistryQuery $item)
    {
        $this->ArrestRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryInfo value
     * @return \StructType\ArrestRegistryInfo[]|null
     */
    public function getArrestRegistryInfo()
    {
        return $this->ArrestRegistryInfo;
    }
    /**
     * Set ArrestRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryInfo[] $arrestRegistryInfo
     * @return \StructType\DataBlock
     */
    public function setArrestRegistryInfo(array $arrestRegistryInfo = array())
    {
        $this->ArrestRegistryInfo = $arrestRegistryInfo;
        return $this;
    }
    /**
     * Add item to ArrestRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryInfo $item
     * @return \StructType\DataBlock
     */
    public function addToArrestRegistryInfo(\StructType\ArrestRegistryInfo $item)
    {
        $this->ArrestRegistryInfo[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryDetail value
     * @return \StructType\ArrestRegistryDetail[]|null
     */
    public function getArrestRegistryDetail()
    {
        return $this->ArrestRegistryDetail;
    }
    /**
     * Set ArrestRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryDetail[] $arrestRegistryDetail
     * @return \StructType\DataBlock
     */
    public function setArrestRegistryDetail(array $arrestRegistryDetail = array())
    {
        $this->ArrestRegistryDetail = $arrestRegistryDetail;
        return $this;
    }
    /**
     * Add item to ArrestRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrestRegistryDetail $item
     * @return \StructType\DataBlock
     */
    public function addToArrestRegistryDetail(\StructType\ArrestRegistryDetail $item)
    {
        $this->ArrestRegistryDetail[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryQuery value
     * @return \StructType\CrimeRegistryQuery[]|null
     */
    public function getCrimeRegistryQuery()
    {
        return $this->CrimeRegistryQuery;
    }
    /**
     * Set CrimeRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryQuery[] $crimeRegistryQuery
     * @return \StructType\DataBlock
     */
    public function setCrimeRegistryQuery(array $crimeRegistryQuery = array())
    {
        $this->CrimeRegistryQuery = $crimeRegistryQuery;
        return $this;
    }
    /**
     * Add item to CrimeRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryQuery $item
     * @return \StructType\DataBlock
     */
    public function addToCrimeRegistryQuery(\StructType\CrimeRegistryQuery $item)
    {
        $this->CrimeRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryInfo value
     * @return \StructType\CrimeRegistryInfo[]|null
     */
    public function getCrimeRegistryInfo()
    {
        return $this->CrimeRegistryInfo;
    }
    /**
     * Set CrimeRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryInfo[] $crimeRegistryInfo
     * @return \StructType\DataBlock
     */
    public function setCrimeRegistryInfo(array $crimeRegistryInfo = array())
    {
        $this->CrimeRegistryInfo = $crimeRegistryInfo;
        return $this;
    }
    /**
     * Add item to CrimeRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryInfo $item
     * @return \StructType\DataBlock
     */
    public function addToCrimeRegistryInfo(\StructType\CrimeRegistryInfo $item)
    {
        $this->CrimeRegistryInfo[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryDetail value
     * @return \StructType\CrimeRegistryDetail[]|null
     */
    public function getCrimeRegistryDetail()
    {
        return $this->CrimeRegistryDetail;
    }
    /**
     * Set CrimeRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryDetail[] $crimeRegistryDetail
     * @return \StructType\DataBlock
     */
    public function setCrimeRegistryDetail(array $crimeRegistryDetail = array())
    {
        $this->CrimeRegistryDetail = $crimeRegistryDetail;
        return $this;
    }
    /**
     * Add item to CrimeRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryDetail $item
     * @return \StructType\DataBlock
     */
    public function addToCrimeRegistryDetail(\StructType\CrimeRegistryDetail $item)
    {
        $this->CrimeRegistryDetail[] = $item;
        return $this;
    }
    /**
     * Get caRequest value
     * @return \StructType\CaRequest[]|null
     */
    public function getCaRequest()
    {
        return $this->caRequest;
    }
    /**
     * Set caRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CaRequest[] $caRequest
     * @return \StructType\DataBlock
     */
    public function setCaRequest(array $caRequest = array())
    {
        $this->caRequest = $caRequest;
        return $this;
    }
    /**
     * Add item to caRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CaRequest $item
     * @return \StructType\DataBlock
     */
    public function addToCaRequest(\StructType\CaRequest $item)
    {
        $this->caRequest[] = $item;
        return $this;
    }
    /**
     * Get caAnswer value
     * @return \StructType\CaAnswer[]|null
     */
    public function getCaAnswer()
    {
        return $this->caAnswer;
    }
    /**
     * Set caAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\CaAnswer[] $caAnswer
     * @return \StructType\DataBlock
     */
    public function setCaAnswer(array $caAnswer = array())
    {
        $this->caAnswer = $caAnswer;
        return $this;
    }
    /**
     * Add item to caAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\CaAnswer $item
     * @return \StructType\DataBlock
     */
    public function addToCaAnswer(\StructType\CaAnswer $item)
    {
        $this->caAnswer[] = $item;
        return $this;
    }
    /**
     * Get investigationRegistry value
     * @return \StructType\InvestigationRegistry[]|null
     */
    public function getInvestigationRegistry()
    {
        return $this->investigationRegistry;
    }
    /**
     * Set investigationRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistry[] $investigationRegistry
     * @return \StructType\DataBlock
     */
    public function setInvestigationRegistry(array $investigationRegistry = array())
    {
        $this->investigationRegistry = $investigationRegistry;
        return $this;
    }
    /**
     * Add item to investigationRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\InvestigationRegistry $item
     * @return \StructType\DataBlock
     */
    public function addToInvestigationRegistry(\StructType\InvestigationRegistry $item)
    {
        $this->investigationRegistry[] = $item;
        return $this;
    }
    /**
     * Get PenaltyChargesRegistry value
     * @return \StructType\PenaltyChargesRegistry[]|null
     */
    public function getPenaltyChargesRegistry()
    {
        return $this->PenaltyChargesRegistry;
    }
    /**
     * Set PenaltyChargesRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyChargesRegistry[] $penaltyChargesRegistry
     * @return \StructType\DataBlock
     */
    public function setPenaltyChargesRegistry(array $penaltyChargesRegistry = array())
    {
        $this->PenaltyChargesRegistry = $penaltyChargesRegistry;
        return $this;
    }
    /**
     * Add item to PenaltyChargesRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\PenaltyChargesRegistry $item
     * @return \StructType\DataBlock
     */
    public function addToPenaltyChargesRegistry(\StructType\PenaltyChargesRegistry $item)
    {
        $this->PenaltyChargesRegistry[] = $item;
        return $this;
    }
    /**
     * Get RestrictionRegistry value
     * @return \StructType\RestrictionRegistry[]|null
     */
    public function getRestrictionRegistry()
    {
        return $this->RestrictionRegistry;
    }
    /**
     * Set RestrictionRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionRegistry[] $restrictionRegistry
     * @return \StructType\DataBlock
     */
    public function setRestrictionRegistry(array $restrictionRegistry = array())
    {
        $this->RestrictionRegistry = $restrictionRegistry;
        return $this;
    }
    /**
     * Add item to RestrictionRegistry value
     * @throws \InvalidArgumentException
     * @param \StructType\RestrictionRegistry $item
     * @return \StructType\DataBlock
     */
    public function addToRestrictionRegistry(\StructType\RestrictionRegistry $item)
    {
        $this->RestrictionRegistry[] = $item;
        return $this;
    }
    /**
     * Get ReqAppResult value
     * @return \StructType\ReqAppResult[]|null
     */
    public function getReqAppResult()
    {
        return $this->ReqAppResult;
    }
    /**
     * Set ReqAppResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ReqAppResult[] $reqAppResult
     * @return \StructType\DataBlock
     */
    public function setReqAppResult(array $reqAppResult = array())
    {
        $this->ReqAppResult = $reqAppResult;
        return $this;
    }
    /**
     * Add item to ReqAppResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ReqAppResult $item
     * @return \StructType\DataBlock
     */
    public function addToReqAppResult(\StructType\ReqAppResult $item)
    {
        $this->ReqAppResult[] = $item;
        return $this;
    }
    /**
     * Get AnswerAppResult value
     * @return \StructType\AnswerAppResult[]|null
     */
    public function getAnswerAppResult()
    {
        return $this->AnswerAppResult;
    }
    /**
     * Set AnswerAppResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerAppResult[] $answerAppResult
     * @return \StructType\DataBlock
     */
    public function setAnswerAppResult(array $answerAppResult = array())
    {
        $this->AnswerAppResult = $answerAppResult;
        return $this;
    }
    /**
     * Add item to AnswerAppResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerAppResult $item
     * @return \StructType\DataBlock
     */
    public function addToAnswerAppResult(\StructType\AnswerAppResult $item)
    {
        $this->AnswerAppResult[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\DocumentNote[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentNote[] $message
     * @return \StructType\DataBlock
     */
    public function setMessage(array $message = array())
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentNote $item
     * @return \StructType\DataBlock
     */
    public function addToMessage(\StructType\DocumentNote $item)
    {
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get debtorIPListRequest value
     * @return \StructType\DebtorIPListRequestType[]|null
     */
    public function getDebtorIPListRequest()
    {
        return $this->debtorIPListRequest;
    }
    /**
     * Set debtorIPListRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIPListRequestType[] $debtorIPListRequest
     * @return \StructType\DataBlock
     */
    public function setDebtorIPListRequest(array $debtorIPListRequest = array())
    {
        $this->debtorIPListRequest = $debtorIPListRequest;
        return $this;
    }
    /**
     * Add item to debtorIPListRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIPListRequestType $item
     * @return \StructType\DataBlock
     */
    public function addToDebtorIPListRequest(\StructType\DebtorIPListRequestType $item)
    {
        $this->debtorIPListRequest[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestExistence value
     * @return \StructType\IPSideRequestExistenceType[]|null
     */
    public function getIPSideRequestExistence()
    {
        return $this->IPSideRequestExistence;
    }
    /**
     * Set IPSideRequestExistence value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestExistenceType[] $iPSideRequestExistence
     * @return \StructType\DataBlock
     */
    public function setIPSideRequestExistence(array $iPSideRequestExistence = array())
    {
        $this->IPSideRequestExistence = $iPSideRequestExistence;
        return $this;
    }
    /**
     * Add item to IPSideRequestExistence value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestExistenceType $item
     * @return \StructType\DataBlock
     */
    public function addToIPSideRequestExistence(\StructType\IPSideRequestExistenceType $item)
    {
        $this->IPSideRequestExistence[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestCourseID value
     * @return \StructType\IPSideRequestCourseIDType[]|null
     */
    public function getIPSideRequestCourseID()
    {
        return $this->IPSideRequestCourseID;
    }
    /**
     * Set IPSideRequestCourseID value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestCourseIDType[] $iPSideRequestCourseID
     * @return \StructType\DataBlock
     */
    public function setIPSideRequestCourseID(array $iPSideRequestCourseID = array())
    {
        $this->IPSideRequestCourseID = $iPSideRequestCourseID;
        return $this;
    }
    /**
     * Add item to IPSideRequestCourseID value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestCourseIDType $item
     * @return \StructType\DataBlock
     */
    public function addToIPSideRequestCourseID(\StructType\IPSideRequestCourseIDType $item)
    {
        $this->IPSideRequestCourseID[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestCourseIP value
     * @return \StructType\IPSideRequestCourseIPType[]|null
     */
    public function getIPSideRequestCourseIP()
    {
        return $this->IPSideRequestCourseIP;
    }
    /**
     * Set IPSideRequestCourseIP value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestCourseIPType[] $iPSideRequestCourseIP
     * @return \StructType\DataBlock
     */
    public function setIPSideRequestCourseIP(array $iPSideRequestCourseIP = array())
    {
        $this->IPSideRequestCourseIP = $iPSideRequestCourseIP;
        return $this;
    }
    /**
     * Add item to IPSideRequestCourseIP value
     * @throws \InvalidArgumentException
     * @param \StructType\IPSideRequestCourseIPType $item
     * @return \StructType\DataBlock
     */
    public function addToIPSideRequestCourseIP(\StructType\IPSideRequestCourseIPType $item)
    {
        $this->IPSideRequestCourseIP[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResultRequest value
     * @return \StructType\IPReqAppResultRequestType[]|null
     */
    public function getIPReqAppResultRequest()
    {
        return $this->IPReqAppResultRequest;
    }
    /**
     * Set IPReqAppResultRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResultRequestType[] $iPReqAppResultRequest
     * @return \StructType\DataBlock
     */
    public function setIPReqAppResultRequest(array $iPReqAppResultRequest = array())
    {
        $this->IPReqAppResultRequest = $iPReqAppResultRequest;
        return $this;
    }
    /**
     * Add item to IPReqAppResultRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResultRequestType $item
     * @return \StructType\DataBlock
     */
    public function addToIPReqAppResultRequest(\StructType\IPReqAppResultRequestType $item)
    {
        $this->IPReqAppResultRequest[] = $item;
        return $this;
    }
    /**
     * Get DebtorIPListResponseType value
     * @return \StructType\DebtorIPListResponseType[]|null
     */
    public function getDebtorIPListResponseType()
    {
        return $this->DebtorIPListResponseType;
    }
    /**
     * Set DebtorIPListResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIPListResponseType[] $debtorIPListResponseType
     * @return \StructType\DataBlock
     */
    public function setDebtorIPListResponseType(array $debtorIPListResponseType = array())
    {
        $this->DebtorIPListResponseType = $debtorIPListResponseType;
        return $this;
    }
    /**
     * Add item to DebtorIPListResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\DebtorIPListResponseType $item
     * @return \StructType\DataBlock
     */
    public function addToDebtorIPListResponseType(\StructType\DebtorIPListResponseType $item)
    {
        $this->DebtorIPListResponseType[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResponseType value
     * @return \StructType\IPReqAppResponseType[]|null
     */
    public function getIPReqAppResponseType()
    {
        return $this->IPReqAppResponseType;
    }
    /**
     * Set IPReqAppResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResponseType[] $iPReqAppResponseType
     * @return \StructType\DataBlock
     */
    public function setIPReqAppResponseType(array $iPReqAppResponseType = array())
    {
        $this->IPReqAppResponseType = $iPReqAppResponseType;
        return $this;
    }
    /**
     * Add item to IPReqAppResponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResponseType $item
     * @return \StructType\DataBlock
     */
    public function addToIPReqAppResponseType(\StructType\IPReqAppResponseType $item)
    {
        $this->IPReqAppResponseType[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResultReponseType value
     * @return \StructType\IPReqAppResultReponseType[]|null
     */
    public function getIPReqAppResultReponseType()
    {
        return $this->IPReqAppResultReponseType;
    }
    /**
     * Set IPReqAppResultReponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResultReponseType[] $iPReqAppResultReponseType
     * @return \StructType\DataBlock
     */
    public function setIPReqAppResultReponseType(array $iPReqAppResultReponseType = array())
    {
        $this->IPReqAppResultReponseType = $iPReqAppResultReponseType;
        return $this;
    }
    /**
     * Add item to IPReqAppResultReponseType value
     * @throws \InvalidArgumentException
     * @param \StructType\IPReqAppResultReponseType $item
     * @return \StructType\DataBlock
     */
    public function addToIPReqAppResultReponseType(\StructType\IPReqAppResultReponseType $item)
    {
        $this->IPReqAppResultReponseType[] = $item;
        return $this;
    }
    /**
     * Get EApplicationType value
     * @return \StructType\EApplicationType[]|null
     */
    public function getEApplicationType()
    {
        return $this->EApplicationType;
    }
    /**
     * Set EApplicationType value
     * @throws \InvalidArgumentException
     * @param \StructType\EApplicationType[] $eApplicationType
     * @return \StructType\DataBlock
     */
    public function setEApplicationType(array $eApplicationType = array())
    {
        $this->EApplicationType = $eApplicationType;
        return $this;
    }
    /**
     * Add item to EApplicationType value
     * @throws \InvalidArgumentException
     * @param \StructType\EApplicationType $item
     * @return \StructType\DataBlock
     */
    public function addToEApplicationType(\StructType\EApplicationType $item)
    {
        $this->EApplicationType[] = $item;
        return $this;
    }
    /**
     * Get EApplicationResultType value
     * @return \StructType\EApplicationResultType[]|null
     */
    public function getEApplicationResultType()
    {
        return $this->EApplicationResultType;
    }
    /**
     * Set EApplicationResultType value
     * @throws \InvalidArgumentException
     * @param \StructType\EApplicationResultType[] $eApplicationResultType
     * @return \StructType\DataBlock
     */
    public function setEApplicationResultType(array $eApplicationResultType = array())
    {
        $this->EApplicationResultType = $eApplicationResultType;
        return $this;
    }
    /**
     * Add item to EApplicationResultType value
     * @throws \InvalidArgumentException
     * @param \StructType\EApplicationResultType $item
     * @return \StructType\DataBlock
     */
    public function addToEApplicationResultType(\StructType\EApplicationResultType $item)
    {
        $this->EApplicationResultType[] = $item;
        return $this;
    }
    /**
     * Get MailStateTrackingRequest value
     * @return \StructType\MailStateTrackingRequest[]|null
     */
    public function getMailStateTrackingRequest()
    {
        return $this->MailStateTrackingRequest;
    }
    /**
     * Set MailStateTrackingRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MailStateTrackingRequest[] $mailStateTrackingRequest
     * @return \StructType\DataBlock
     */
    public function setMailStateTrackingRequest(array $mailStateTrackingRequest = array())
    {
        $this->MailStateTrackingRequest = $mailStateTrackingRequest;
        return $this;
    }
    /**
     * Add item to MailStateTrackingRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MailStateTrackingRequest $item
     * @return \StructType\DataBlock
     */
    public function addToMailStateTrackingRequest(\StructType\MailStateTrackingRequest $item)
    {
        $this->MailStateTrackingRequest[] = $item;
        return $this;
    }
    /**
     * Get MailState value
     * @return \StructType\MailState[]|null
     */
    public function getMailState()
    {
        return $this->MailState;
    }
    /**
     * Set MailState value
     * @throws \InvalidArgumentException
     * @param \StructType\MailState[] $mailState
     * @return \StructType\DataBlock
     */
    public function setMailState(array $mailState = array())
    {
        $this->MailState = $mailState;
        return $this;
    }
    /**
     * Add item to MailState value
     * @throws \InvalidArgumentException
     * @param \StructType\MailState $item
     * @return \StructType\DataBlock
     */
    public function addToMailState(\StructType\MailState $item)
    {
        $this->MailState[] = $item;
        return $this;
    }
    /**
     * Get IncomingForcedExecDocument value
     * @return \StructType\IncomingForcedExecDocument[]|null
     */
    public function getIncomingForcedExecDocument()
    {
        return $this->IncomingForcedExecDocument;
    }
    /**
     * Set IncomingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingForcedExecDocument[] $incomingForcedExecDocument
     * @return \StructType\DataBlock
     */
    public function setIncomingForcedExecDocument(array $incomingForcedExecDocument = array())
    {
        $this->IncomingForcedExecDocument = $incomingForcedExecDocument;
        return $this;
    }
    /**
     * Add item to IncomingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingForcedExecDocument $item
     * @return \StructType\DataBlock
     */
    public function addToIncomingForcedExecDocument(\StructType\IncomingForcedExecDocument $item)
    {
        $this->IncomingForcedExecDocument[] = $item;
        return $this;
    }
    /**
     * Get OutgoingForcedExecDocument value
     * @return \StructType\OutgoingForcedExecDocument[]|null
     */
    public function getOutgoingForcedExecDocument()
    {
        return $this->OutgoingForcedExecDocument;
    }
    /**
     * Set OutgoingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\OutgoingForcedExecDocument[] $outgoingForcedExecDocument
     * @return \StructType\DataBlock
     */
    public function setOutgoingForcedExecDocument(array $outgoingForcedExecDocument = array())
    {
        $this->OutgoingForcedExecDocument = $outgoingForcedExecDocument;
        return $this;
    }
    /**
     * Add item to OutgoingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\OutgoingForcedExecDocument $item
     * @return \StructType\DataBlock
     */
    public function addToOutgoingForcedExecDocument(\StructType\OutgoingForcedExecDocument $item)
    {
        $this->OutgoingForcedExecDocument[] = $item;
        return $this;
    }
    /**
     * Get IncomingEMailMessage value
     * @return \StructType\IncomingEMailMessage[]|null
     */
    public function getIncomingEMailMessage()
    {
        return $this->IncomingEMailMessage;
    }
    /**
     * Set IncomingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingEMailMessage[] $incomingEMailMessage
     * @return \StructType\DataBlock
     */
    public function setIncomingEMailMessage(array $incomingEMailMessage = array())
    {
        $this->IncomingEMailMessage = $incomingEMailMessage;
        return $this;
    }
    /**
     * Add item to IncomingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingEMailMessage $item
     * @return \StructType\DataBlock
     */
    public function addToIncomingEMailMessage(\StructType\IncomingEMailMessage $item)
    {
        $this->IncomingEMailMessage[] = $item;
        return $this;
    }
    /**
     * Get OutgoingEMailMessage value
     * @return \StructType\OutgoingEMailMessage[]|null
     */
    public function getOutgoingEMailMessage()
    {
        return $this->OutgoingEMailMessage;
    }
    /**
     * Set OutgoingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\OutgoingEMailMessage[] $outgoingEMailMessage
     * @return \StructType\DataBlock
     */
    public function setOutgoingEMailMessage(array $outgoingEMailMessage = array())
    {
        $this->OutgoingEMailMessage = $outgoingEMailMessage;
        return $this;
    }
    /**
     * Add item to OutgoingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\OutgoingEMailMessage $item
     * @return \StructType\DataBlock
     */
    public function addToOutgoingEMailMessage(\StructType\OutgoingEMailMessage $item)
    {
        $this->OutgoingEMailMessage[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DataBlock
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
