<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Data StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных Data «Сведения» | Данный контейнер содержит один элемент сведений о должнике. Допустимые типы элементов перечислены в
 * таблице (Удостоверение личности, Адрес и т. п.). При необходимости указать в документе несколько сведений следует завести в документе
 * несколько объектов типа Data «Сведения».
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The IdentificationData
     * Meta informations extracted from the WSDL
     * - documentation: Удостоверение личности
     * @var \StructType\IdentificationDataType
     */
    public $IdentificationData;
    /**
     * The AddressData
     * Meta informations extracted from the WSDL
     * - documentation: Адрес
     * @var \StructType\AddressDataType
     */
    public $AddressData;
    /**
     * The TelephoneData
     * Meta informations extracted from the WSDL
     * - documentation: Телефон
     * @var \StructType\TelephoneDataType
     */
    public $TelephoneData;
    /**
     * The TransportData
     * Meta informations extracted from the WSDL
     * - documentation: Транспортные средства
     * @var \StructType\TransportDataType
     */
    public $TransportData;
    /**
     * The SvedRabData
     * Meta informations extracted from the WSDL
     * - documentation: Место получения дохода
     * @var \StructType\SvedRabDataType
     */
    public $SvedRabData;
    /**
     * The ManagementData
     * Meta informations extracted from the WSDL
     * - documentation: Должностные лица
     * @var \StructType\ManagementDataType
     */
    public $ManagementData;
    /**
     * The SvedDoxodData
     * Meta informations extracted from the WSDL
     * - documentation: Полученный доход
     * @var \StructType\SvedDoxodDataType
     */
    public $SvedDoxodData;
    /**
     * The DebtorStateData
     * Meta informations extracted from the WSDL
     * - documentation: Статус должника
     * @var \StructType\DebtorStateDataType
     */
    public $DebtorStateData;
    /**
     * The AvailabilityAccData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие денежных средств на счете
     * @var \StructType\AvailabilityAccDataType
     */
    public $AvailabilityAccData;
    /**
     * The AvailabilityAccExtData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие денежных средств на счете
     * @var \StructType\AvailabilityAccExtDataType
     */
    public $AvailabilityAccExtData;
    /**
     * The ArrestRecoveryAmountData
     * Meta informations extracted from the WSDL
     * - documentation: Арестованные и взысканные средства
     * @var \StructType\ArrestRecoveryAmountDataType
     */
    public $ArrestRecoveryAmountData;
    /**
     * The AvailabilityAccDepoData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие счетов ДЕПО
     * @var \StructType\AvailabilityAccDepoDataType
     */
    public $AvailabilityAccDepoData;
    /**
     * The RealtyRegistryExtractData
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра недвижимости
     * @var \StructType\RealtyRegistryExtractType
     */
    public $RealtyRegistryExtractData;
    /**
     * The SvedNedvData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о недвижимости
     * @var \StructType\SvedNedvDataType
     */
    public $SvedNedvData;
    /**
     * The SvedNedvObject
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об объекте недвижимости
     * @var \StructType\SvedNedvObjectType
     */
    public $SvedNedvObject;
    /**
     * The SvedNedvRightData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о правах на недвижимость
     * @var \StructType\SvedNedvRightType
     */
    public $SvedNedvRightData;
    /**
     * The SvedNedvEncumbranceData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об обременениях
     * @var \StructType\SvedNedvEncumbranceType
     */
    public $SvedNedvEncumbranceData;
    /**
     * The SvedNedvShareHoldingData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о долевом участии
     * @var \StructType\SvedNedvShareHoldingType
     */
    public $SvedNedvShareHoldingData;
    /**
     * The ObjectData
     * Meta informations extracted from the WSDL
     * - documentation: Объекты учета
     * @var \StructType\ObjectDataType
     */
    public $ObjectData;
    /**
     * The KKTData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие ККТ
     * @var \StructType\KKTDataType
     */
    public $KKTData;
    /**
     * The AccountingData
     * Meta informations extracted from the WSDL
     * - documentation: Бухгалтерская отчетность
     * @var \StructType\AccountingDataType
     */
    public $AccountingData;
    /**
     * The TicketDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о передвижении
     * @var \StructType\TicketDatumType
     */
    public $TicketDatum;
    /**
     * The personDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о физическом лице
     * @var \StructType\PersonDatumType
     */
    public $personDatum;
    /**
     * The companyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о юридическом лице
     * @var \StructType\CompanyDatumType
     */
    public $companyDatum;
    /**
     * The paymentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об оплате
     * @var \StructType\PaymentDatumType
     */
    public $paymentDatum;
    /**
     * The countDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о количестве сведений
     * @var \StructType\CountDatumType
     */
    public $countDatum;
    /**
     * The companyAddressDatum
     * Meta informations extracted from the WSDL
     * - documentation: Адрес юридического лица
     * - minOccurs: 0
     * @var \StructType\CompanyAddressDatumType
     */
    public $companyAddressDatum;
    /**
     * The regOrganDatum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрирующая организация
     * @var \StructType\RegOrganDatumType
     */
    public $regOrganDatum;
    /**
     * The shipDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о судне
     * @var \StructType\ShipDatumType
     */
    public $shipDatum;
    /**
     * The machineDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о машине
     * @var \StructType\MachineDatumType
     */
    public $machineDatum;
    /**
     * The founderCompanyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Учредитель—юридическое лицо
     * @var \StructType\FounderCompanyDatumType
     */
    public $founderCompanyDatum;
    /**
     * The forgnFndrCompanyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Иностранный учредитель—юр. лицо
     * @var \StructType\ForgnFndrCompanyDatumType
     */
    public $forgnFndrCompanyDatum;
    /**
     * The companyExtDatum
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из ЕГРЮЛ
     * @var \StructType\CompanyExtDatumType
     */
    public $companyExtDatum;
    /**
     * The founderPersonDatum
     * Meta informations extracted from the WSDL
     * - documentation: Учредитель—физическое лицо
     * @var \StructType\FounderPersonDatumType
     */
    public $founderPersonDatum;
    /**
     * The companyManagementDatum
     * Meta informations extracted from the WSDL
     * - documentation: Лица, имеющие право действовать от имени юридического лица
     * @var \StructType\CompanyManagementDatumType
     */
    public $companyManagementDatum;
    /**
     * The soleEntrepreneurDatum
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из ЕГРИП
     * @var \StructType\SoleEntrepreneurDatumType
     */
    public $soleEntrepreneurDatum;
    /**
     * The registrationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о регистрации
     * @var \StructType\RegistrationDatumType
     */
    public $registrationDatum;
    /**
     * The licenseDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о лицензии
     * @var \StructType\LicenseDatumType
     */
    public $licenseDatum;
    /**
     * The subdivisionDatum
     * Meta informations extracted from the WSDL
     * - documentation: Обособленное подразделение
     * @var \StructType\SubdivisionDatumType
     */
    public $subdivisionDatum;
    /**
     * The egrulEgripDatum
     * Meta informations extracted from the WSDL
     * - documentation: Состояние записи ЕГРЮЛ/ЕГРИП
     * @var \StructType\EgrulEgripDatumType
     */
    public $egrulEgripDatum;
    /**
     * The accountDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о банковском счете
     * @var \StructType\AccountDatumType
     */
    public $accountDatum;
    /**
     * The accountExtDatum
     * Meta informations extracted from the WSDL
     * - documentation: Расширенные сведения о банковском счете
     * @var \StructType\AccountExtDatumType
     */
    public $accountExtDatum;
    /**
     * The soleEntrepreneurOldRegDatum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация ИП до 2004 г.
     * @var \StructType\SoleEntrepreneurOldRegDatumType
     */
    public $soleEntrepreneurOldRegDatum;
    /**
     * The documentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о документе
     * @var \StructType\DocumentDatumType
     */
    public $documentDatum;
    /**
     * The fishQuotaContractDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии договора на закрепление долей квот добычи (вылова) биоресурсов
     * @var \StructType\FishQuotaContractDatumType
     */
    public $fishQuotaContractDatum;
    /**
     * The fishQuotaYearDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии квот на вылов биоресурсов на текущий год
     * @var \StructType\FishQuotaCurYearDatumType
     */
    public $fishQuotaYearDatum;
    /**
     * The fishNonquotaContractDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о договорах пользования водными биоресурсами, которые отнесены к объектам рыболовства и общий допустимый улов
     * которых не устанавливается
     * @var \StructType\FishNonquotaContractDatumType
     */
    public $fishNonquotaContractDatum;
    /**
     * The transactionDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о финансовых операциях
     * @var \StructType\TransactionDatumType
     */
    public $transactionDatum;
    /**
     * The deathDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о смерти
     * @var \StructType\DeathDatumType
     */
    public $deathDatum;
    /**
     * The unaccountedForDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о пропавшем без вести
     * @var \StructType\UnaccountedForDatumType
     */
    public $unaccountedForDatum;
    /**
     * The DepositBoxDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о банковских ячейках
     * @var \StructType\DepositBoxDatumType
     */
    public $DepositBoxDatum;
    /**
     * The accountTransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об операциях по счету
     * @var \StructType\AccountTransactionDatumType
     */
    public $accountTransactionType;
    /**
     * The AccountEncumbranceDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об арестах и обременениях
     * @var \StructType\AccountEncumbranceDatumType
     */
    public $AccountEncumbranceDatum;
    /**
     * The propertyObligationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об имущественных обязательствах
     * @var \StructType\PropertyObligationDatumType
     */
    public $propertyObligationDatum;
    /**
     * The unstructuredDatum
     * Meta informations extracted from the WSDL
     * - documentation: Неструктурированные сведения
     * @var \StructType\UnstructuredDatumType
     */
    public $unstructuredDatum;
    /**
     * The unemployedPersonCaseDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о личном деле безработного
     * @var \StructType\UnemployedPersonCaseDatumType
     */
    public $unemployedPersonCaseDatum;
    /**
     * The unemployedPersonRegistrationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о периоде нахождения на регистрационном учете в качестве безработного
     * @var \StructType\UnemployedPersonRegistrationDatumType
     */
    public $unemployedPersonRegistrationDatum;
    /**
     * The seniorityPeriodDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о периоде трудового стажа
     * @var \StructType\SeniorityPeriodDatumType
     */
    public $seniorityPeriodDatum;
    /**
     * The SalaryWithheldDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \StructType\SalaryWithheldDatumType
     */
    public $SalaryWithheldDatum;
    /**
     * The CashLetterDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \StructType\CashLetterDatumType
     */
    public $CashLetterDatum;
    /**
     * The ValidationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проверке нотариального документа
     * @var \StructType\ValidationDatumType
     */
    public $ValidationDatum;
    /**
     * The GoodsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \StructType\GoodsDatumType
     */
    public $GoodsDatum;
    /**
     * The WeaponDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о зарегистрированном оружии
     * @var \StructType\WeaponDatumType
     */
    public $WeaponDatum;
    /**
     * The SentencedPersonImprisonmentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отбывании наказания осужденным должником в местах лишения свободы
     * @var \StructType\SentencedPersonImprisonmentType
     */
    public $SentencedPersonImprisonmentDatum;
    /**
     * The SentencedPersonNoImprisonmentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отбывании осужденным должником наказания, не связанного с лишением свободы
     * @var \StructType\SentencedPersonNoImprisonmentType
     */
    public $SentencedPersonNoImprisonmentDatum;
    /**
     * The BKIDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о бюро кредитных историй
     * @var \StructType\BKIDatumType
     */
    public $BKIDatum;
    /**
     * Constructor method for Data
     * @uses Data::setIdentificationData()
     * @uses Data::setAddressData()
     * @uses Data::setTelephoneData()
     * @uses Data::setTransportData()
     * @uses Data::setSvedRabData()
     * @uses Data::setManagementData()
     * @uses Data::setSvedDoxodData()
     * @uses Data::setDebtorStateData()
     * @uses Data::setAvailabilityAccData()
     * @uses Data::setAvailabilityAccExtData()
     * @uses Data::setArrestRecoveryAmountData()
     * @uses Data::setAvailabilityAccDepoData()
     * @uses Data::setRealtyRegistryExtractData()
     * @uses Data::setSvedNedvData()
     * @uses Data::setSvedNedvObject()
     * @uses Data::setSvedNedvRightData()
     * @uses Data::setSvedNedvEncumbranceData()
     * @uses Data::setSvedNedvShareHoldingData()
     * @uses Data::setObjectData()
     * @uses Data::setKKTData()
     * @uses Data::setAccountingData()
     * @uses Data::setTicketDatum()
     * @uses Data::setPersonDatum()
     * @uses Data::setCompanyDatum()
     * @uses Data::setPaymentDatum()
     * @uses Data::setCountDatum()
     * @uses Data::setCompanyAddressDatum()
     * @uses Data::setRegOrganDatum()
     * @uses Data::setShipDatum()
     * @uses Data::setMachineDatum()
     * @uses Data::setFounderCompanyDatum()
     * @uses Data::setForgnFndrCompanyDatum()
     * @uses Data::setCompanyExtDatum()
     * @uses Data::setFounderPersonDatum()
     * @uses Data::setCompanyManagementDatum()
     * @uses Data::setSoleEntrepreneurDatum()
     * @uses Data::setRegistrationDatum()
     * @uses Data::setLicenseDatum()
     * @uses Data::setSubdivisionDatum()
     * @uses Data::setEgrulEgripDatum()
     * @uses Data::setAccountDatum()
     * @uses Data::setAccountExtDatum()
     * @uses Data::setSoleEntrepreneurOldRegDatum()
     * @uses Data::setDocumentDatum()
     * @uses Data::setFishQuotaContractDatum()
     * @uses Data::setFishQuotaYearDatum()
     * @uses Data::setFishNonquotaContractDatum()
     * @uses Data::setTransactionDatum()
     * @uses Data::setDeathDatum()
     * @uses Data::setUnaccountedForDatum()
     * @uses Data::setDepositBoxDatum()
     * @uses Data::setAccountTransactionType()
     * @uses Data::setAccountEncumbranceDatum()
     * @uses Data::setPropertyObligationDatum()
     * @uses Data::setUnstructuredDatum()
     * @uses Data::setUnemployedPersonCaseDatum()
     * @uses Data::setUnemployedPersonRegistrationDatum()
     * @uses Data::setSeniorityPeriodDatum()
     * @uses Data::setSalaryWithheldDatum()
     * @uses Data::setCashLetterDatum()
     * @uses Data::setValidationDatum()
     * @uses Data::setGoodsDatum()
     * @uses Data::setWeaponDatum()
     * @uses Data::setSentencedPersonImprisonmentDatum()
     * @uses Data::setSentencedPersonNoImprisonmentDatum()
     * @uses Data::setBKIDatum()
     * @param \StructType\IdentificationDataType $identificationData
     * @param \StructType\AddressDataType $addressData
     * @param \StructType\TelephoneDataType $telephoneData
     * @param \StructType\TransportDataType $transportData
     * @param \StructType\SvedRabDataType $svedRabData
     * @param \StructType\ManagementDataType $managementData
     * @param \StructType\SvedDoxodDataType $svedDoxodData
     * @param \StructType\DebtorStateDataType $debtorStateData
     * @param \StructType\AvailabilityAccDataType $availabilityAccData
     * @param \StructType\AvailabilityAccExtDataType $availabilityAccExtData
     * @param \StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData
     * @param \StructType\AvailabilityAccDepoDataType $availabilityAccDepoData
     * @param \StructType\RealtyRegistryExtractType $realtyRegistryExtractData
     * @param \StructType\SvedNedvDataType $svedNedvData
     * @param \StructType\SvedNedvObjectType $svedNedvObject
     * @param \StructType\SvedNedvRightType $svedNedvRightData
     * @param \StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData
     * @param \StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData
     * @param \StructType\ObjectDataType $objectData
     * @param \StructType\KKTDataType $kKTData
     * @param \StructType\AccountingDataType $accountingData
     * @param \StructType\TicketDatumType $ticketDatum
     * @param \StructType\PersonDatumType $personDatum
     * @param \StructType\CompanyDatumType $companyDatum
     * @param \StructType\PaymentDatumType $paymentDatum
     * @param \StructType\CountDatumType $countDatum
     * @param \StructType\CompanyAddressDatumType $companyAddressDatum
     * @param \StructType\RegOrganDatumType $regOrganDatum
     * @param \StructType\ShipDatumType $shipDatum
     * @param \StructType\MachineDatumType $machineDatum
     * @param \StructType\FounderCompanyDatumType $founderCompanyDatum
     * @param \StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum
     * @param \StructType\CompanyExtDatumType $companyExtDatum
     * @param \StructType\FounderPersonDatumType $founderPersonDatum
     * @param \StructType\CompanyManagementDatumType $companyManagementDatum
     * @param \StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum
     * @param \StructType\RegistrationDatumType $registrationDatum
     * @param \StructType\LicenseDatumType $licenseDatum
     * @param \StructType\SubdivisionDatumType $subdivisionDatum
     * @param \StructType\EgrulEgripDatumType $egrulEgripDatum
     * @param \StructType\AccountDatumType $accountDatum
     * @param \StructType\AccountExtDatumType $accountExtDatum
     * @param \StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum
     * @param \StructType\DocumentDatumType $documentDatum
     * @param \StructType\FishQuotaContractDatumType $fishQuotaContractDatum
     * @param \StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum
     * @param \StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum
     * @param \StructType\TransactionDatumType $transactionDatum
     * @param \StructType\DeathDatumType $deathDatum
     * @param \StructType\UnaccountedForDatumType $unaccountedForDatum
     * @param \StructType\DepositBoxDatumType $depositBoxDatum
     * @param \StructType\AccountTransactionDatumType $accountTransactionType
     * @param \StructType\AccountEncumbranceDatumType $accountEncumbranceDatum
     * @param \StructType\PropertyObligationDatumType $propertyObligationDatum
     * @param \StructType\UnstructuredDatumType $unstructuredDatum
     * @param \StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum
     * @param \StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum
     * @param \StructType\SeniorityPeriodDatumType $seniorityPeriodDatum
     * @param \StructType\SalaryWithheldDatumType $salaryWithheldDatum
     * @param \StructType\CashLetterDatumType $cashLetterDatum
     * @param \StructType\ValidationDatumType $validationDatum
     * @param \StructType\GoodsDatumType $goodsDatum
     * @param \StructType\WeaponDatumType $weaponDatum
     * @param \StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum
     * @param \StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum
     * @param \StructType\BKIDatumType $bKIDatum
     */
    public function __construct(\StructType\IdentificationDataType $identificationData = null, \StructType\AddressDataType $addressData = null, \StructType\TelephoneDataType $telephoneData = null, \StructType\TransportDataType $transportData = null, \StructType\SvedRabDataType $svedRabData = null, \StructType\ManagementDataType $managementData = null, \StructType\SvedDoxodDataType $svedDoxodData = null, \StructType\DebtorStateDataType $debtorStateData = null, \StructType\AvailabilityAccDataType $availabilityAccData = null, \StructType\AvailabilityAccExtDataType $availabilityAccExtData = null, \StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData = null, \StructType\AvailabilityAccDepoDataType $availabilityAccDepoData = null, \StructType\RealtyRegistryExtractType $realtyRegistryExtractData = null, \StructType\SvedNedvDataType $svedNedvData = null, \StructType\SvedNedvObjectType $svedNedvObject = null, \StructType\SvedNedvRightType $svedNedvRightData = null, \StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData = null, \StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData = null, \StructType\ObjectDataType $objectData = null, \StructType\KKTDataType $kKTData = null, \StructType\AccountingDataType $accountingData = null, \StructType\TicketDatumType $ticketDatum = null, \StructType\PersonDatumType $personDatum = null, \StructType\CompanyDatumType $companyDatum = null, \StructType\PaymentDatumType $paymentDatum = null, \StructType\CountDatumType $countDatum = null, \StructType\CompanyAddressDatumType $companyAddressDatum = null, \StructType\RegOrganDatumType $regOrganDatum = null, \StructType\ShipDatumType $shipDatum = null, \StructType\MachineDatumType $machineDatum = null, \StructType\FounderCompanyDatumType $founderCompanyDatum = null, \StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum = null, \StructType\CompanyExtDatumType $companyExtDatum = null, \StructType\FounderPersonDatumType $founderPersonDatum = null, \StructType\CompanyManagementDatumType $companyManagementDatum = null, \StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum = null, \StructType\RegistrationDatumType $registrationDatum = null, \StructType\LicenseDatumType $licenseDatum = null, \StructType\SubdivisionDatumType $subdivisionDatum = null, \StructType\EgrulEgripDatumType $egrulEgripDatum = null, \StructType\AccountDatumType $accountDatum = null, \StructType\AccountExtDatumType $accountExtDatum = null, \StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum = null, \StructType\DocumentDatumType $documentDatum = null, \StructType\FishQuotaContractDatumType $fishQuotaContractDatum = null, \StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum = null, \StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum = null, \StructType\TransactionDatumType $transactionDatum = null, \StructType\DeathDatumType $deathDatum = null, \StructType\UnaccountedForDatumType $unaccountedForDatum = null, \StructType\DepositBoxDatumType $depositBoxDatum = null, \StructType\AccountTransactionDatumType $accountTransactionType = null, \StructType\AccountEncumbranceDatumType $accountEncumbranceDatum = null, \StructType\PropertyObligationDatumType $propertyObligationDatum = null, \StructType\UnstructuredDatumType $unstructuredDatum = null, \StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum = null, \StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum = null, \StructType\SeniorityPeriodDatumType $seniorityPeriodDatum = null, \StructType\SalaryWithheldDatumType $salaryWithheldDatum = null, \StructType\CashLetterDatumType $cashLetterDatum = null, \StructType\ValidationDatumType $validationDatum = null, \StructType\GoodsDatumType $goodsDatum = null, \StructType\WeaponDatumType $weaponDatum = null, \StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum = null, \StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum = null, \StructType\BKIDatumType $bKIDatum = null)
    {
        $this
            ->setIdentificationData($identificationData)
            ->setAddressData($addressData)
            ->setTelephoneData($telephoneData)
            ->setTransportData($transportData)
            ->setSvedRabData($svedRabData)
            ->setManagementData($managementData)
            ->setSvedDoxodData($svedDoxodData)
            ->setDebtorStateData($debtorStateData)
            ->setAvailabilityAccData($availabilityAccData)
            ->setAvailabilityAccExtData($availabilityAccExtData)
            ->setArrestRecoveryAmountData($arrestRecoveryAmountData)
            ->setAvailabilityAccDepoData($availabilityAccDepoData)
            ->setRealtyRegistryExtractData($realtyRegistryExtractData)
            ->setSvedNedvData($svedNedvData)
            ->setSvedNedvObject($svedNedvObject)
            ->setSvedNedvRightData($svedNedvRightData)
            ->setSvedNedvEncumbranceData($svedNedvEncumbranceData)
            ->setSvedNedvShareHoldingData($svedNedvShareHoldingData)
            ->setObjectData($objectData)
            ->setKKTData($kKTData)
            ->setAccountingData($accountingData)
            ->setTicketDatum($ticketDatum)
            ->setPersonDatum($personDatum)
            ->setCompanyDatum($companyDatum)
            ->setPaymentDatum($paymentDatum)
            ->setCountDatum($countDatum)
            ->setCompanyAddressDatum($companyAddressDatum)
            ->setRegOrganDatum($regOrganDatum)
            ->setShipDatum($shipDatum)
            ->setMachineDatum($machineDatum)
            ->setFounderCompanyDatum($founderCompanyDatum)
            ->setForgnFndrCompanyDatum($forgnFndrCompanyDatum)
            ->setCompanyExtDatum($companyExtDatum)
            ->setFounderPersonDatum($founderPersonDatum)
            ->setCompanyManagementDatum($companyManagementDatum)
            ->setSoleEntrepreneurDatum($soleEntrepreneurDatum)
            ->setRegistrationDatum($registrationDatum)
            ->setLicenseDatum($licenseDatum)
            ->setSubdivisionDatum($subdivisionDatum)
            ->setEgrulEgripDatum($egrulEgripDatum)
            ->setAccountDatum($accountDatum)
            ->setAccountExtDatum($accountExtDatum)
            ->setSoleEntrepreneurOldRegDatum($soleEntrepreneurOldRegDatum)
            ->setDocumentDatum($documentDatum)
            ->setFishQuotaContractDatum($fishQuotaContractDatum)
            ->setFishQuotaYearDatum($fishQuotaYearDatum)
            ->setFishNonquotaContractDatum($fishNonquotaContractDatum)
            ->setTransactionDatum($transactionDatum)
            ->setDeathDatum($deathDatum)
            ->setUnaccountedForDatum($unaccountedForDatum)
            ->setDepositBoxDatum($depositBoxDatum)
            ->setAccountTransactionType($accountTransactionType)
            ->setAccountEncumbranceDatum($accountEncumbranceDatum)
            ->setPropertyObligationDatum($propertyObligationDatum)
            ->setUnstructuredDatum($unstructuredDatum)
            ->setUnemployedPersonCaseDatum($unemployedPersonCaseDatum)
            ->setUnemployedPersonRegistrationDatum($unemployedPersonRegistrationDatum)
            ->setSeniorityPeriodDatum($seniorityPeriodDatum)
            ->setSalaryWithheldDatum($salaryWithheldDatum)
            ->setCashLetterDatum($cashLetterDatum)
            ->setValidationDatum($validationDatum)
            ->setGoodsDatum($goodsDatum)
            ->setWeaponDatum($weaponDatum)
            ->setSentencedPersonImprisonmentDatum($sentencedPersonImprisonmentDatum)
            ->setSentencedPersonNoImprisonmentDatum($sentencedPersonNoImprisonmentDatum)
            ->setBKIDatum($bKIDatum);
    }
    /**
     * Get IdentificationData value
     * @return \StructType\IdentificationDataType|null
     */
    public function getIdentificationData()
    {
        return $this->IdentificationData;
    }
    /**
     * Set IdentificationData value
     * @param \StructType\IdentificationDataType $identificationData
     * @return \StructType\Data
     */
    public function setIdentificationData(\StructType\IdentificationDataType $identificationData = null)
    {
        $this->IdentificationData = $identificationData;
        return $this;
    }
    /**
     * Get AddressData value
     * @return \StructType\AddressDataType|null
     */
    public function getAddressData()
    {
        return $this->AddressData;
    }
    /**
     * Set AddressData value
     * @param \StructType\AddressDataType $addressData
     * @return \StructType\Data
     */
    public function setAddressData(\StructType\AddressDataType $addressData = null)
    {
        $this->AddressData = $addressData;
        return $this;
    }
    /**
     * Get TelephoneData value
     * @return \StructType\TelephoneDataType|null
     */
    public function getTelephoneData()
    {
        return $this->TelephoneData;
    }
    /**
     * Set TelephoneData value
     * @param \StructType\TelephoneDataType $telephoneData
     * @return \StructType\Data
     */
    public function setTelephoneData(\StructType\TelephoneDataType $telephoneData = null)
    {
        $this->TelephoneData = $telephoneData;
        return $this;
    }
    /**
     * Get TransportData value
     * @return \StructType\TransportDataType|null
     */
    public function getTransportData()
    {
        return $this->TransportData;
    }
    /**
     * Set TransportData value
     * @param \StructType\TransportDataType $transportData
     * @return \StructType\Data
     */
    public function setTransportData(\StructType\TransportDataType $transportData = null)
    {
        $this->TransportData = $transportData;
        return $this;
    }
    /**
     * Get SvedRabData value
     * @return \StructType\SvedRabDataType|null
     */
    public function getSvedRabData()
    {
        return $this->SvedRabData;
    }
    /**
     * Set SvedRabData value
     * @param \StructType\SvedRabDataType $svedRabData
     * @return \StructType\Data
     */
    public function setSvedRabData(\StructType\SvedRabDataType $svedRabData = null)
    {
        $this->SvedRabData = $svedRabData;
        return $this;
    }
    /**
     * Get ManagementData value
     * @return \StructType\ManagementDataType|null
     */
    public function getManagementData()
    {
        return $this->ManagementData;
    }
    /**
     * Set ManagementData value
     * @param \StructType\ManagementDataType $managementData
     * @return \StructType\Data
     */
    public function setManagementData(\StructType\ManagementDataType $managementData = null)
    {
        $this->ManagementData = $managementData;
        return $this;
    }
    /**
     * Get SvedDoxodData value
     * @return \StructType\SvedDoxodDataType|null
     */
    public function getSvedDoxodData()
    {
        return $this->SvedDoxodData;
    }
    /**
     * Set SvedDoxodData value
     * @param \StructType\SvedDoxodDataType $svedDoxodData
     * @return \StructType\Data
     */
    public function setSvedDoxodData(\StructType\SvedDoxodDataType $svedDoxodData = null)
    {
        $this->SvedDoxodData = $svedDoxodData;
        return $this;
    }
    /**
     * Get DebtorStateData value
     * @return \StructType\DebtorStateDataType|null
     */
    public function getDebtorStateData()
    {
        return $this->DebtorStateData;
    }
    /**
     * Set DebtorStateData value
     * @param \StructType\DebtorStateDataType $debtorStateData
     * @return \StructType\Data
     */
    public function setDebtorStateData(\StructType\DebtorStateDataType $debtorStateData = null)
    {
        $this->DebtorStateData = $debtorStateData;
        return $this;
    }
    /**
     * Get AvailabilityAccData value
     * @return \StructType\AvailabilityAccDataType|null
     */
    public function getAvailabilityAccData()
    {
        return $this->AvailabilityAccData;
    }
    /**
     * Set AvailabilityAccData value
     * @param \StructType\AvailabilityAccDataType $availabilityAccData
     * @return \StructType\Data
     */
    public function setAvailabilityAccData(\StructType\AvailabilityAccDataType $availabilityAccData = null)
    {
        $this->AvailabilityAccData = $availabilityAccData;
        return $this;
    }
    /**
     * Get AvailabilityAccExtData value
     * @return \StructType\AvailabilityAccExtDataType|null
     */
    public function getAvailabilityAccExtData()
    {
        return $this->AvailabilityAccExtData;
    }
    /**
     * Set AvailabilityAccExtData value
     * @param \StructType\AvailabilityAccExtDataType $availabilityAccExtData
     * @return \StructType\Data
     */
    public function setAvailabilityAccExtData(\StructType\AvailabilityAccExtDataType $availabilityAccExtData = null)
    {
        $this->AvailabilityAccExtData = $availabilityAccExtData;
        return $this;
    }
    /**
     * Get ArrestRecoveryAmountData value
     * @return \StructType\ArrestRecoveryAmountDataType|null
     */
    public function getArrestRecoveryAmountData()
    {
        return $this->ArrestRecoveryAmountData;
    }
    /**
     * Set ArrestRecoveryAmountData value
     * @param \StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData
     * @return \StructType\Data
     */
    public function setArrestRecoveryAmountData(\StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData = null)
    {
        $this->ArrestRecoveryAmountData = $arrestRecoveryAmountData;
        return $this;
    }
    /**
     * Get AvailabilityAccDepoData value
     * @return \StructType\AvailabilityAccDepoDataType|null
     */
    public function getAvailabilityAccDepoData()
    {
        return $this->AvailabilityAccDepoData;
    }
    /**
     * Set AvailabilityAccDepoData value
     * @param \StructType\AvailabilityAccDepoDataType $availabilityAccDepoData
     * @return \StructType\Data
     */
    public function setAvailabilityAccDepoData(\StructType\AvailabilityAccDepoDataType $availabilityAccDepoData = null)
    {
        $this->AvailabilityAccDepoData = $availabilityAccDepoData;
        return $this;
    }
    /**
     * Get RealtyRegistryExtractData value
     * @return \StructType\RealtyRegistryExtractType|null
     */
    public function getRealtyRegistryExtractData()
    {
        return $this->RealtyRegistryExtractData;
    }
    /**
     * Set RealtyRegistryExtractData value
     * @param \StructType\RealtyRegistryExtractType $realtyRegistryExtractData
     * @return \StructType\Data
     */
    public function setRealtyRegistryExtractData(\StructType\RealtyRegistryExtractType $realtyRegistryExtractData = null)
    {
        $this->RealtyRegistryExtractData = $realtyRegistryExtractData;
        return $this;
    }
    /**
     * Get SvedNedvData value
     * @return \StructType\SvedNedvDataType|null
     */
    public function getSvedNedvData()
    {
        return $this->SvedNedvData;
    }
    /**
     * Set SvedNedvData value
     * @param \StructType\SvedNedvDataType $svedNedvData
     * @return \StructType\Data
     */
    public function setSvedNedvData(\StructType\SvedNedvDataType $svedNedvData = null)
    {
        $this->SvedNedvData = $svedNedvData;
        return $this;
    }
    /**
     * Get SvedNedvObject value
     * @return \StructType\SvedNedvObjectType|null
     */
    public function getSvedNedvObject()
    {
        return $this->SvedNedvObject;
    }
    /**
     * Set SvedNedvObject value
     * @param \StructType\SvedNedvObjectType $svedNedvObject
     * @return \StructType\Data
     */
    public function setSvedNedvObject(\StructType\SvedNedvObjectType $svedNedvObject = null)
    {
        $this->SvedNedvObject = $svedNedvObject;
        return $this;
    }
    /**
     * Get SvedNedvRightData value
     * @return \StructType\SvedNedvRightType|null
     */
    public function getSvedNedvRightData()
    {
        return $this->SvedNedvRightData;
    }
    /**
     * Set SvedNedvRightData value
     * @param \StructType\SvedNedvRightType $svedNedvRightData
     * @return \StructType\Data
     */
    public function setSvedNedvRightData(\StructType\SvedNedvRightType $svedNedvRightData = null)
    {
        $this->SvedNedvRightData = $svedNedvRightData;
        return $this;
    }
    /**
     * Get SvedNedvEncumbranceData value
     * @return \StructType\SvedNedvEncumbranceType|null
     */
    public function getSvedNedvEncumbranceData()
    {
        return $this->SvedNedvEncumbranceData;
    }
    /**
     * Set SvedNedvEncumbranceData value
     * @param \StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData
     * @return \StructType\Data
     */
    public function setSvedNedvEncumbranceData(\StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData = null)
    {
        $this->SvedNedvEncumbranceData = $svedNedvEncumbranceData;
        return $this;
    }
    /**
     * Get SvedNedvShareHoldingData value
     * @return \StructType\SvedNedvShareHoldingType|null
     */
    public function getSvedNedvShareHoldingData()
    {
        return $this->SvedNedvShareHoldingData;
    }
    /**
     * Set SvedNedvShareHoldingData value
     * @param \StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData
     * @return \StructType\Data
     */
    public function setSvedNedvShareHoldingData(\StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData = null)
    {
        $this->SvedNedvShareHoldingData = $svedNedvShareHoldingData;
        return $this;
    }
    /**
     * Get ObjectData value
     * @return \StructType\ObjectDataType|null
     */
    public function getObjectData()
    {
        return $this->ObjectData;
    }
    /**
     * Set ObjectData value
     * @param \StructType\ObjectDataType $objectData
     * @return \StructType\Data
     */
    public function setObjectData(\StructType\ObjectDataType $objectData = null)
    {
        $this->ObjectData = $objectData;
        return $this;
    }
    /**
     * Get KKTData value
     * @return \StructType\KKTDataType|null
     */
    public function getKKTData()
    {
        return $this->KKTData;
    }
    /**
     * Set KKTData value
     * @param \StructType\KKTDataType $kKTData
     * @return \StructType\Data
     */
    public function setKKTData(\StructType\KKTDataType $kKTData = null)
    {
        $this->KKTData = $kKTData;
        return $this;
    }
    /**
     * Get AccountingData value
     * @return \StructType\AccountingDataType|null
     */
    public function getAccountingData()
    {
        return $this->AccountingData;
    }
    /**
     * Set AccountingData value
     * @param \StructType\AccountingDataType $accountingData
     * @return \StructType\Data
     */
    public function setAccountingData(\StructType\AccountingDataType $accountingData = null)
    {
        $this->AccountingData = $accountingData;
        return $this;
    }
    /**
     * Get TicketDatum value
     * @return \StructType\TicketDatumType|null
     */
    public function getTicketDatum()
    {
        return $this->TicketDatum;
    }
    /**
     * Set TicketDatum value
     * @param \StructType\TicketDatumType $ticketDatum
     * @return \StructType\Data
     */
    public function setTicketDatum(\StructType\TicketDatumType $ticketDatum = null)
    {
        $this->TicketDatum = $ticketDatum;
        return $this;
    }
    /**
     * Get personDatum value
     * @return \StructType\PersonDatumType|null
     */
    public function getPersonDatum()
    {
        return $this->personDatum;
    }
    /**
     * Set personDatum value
     * @param \StructType\PersonDatumType $personDatum
     * @return \StructType\Data
     */
    public function setPersonDatum(\StructType\PersonDatumType $personDatum = null)
    {
        $this->personDatum = $personDatum;
        return $this;
    }
    /**
     * Get companyDatum value
     * @return \StructType\CompanyDatumType|null
     */
    public function getCompanyDatum()
    {
        return $this->companyDatum;
    }
    /**
     * Set companyDatum value
     * @param \StructType\CompanyDatumType $companyDatum
     * @return \StructType\Data
     */
    public function setCompanyDatum(\StructType\CompanyDatumType $companyDatum = null)
    {
        $this->companyDatum = $companyDatum;
        return $this;
    }
    /**
     * Get paymentDatum value
     * @return \StructType\PaymentDatumType|null
     */
    public function getPaymentDatum()
    {
        return $this->paymentDatum;
    }
    /**
     * Set paymentDatum value
     * @param \StructType\PaymentDatumType $paymentDatum
     * @return \StructType\Data
     */
    public function setPaymentDatum(\StructType\PaymentDatumType $paymentDatum = null)
    {
        $this->paymentDatum = $paymentDatum;
        return $this;
    }
    /**
     * Get countDatum value
     * @return \StructType\CountDatumType|null
     */
    public function getCountDatum()
    {
        return $this->countDatum;
    }
    /**
     * Set countDatum value
     * @param \StructType\CountDatumType $countDatum
     * @return \StructType\Data
     */
    public function setCountDatum(\StructType\CountDatumType $countDatum = null)
    {
        $this->countDatum = $countDatum;
        return $this;
    }
    /**
     * Get companyAddressDatum value
     * @return \StructType\CompanyAddressDatumType|null
     */
    public function getCompanyAddressDatum()
    {
        return $this->companyAddressDatum;
    }
    /**
     * Set companyAddressDatum value
     * @param \StructType\CompanyAddressDatumType $companyAddressDatum
     * @return \StructType\Data
     */
    public function setCompanyAddressDatum(\StructType\CompanyAddressDatumType $companyAddressDatum = null)
    {
        $this->companyAddressDatum = $companyAddressDatum;
        return $this;
    }
    /**
     * Get regOrganDatum value
     * @return \StructType\RegOrganDatumType|null
     */
    public function getRegOrganDatum()
    {
        return $this->regOrganDatum;
    }
    /**
     * Set regOrganDatum value
     * @param \StructType\RegOrganDatumType $regOrganDatum
     * @return \StructType\Data
     */
    public function setRegOrganDatum(\StructType\RegOrganDatumType $regOrganDatum = null)
    {
        $this->regOrganDatum = $regOrganDatum;
        return $this;
    }
    /**
     * Get shipDatum value
     * @return \StructType\ShipDatumType|null
     */
    public function getShipDatum()
    {
        return $this->shipDatum;
    }
    /**
     * Set shipDatum value
     * @param \StructType\ShipDatumType $shipDatum
     * @return \StructType\Data
     */
    public function setShipDatum(\StructType\ShipDatumType $shipDatum = null)
    {
        $this->shipDatum = $shipDatum;
        return $this;
    }
    /**
     * Get machineDatum value
     * @return \StructType\MachineDatumType|null
     */
    public function getMachineDatum()
    {
        return $this->machineDatum;
    }
    /**
     * Set machineDatum value
     * @param \StructType\MachineDatumType $machineDatum
     * @return \StructType\Data
     */
    public function setMachineDatum(\StructType\MachineDatumType $machineDatum = null)
    {
        $this->machineDatum = $machineDatum;
        return $this;
    }
    /**
     * Get founderCompanyDatum value
     * @return \StructType\FounderCompanyDatumType|null
     */
    public function getFounderCompanyDatum()
    {
        return $this->founderCompanyDatum;
    }
    /**
     * Set founderCompanyDatum value
     * @param \StructType\FounderCompanyDatumType $founderCompanyDatum
     * @return \StructType\Data
     */
    public function setFounderCompanyDatum(\StructType\FounderCompanyDatumType $founderCompanyDatum = null)
    {
        $this->founderCompanyDatum = $founderCompanyDatum;
        return $this;
    }
    /**
     * Get forgnFndrCompanyDatum value
     * @return \StructType\ForgnFndrCompanyDatumType|null
     */
    public function getForgnFndrCompanyDatum()
    {
        return $this->forgnFndrCompanyDatum;
    }
    /**
     * Set forgnFndrCompanyDatum value
     * @param \StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum
     * @return \StructType\Data
     */
    public function setForgnFndrCompanyDatum(\StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum = null)
    {
        $this->forgnFndrCompanyDatum = $forgnFndrCompanyDatum;
        return $this;
    }
    /**
     * Get companyExtDatum value
     * @return \StructType\CompanyExtDatumType|null
     */
    public function getCompanyExtDatum()
    {
        return $this->companyExtDatum;
    }
    /**
     * Set companyExtDatum value
     * @param \StructType\CompanyExtDatumType $companyExtDatum
     * @return \StructType\Data
     */
    public function setCompanyExtDatum(\StructType\CompanyExtDatumType $companyExtDatum = null)
    {
        $this->companyExtDatum = $companyExtDatum;
        return $this;
    }
    /**
     * Get founderPersonDatum value
     * @return \StructType\FounderPersonDatumType|null
     */
    public function getFounderPersonDatum()
    {
        return $this->founderPersonDatum;
    }
    /**
     * Set founderPersonDatum value
     * @param \StructType\FounderPersonDatumType $founderPersonDatum
     * @return \StructType\Data
     */
    public function setFounderPersonDatum(\StructType\FounderPersonDatumType $founderPersonDatum = null)
    {
        $this->founderPersonDatum = $founderPersonDatum;
        return $this;
    }
    /**
     * Get companyManagementDatum value
     * @return \StructType\CompanyManagementDatumType|null
     */
    public function getCompanyManagementDatum()
    {
        return $this->companyManagementDatum;
    }
    /**
     * Set companyManagementDatum value
     * @param \StructType\CompanyManagementDatumType $companyManagementDatum
     * @return \StructType\Data
     */
    public function setCompanyManagementDatum(\StructType\CompanyManagementDatumType $companyManagementDatum = null)
    {
        $this->companyManagementDatum = $companyManagementDatum;
        return $this;
    }
    /**
     * Get soleEntrepreneurDatum value
     * @return \StructType\SoleEntrepreneurDatumType|null
     */
    public function getSoleEntrepreneurDatum()
    {
        return $this->soleEntrepreneurDatum;
    }
    /**
     * Set soleEntrepreneurDatum value
     * @param \StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum
     * @return \StructType\Data
     */
    public function setSoleEntrepreneurDatum(\StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum = null)
    {
        $this->soleEntrepreneurDatum = $soleEntrepreneurDatum;
        return $this;
    }
    /**
     * Get registrationDatum value
     * @return \StructType\RegistrationDatumType|null
     */
    public function getRegistrationDatum()
    {
        return $this->registrationDatum;
    }
    /**
     * Set registrationDatum value
     * @param \StructType\RegistrationDatumType $registrationDatum
     * @return \StructType\Data
     */
    public function setRegistrationDatum(\StructType\RegistrationDatumType $registrationDatum = null)
    {
        $this->registrationDatum = $registrationDatum;
        return $this;
    }
    /**
     * Get licenseDatum value
     * @return \StructType\LicenseDatumType|null
     */
    public function getLicenseDatum()
    {
        return $this->licenseDatum;
    }
    /**
     * Set licenseDatum value
     * @param \StructType\LicenseDatumType $licenseDatum
     * @return \StructType\Data
     */
    public function setLicenseDatum(\StructType\LicenseDatumType $licenseDatum = null)
    {
        $this->licenseDatum = $licenseDatum;
        return $this;
    }
    /**
     * Get subdivisionDatum value
     * @return \StructType\SubdivisionDatumType|null
     */
    public function getSubdivisionDatum()
    {
        return $this->subdivisionDatum;
    }
    /**
     * Set subdivisionDatum value
     * @param \StructType\SubdivisionDatumType $subdivisionDatum
     * @return \StructType\Data
     */
    public function setSubdivisionDatum(\StructType\SubdivisionDatumType $subdivisionDatum = null)
    {
        $this->subdivisionDatum = $subdivisionDatum;
        return $this;
    }
    /**
     * Get egrulEgripDatum value
     * @return \StructType\EgrulEgripDatumType|null
     */
    public function getEgrulEgripDatum()
    {
        return $this->egrulEgripDatum;
    }
    /**
     * Set egrulEgripDatum value
     * @param \StructType\EgrulEgripDatumType $egrulEgripDatum
     * @return \StructType\Data
     */
    public function setEgrulEgripDatum(\StructType\EgrulEgripDatumType $egrulEgripDatum = null)
    {
        $this->egrulEgripDatum = $egrulEgripDatum;
        return $this;
    }
    /**
     * Get accountDatum value
     * @return \StructType\AccountDatumType|null
     */
    public function getAccountDatum()
    {
        return $this->accountDatum;
    }
    /**
     * Set accountDatum value
     * @param \StructType\AccountDatumType $accountDatum
     * @return \StructType\Data
     */
    public function setAccountDatum(\StructType\AccountDatumType $accountDatum = null)
    {
        $this->accountDatum = $accountDatum;
        return $this;
    }
    /**
     * Get accountExtDatum value
     * @return \StructType\AccountExtDatumType|null
     */
    public function getAccountExtDatum()
    {
        return $this->accountExtDatum;
    }
    /**
     * Set accountExtDatum value
     * @param \StructType\AccountExtDatumType $accountExtDatum
     * @return \StructType\Data
     */
    public function setAccountExtDatum(\StructType\AccountExtDatumType $accountExtDatum = null)
    {
        $this->accountExtDatum = $accountExtDatum;
        return $this;
    }
    /**
     * Get soleEntrepreneurOldRegDatum value
     * @return \StructType\SoleEntrepreneurOldRegDatumType|null
     */
    public function getSoleEntrepreneurOldRegDatum()
    {
        return $this->soleEntrepreneurOldRegDatum;
    }
    /**
     * Set soleEntrepreneurOldRegDatum value
     * @param \StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum
     * @return \StructType\Data
     */
    public function setSoleEntrepreneurOldRegDatum(\StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum = null)
    {
        $this->soleEntrepreneurOldRegDatum = $soleEntrepreneurOldRegDatum;
        return $this;
    }
    /**
     * Get documentDatum value
     * @return \StructType\DocumentDatumType|null
     */
    public function getDocumentDatum()
    {
        return $this->documentDatum;
    }
    /**
     * Set documentDatum value
     * @param \StructType\DocumentDatumType $documentDatum
     * @return \StructType\Data
     */
    public function setDocumentDatum(\StructType\DocumentDatumType $documentDatum = null)
    {
        $this->documentDatum = $documentDatum;
        return $this;
    }
    /**
     * Get fishQuotaContractDatum value
     * @return \StructType\FishQuotaContractDatumType|null
     */
    public function getFishQuotaContractDatum()
    {
        return $this->fishQuotaContractDatum;
    }
    /**
     * Set fishQuotaContractDatum value
     * @param \StructType\FishQuotaContractDatumType $fishQuotaContractDatum
     * @return \StructType\Data
     */
    public function setFishQuotaContractDatum(\StructType\FishQuotaContractDatumType $fishQuotaContractDatum = null)
    {
        $this->fishQuotaContractDatum = $fishQuotaContractDatum;
        return $this;
    }
    /**
     * Get fishQuotaYearDatum value
     * @return \StructType\FishQuotaCurYearDatumType|null
     */
    public function getFishQuotaYearDatum()
    {
        return $this->fishQuotaYearDatum;
    }
    /**
     * Set fishQuotaYearDatum value
     * @param \StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum
     * @return \StructType\Data
     */
    public function setFishQuotaYearDatum(\StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum = null)
    {
        $this->fishQuotaYearDatum = $fishQuotaYearDatum;
        return $this;
    }
    /**
     * Get fishNonquotaContractDatum value
     * @return \StructType\FishNonquotaContractDatumType|null
     */
    public function getFishNonquotaContractDatum()
    {
        return $this->fishNonquotaContractDatum;
    }
    /**
     * Set fishNonquotaContractDatum value
     * @param \StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum
     * @return \StructType\Data
     */
    public function setFishNonquotaContractDatum(\StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum = null)
    {
        $this->fishNonquotaContractDatum = $fishNonquotaContractDatum;
        return $this;
    }
    /**
     * Get transactionDatum value
     * @return \StructType\TransactionDatumType|null
     */
    public function getTransactionDatum()
    {
        return $this->transactionDatum;
    }
    /**
     * Set transactionDatum value
     * @param \StructType\TransactionDatumType $transactionDatum
     * @return \StructType\Data
     */
    public function setTransactionDatum(\StructType\TransactionDatumType $transactionDatum = null)
    {
        $this->transactionDatum = $transactionDatum;
        return $this;
    }
    /**
     * Get deathDatum value
     * @return \StructType\DeathDatumType|null
     */
    public function getDeathDatum()
    {
        return $this->deathDatum;
    }
    /**
     * Set deathDatum value
     * @param \StructType\DeathDatumType $deathDatum
     * @return \StructType\Data
     */
    public function setDeathDatum(\StructType\DeathDatumType $deathDatum = null)
    {
        $this->deathDatum = $deathDatum;
        return $this;
    }
    /**
     * Get unaccountedForDatum value
     * @return \StructType\UnaccountedForDatumType|null
     */
    public function getUnaccountedForDatum()
    {
        return $this->unaccountedForDatum;
    }
    /**
     * Set unaccountedForDatum value
     * @param \StructType\UnaccountedForDatumType $unaccountedForDatum
     * @return \StructType\Data
     */
    public function setUnaccountedForDatum(\StructType\UnaccountedForDatumType $unaccountedForDatum = null)
    {
        $this->unaccountedForDatum = $unaccountedForDatum;
        return $this;
    }
    /**
     * Get DepositBoxDatum value
     * @return \StructType\DepositBoxDatumType|null
     */
    public function getDepositBoxDatum()
    {
        return $this->DepositBoxDatum;
    }
    /**
     * Set DepositBoxDatum value
     * @param \StructType\DepositBoxDatumType $depositBoxDatum
     * @return \StructType\Data
     */
    public function setDepositBoxDatum(\StructType\DepositBoxDatumType $depositBoxDatum = null)
    {
        $this->DepositBoxDatum = $depositBoxDatum;
        return $this;
    }
    /**
     * Get accountTransactionType value
     * @return \StructType\AccountTransactionDatumType|null
     */
    public function getAccountTransactionType()
    {
        return $this->accountTransactionType;
    }
    /**
     * Set accountTransactionType value
     * @param \StructType\AccountTransactionDatumType $accountTransactionType
     * @return \StructType\Data
     */
    public function setAccountTransactionType(\StructType\AccountTransactionDatumType $accountTransactionType = null)
    {
        $this->accountTransactionType = $accountTransactionType;
        return $this;
    }
    /**
     * Get AccountEncumbranceDatum value
     * @return \StructType\AccountEncumbranceDatumType|null
     */
    public function getAccountEncumbranceDatum()
    {
        return $this->AccountEncumbranceDatum;
    }
    /**
     * Set AccountEncumbranceDatum value
     * @param \StructType\AccountEncumbranceDatumType $accountEncumbranceDatum
     * @return \StructType\Data
     */
    public function setAccountEncumbranceDatum(\StructType\AccountEncumbranceDatumType $accountEncumbranceDatum = null)
    {
        $this->AccountEncumbranceDatum = $accountEncumbranceDatum;
        return $this;
    }
    /**
     * Get propertyObligationDatum value
     * @return \StructType\PropertyObligationDatumType|null
     */
    public function getPropertyObligationDatum()
    {
        return $this->propertyObligationDatum;
    }
    /**
     * Set propertyObligationDatum value
     * @param \StructType\PropertyObligationDatumType $propertyObligationDatum
     * @return \StructType\Data
     */
    public function setPropertyObligationDatum(\StructType\PropertyObligationDatumType $propertyObligationDatum = null)
    {
        $this->propertyObligationDatum = $propertyObligationDatum;
        return $this;
    }
    /**
     * Get unstructuredDatum value
     * @return \StructType\UnstructuredDatumType|null
     */
    public function getUnstructuredDatum()
    {
        return $this->unstructuredDatum;
    }
    /**
     * Set unstructuredDatum value
     * @param \StructType\UnstructuredDatumType $unstructuredDatum
     * @return \StructType\Data
     */
    public function setUnstructuredDatum(\StructType\UnstructuredDatumType $unstructuredDatum = null)
    {
        $this->unstructuredDatum = $unstructuredDatum;
        return $this;
    }
    /**
     * Get unemployedPersonCaseDatum value
     * @return \StructType\UnemployedPersonCaseDatumType|null
     */
    public function getUnemployedPersonCaseDatum()
    {
        return $this->unemployedPersonCaseDatum;
    }
    /**
     * Set unemployedPersonCaseDatum value
     * @param \StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum
     * @return \StructType\Data
     */
    public function setUnemployedPersonCaseDatum(\StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum = null)
    {
        $this->unemployedPersonCaseDatum = $unemployedPersonCaseDatum;
        return $this;
    }
    /**
     * Get unemployedPersonRegistrationDatum value
     * @return \StructType\UnemployedPersonRegistrationDatumType|null
     */
    public function getUnemployedPersonRegistrationDatum()
    {
        return $this->unemployedPersonRegistrationDatum;
    }
    /**
     * Set unemployedPersonRegistrationDatum value
     * @param \StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum
     * @return \StructType\Data
     */
    public function setUnemployedPersonRegistrationDatum(\StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum = null)
    {
        $this->unemployedPersonRegistrationDatum = $unemployedPersonRegistrationDatum;
        return $this;
    }
    /**
     * Get seniorityPeriodDatum value
     * @return \StructType\SeniorityPeriodDatumType|null
     */
    public function getSeniorityPeriodDatum()
    {
        return $this->seniorityPeriodDatum;
    }
    /**
     * Set seniorityPeriodDatum value
     * @param \StructType\SeniorityPeriodDatumType $seniorityPeriodDatum
     * @return \StructType\Data
     */
    public function setSeniorityPeriodDatum(\StructType\SeniorityPeriodDatumType $seniorityPeriodDatum = null)
    {
        $this->seniorityPeriodDatum = $seniorityPeriodDatum;
        return $this;
    }
    /**
     * Get SalaryWithheldDatum value
     * @return \StructType\SalaryWithheldDatumType|null
     */
    public function getSalaryWithheldDatum()
    {
        return $this->SalaryWithheldDatum;
    }
    /**
     * Set SalaryWithheldDatum value
     * @param \StructType\SalaryWithheldDatumType $salaryWithheldDatum
     * @return \StructType\Data
     */
    public function setSalaryWithheldDatum(\StructType\SalaryWithheldDatumType $salaryWithheldDatum = null)
    {
        $this->SalaryWithheldDatum = $salaryWithheldDatum;
        return $this;
    }
    /**
     * Get CashLetterDatum value
     * @return \StructType\CashLetterDatumType|null
     */
    public function getCashLetterDatum()
    {
        return $this->CashLetterDatum;
    }
    /**
     * Set CashLetterDatum value
     * @param \StructType\CashLetterDatumType $cashLetterDatum
     * @return \StructType\Data
     */
    public function setCashLetterDatum(\StructType\CashLetterDatumType $cashLetterDatum = null)
    {
        $this->CashLetterDatum = $cashLetterDatum;
        return $this;
    }
    /**
     * Get ValidationDatum value
     * @return \StructType\ValidationDatumType|null
     */
    public function getValidationDatum()
    {
        return $this->ValidationDatum;
    }
    /**
     * Set ValidationDatum value
     * @param \StructType\ValidationDatumType $validationDatum
     * @return \StructType\Data
     */
    public function setValidationDatum(\StructType\ValidationDatumType $validationDatum = null)
    {
        $this->ValidationDatum = $validationDatum;
        return $this;
    }
    /**
     * Get GoodsDatum value
     * @return \StructType\GoodsDatumType|null
     */
    public function getGoodsDatum()
    {
        return $this->GoodsDatum;
    }
    /**
     * Set GoodsDatum value
     * @param \StructType\GoodsDatumType $goodsDatum
     * @return \StructType\Data
     */
    public function setGoodsDatum(\StructType\GoodsDatumType $goodsDatum = null)
    {
        $this->GoodsDatum = $goodsDatum;
        return $this;
    }
    /**
     * Get WeaponDatum value
     * @return \StructType\WeaponDatumType|null
     */
    public function getWeaponDatum()
    {
        return $this->WeaponDatum;
    }
    /**
     * Set WeaponDatum value
     * @param \StructType\WeaponDatumType $weaponDatum
     * @return \StructType\Data
     */
    public function setWeaponDatum(\StructType\WeaponDatumType $weaponDatum = null)
    {
        $this->WeaponDatum = $weaponDatum;
        return $this;
    }
    /**
     * Get SentencedPersonImprisonmentDatum value
     * @return \StructType\SentencedPersonImprisonmentType|null
     */
    public function getSentencedPersonImprisonmentDatum()
    {
        return $this->SentencedPersonImprisonmentDatum;
    }
    /**
     * Set SentencedPersonImprisonmentDatum value
     * @param \StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum
     * @return \StructType\Data
     */
    public function setSentencedPersonImprisonmentDatum(\StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum = null)
    {
        $this->SentencedPersonImprisonmentDatum = $sentencedPersonImprisonmentDatum;
        return $this;
    }
    /**
     * Get SentencedPersonNoImprisonmentDatum value
     * @return \StructType\SentencedPersonNoImprisonmentType|null
     */
    public function getSentencedPersonNoImprisonmentDatum()
    {
        return $this->SentencedPersonNoImprisonmentDatum;
    }
    /**
     * Set SentencedPersonNoImprisonmentDatum value
     * @param \StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum
     * @return \StructType\Data
     */
    public function setSentencedPersonNoImprisonmentDatum(\StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum = null)
    {
        $this->SentencedPersonNoImprisonmentDatum = $sentencedPersonNoImprisonmentDatum;
        return $this;
    }
    /**
     * Get BKIDatum value
     * @return \StructType\BKIDatumType|null
     */
    public function getBKIDatum()
    {
        return $this->BKIDatum;
    }
    /**
     * Set BKIDatum value
     * @param \StructType\BKIDatumType $bKIDatum
     * @return \StructType\Data
     */
    public function setBKIDatum(\StructType\BKIDatumType $bKIDatum = null)
    {
        $this->BKIDatum = $bKIDatum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Data
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
