<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция | Квитанция на пакет документов
 * - type: tns:DXReceipt
 * @subpackage Structs
 */
class DXReceipt extends DXBlock
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки пакета
     * @var string
     */
    public $Status;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - documentation: Информация об ошибке
     * - minOccurs: 0
     * @var \StructType\MessageEx
     */
    public $ErrorMessage;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Технологические сообщения о приеме документов
     * - minOccurs: 0
     * @var \StructType\DocNoteCollection
     */
    public $Notes;
    /**
     * The time_src_rcv
     * Meta informations extracted from the WSDL
     * - documentation: Дата в время приема пакета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_src_rcv;
    /**
     * The recipient_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета (получателя) | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $recipient_id;
    /**
     * The origin_pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор исходного пакета | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $origin_pack_id;
    /**
     * The is_completed
     * Meta informations extracted from the WSDL
     * - documentation: Признак окончательной квитанции | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $is_completed;
    /**
     * Constructor method for DXReceipt
     * @uses DXReceipt::setStatus()
     * @uses DXReceipt::setErrorMessage()
     * @uses DXReceipt::setNotes()
     * @uses DXReceipt::setTime_src_rcv()
     * @uses DXReceipt::setRecipient_id()
     * @uses DXReceipt::setOrigin_pack_id()
     * @uses DXReceipt::setIs_completed()
     * @param string $status
     * @param \StructType\MessageEx $errorMessage
     * @param \StructType\DocNoteCollection $notes
     * @param string $time_src_rcv
     * @param string $recipient_id
     * @param string $origin_pack_id
     * @param bool $is_completed
     */
    public function __construct($status = null, \StructType\MessageEx $errorMessage = null, \StructType\DocNoteCollection $notes = null, $time_src_rcv = null, $recipient_id = null, $origin_pack_id = null, $is_completed = null)
    {
        $this
            ->setStatus($status)
            ->setErrorMessage($errorMessage)
            ->setNotes($notes)
            ->setTime_src_rcv($time_src_rcv)
            ->setRecipient_id($recipient_id)
            ->setOrigin_pack_id($origin_pack_id)
            ->setIs_completed($is_completed);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProcessResult::valueIsValid()
     * @uses \EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DXReceipt
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return \StructType\MessageEx|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param \StructType\MessageEx $errorMessage
     * @return \StructType\DXReceipt
     */
    public function setErrorMessage(\StructType\MessageEx $errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Notes value
     * @return \StructType\DocNoteCollection|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \StructType\DocNoteCollection $notes
     * @return \StructType\DXReceipt
     */
    public function setNotes(\StructType\DocNoteCollection $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get time_src_rcv value
     * @return string|null
     */
    public function getTime_src_rcv()
    {
        return $this->time_src_rcv;
    }
    /**
     * Set time_src_rcv value
     * @param string $time_src_rcv
     * @return \StructType\DXReceipt
     */
    public function setTime_src_rcv($time_src_rcv = null)
    {
        $this->time_src_rcv = $time_src_rcv;
        return $this;
    }
    /**
     * Get recipient_id value
     * @return string|null
     */
    public function getRecipient_id()
    {
        return $this->recipient_id;
    }
    /**
     * Set recipient_id value
     * @param string $recipient_id
     * @return \StructType\DXReceipt
     */
    public function setRecipient_id($recipient_id = null)
    {
        $this->recipient_id = $recipient_id;
        return $this;
    }
    /**
     * Get origin_pack_id value
     * @return string|null
     */
    public function getOrigin_pack_id()
    {
        return $this->origin_pack_id;
    }
    /**
     * Set origin_pack_id value
     * @param string $origin_pack_id
     * @return \StructType\DXReceipt
     */
    public function setOrigin_pack_id($origin_pack_id = null)
    {
        $this->origin_pack_id = $origin_pack_id;
        return $this;
    }
    /**
     * Get is_completed value
     * @return bool|null
     */
    public function getIs_completed()
    {
        return $this->is_completed;
    }
    /**
     * Set is_completed value
     * @param bool $is_completed
     * @return \StructType\DXReceipt
     */
    public function setIs_completed($is_completed = null)
    {
        $this->is_completed = $is_completed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
