<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXLookupTableData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные справочника
 * - type: tns:DXLookupTableData
 * @subpackage Structs
 */
class DXLookupTableData extends DXBlock
{
    /**
     * The LookupTableName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование справочника | Тип метаобъекта
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $LookupTableName;
    /**
     * The LookupTableData
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника
     * @var \StructType\LookupTableData
     */
    public $LookupTableData;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке
     * @var \StructType\MessageEx
     */
    public $Message;
    /**
     * Constructor method for DXLookupTableData
     * @uses DXLookupTableData::setLookupTableName()
     * @uses DXLookupTableData::setLookupTableData()
     * @uses DXLookupTableData::setMessage()
     * @param string $lookupTableName
     * @param \StructType\LookupTableData $lookupTableData
     * @param \StructType\MessageEx $message
     */
    public function __construct($lookupTableName = null, \StructType\LookupTableData $lookupTableData = null, \StructType\MessageEx $message = null)
    {
        $this
            ->setLookupTableName($lookupTableName)
            ->setLookupTableData($lookupTableData)
            ->setMessage($message);
    }
    /**
     * Get LookupTableName value
     * @return string|null
     */
    public function getLookupTableName()
    {
        return $this->LookupTableName;
    }
    /**
     * Set LookupTableName value
     * @param string $lookupTableName
     * @return \StructType\DXLookupTableData
     */
    public function setLookupTableName($lookupTableName = null)
    {
        $this->LookupTableName = $lookupTableName;
        return $this;
    }
    /**
     * Get LookupTableData value
     * @return \StructType\LookupTableData|null
     */
    public function getLookupTableData()
    {
        return $this->LookupTableData;
    }
    /**
     * Set LookupTableData value
     * @param \StructType\LookupTableData $lookupTableData
     * @return \StructType\DXLookupTableData
     */
    public function setLookupTableData(\StructType\LookupTableData $lookupTableData = null)
    {
        $this->LookupTableData = $lookupTableData;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\MessageEx $message
     * @return \StructType\DXLookupTableData
     */
    public function setMessage(\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXLookupTableData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
