<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXFileReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция на файл (фрагмент файла)
 * - type: tns:DXFileReceipt
 * @subpackage Structs
 */
class DXFileReceipt extends DXBlock
{
    /**
     * The FileBlockInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о фрагменте файла
     * @var \StructType\FileBlockInfo
     */
    public $FileBlockInfo;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки файла
     * @var string
     */
    public $Status;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке
     * - minOccurs: 0
     * @var \StructType\MessageEx
     */
    public $Message;
    /**
     * Constructor method for DXFileReceipt
     * @uses DXFileReceipt::setFileBlockInfo()
     * @uses DXFileReceipt::setStatus()
     * @uses DXFileReceipt::setMessage()
     * @param \StructType\FileBlockInfo $fileBlockInfo
     * @param string $status
     * @param \StructType\MessageEx $message
     */
    public function __construct(\StructType\FileBlockInfo $fileBlockInfo = null, $status = null, \StructType\MessageEx $message = null)
    {
        $this
            ->setFileBlockInfo($fileBlockInfo)
            ->setStatus($status)
            ->setMessage($message);
    }
    /**
     * Get FileBlockInfo value
     * @return \StructType\FileBlockInfo|null
     */
    public function getFileBlockInfo()
    {
        return $this->FileBlockInfo;
    }
    /**
     * Set FileBlockInfo value
     * @param \StructType\FileBlockInfo $fileBlockInfo
     * @return \StructType\DXFileReceipt
     */
    public function setFileBlockInfo(\StructType\FileBlockInfo $fileBlockInfo = null)
    {
        $this->FileBlockInfo = $fileBlockInfo;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProcessResult::valueIsValid()
     * @uses \EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DXFileReceipt
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\MessageEx $message
     * @return \StructType\DXFileReceipt
     */
    public function setMessage(\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXFileReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
