<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXEnvBlock StructType
 * @subpackage Structs
 */
class DXEnvBlock extends DXBlock
{
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The doc_type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа отправителя документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $doc_type;
    /**
     * Constructor method for DXEnvBlock
     * @uses DXEnvBlock::setEnv_id()
     * @uses DXEnvBlock::setDocNumber()
     * @uses DXEnvBlock::setDocDate()
     * @uses DXEnvBlock::setDoc_id()
     * @uses DXEnvBlock::setDoc_type()
     * @param string $env_id
     * @param string $docNumber
     * @param string $docDate
     * @param string $doc_id
     * @param string $doc_type
     */
    public function __construct($env_id = null, $docNumber = null, $docDate = null, $doc_id = null, $doc_type = null)
    {
        $this
            ->setEnv_id($env_id)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDoc_id($doc_id)
            ->setDoc_type($doc_type);
    }
    /**
     * Get env_id value
     * @return string
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \StructType\DXEnvBlock
     */
    public function setEnv_id($env_id = null)
    {
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DXEnvBlock
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DXEnvBlock
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\DXEnvBlock
     */
    public function setDoc_id($doc_id = null)
    {
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get doc_type value
     * @return string|null
     */
    public function getDoc_type()
    {
        return $this->doc_type;
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \StructType\DXEnvBlock
     */
    public function setDoc_type($doc_type = null)
    {
        $this->doc_type = $doc_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXEnvBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
