<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXControl StructType
 * Meta informations extracted from the WSDL
 * - documentation: Управляющий блок протокола
 * - type: tns:DXControl
 * @subpackage Structs
 */
class DXControl extends DXBlock
{
    /**
     * The Pack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pack
     */
    public $Pack;
    /**
     * The File
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\File
     */
    public $File;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $Document;
    /**
     * Constructor method for DXControl
     * @uses DXControl::setPack()
     * @uses DXControl::setFile()
     * @uses DXControl::setDocument()
     * @param \StructType\Pack $pack
     * @param \StructType\File $file
     * @param \StructType\Document $document
     */
    public function __construct(\StructType\Pack $pack = null, \StructType\File $file = null, \StructType\Document $document = null)
    {
        $this
            ->setPack($pack)
            ->setFile($file)
            ->setDocument($document);
    }
    /**
     * Get Pack value
     * @return \StructType\Pack|null
     */
    public function getPack()
    {
        return $this->Pack;
    }
    /**
     * Set Pack value
     * @param \StructType\Pack $pack
     * @return \StructType\DXControl
     */
    public function setPack(\StructType\Pack $pack = null)
    {
        $this->Pack = $pack;
        return $this;
    }
    /**
     * Get File value
     * @return \StructType\File|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param \StructType\File $file
     * @return \StructType\DXControl
     */
    public function setFile(\StructType\File $file = null)
    {
        $this->File = $file;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\Document $document
     * @return \StructType\DXControl
     */
    public function setDocument(\StructType\Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
