<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXBox StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение веб-сервиса | Управляющий блок протокола | Пакет документов | Квитанция пакета документов | Запрос фрагмента файла |
 * Фрагмент файла | Квитанция файла | Запрос справочников | Данные справочников | Запрос на передачу документа веб-сервису | Запрос
 * результата обработки документа | Уведомление документа | Результат обращения к документу | Контрольный запрос | Контрольный ответ
 * - type: dx:DXBox
 * @subpackage Structs
 */
class DXBox extends AbstractStructBase
{
    /**
     * The DXControl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DXControl
     * @var \StructType\DXControl
     */
    public $DXControl;
    /**
     * The DXPack
     * Meta informations extracted from the WSDL
     * - ref: tns:DXPack
     * @var \StructType\DXPack
     */
    public $DXPack;
    /**
     * The DXReceipt
     * Meta informations extracted from the WSDL
     * - ref: tns:DXReceipt
     * @var \StructType\DXReceipt
     */
    public $DXReceipt;
    /**
     * The DXFileRequest
     * Meta informations extracted from the WSDL
     * - ref: tns:DXFileRequest
     * @var \StructType\DXFileRequest
     */
    public $DXFileRequest;
    /**
     * The DXFileData
     * Meta informations extracted from the WSDL
     * - ref: tns:DXFileData
     * @var \StructType\DXFileData
     */
    public $DXFileData;
    /**
     * The DXFileReceipt
     * Meta informations extracted from the WSDL
     * - ref: tns:DXFileReceipt
     * @var \StructType\DXFileReceipt
     */
    public $DXFileReceipt;
    /**
     * The DXLookupTableRequest
     * Meta informations extracted from the WSDL
     * - ref: tns:DXLookupTableRequest
     * @var \StructType\DXLookupTableRequest
     */
    public $DXLookupTableRequest;
    /**
     * The DXLookupTableData
     * Meta informations extracted from the WSDL
     * - ref: tns:DXLookupTableData
     * @var \StructType\DXLookupTableData
     */
    public $DXLookupTableData;
    /**
     * The DXPutDocument
     * Meta informations extracted from the WSDL
     * - ref: tns:DXPutDocument
     * @var \StructType\DXPutDocument
     */
    public $DXPutDocument;
    /**
     * The DXGetDocumentResult
     * Meta informations extracted from the WSDL
     * - ref: tns:DXGetDocumentResult
     * @var \StructType\DXGetDocumentResult
     */
    public $DXGetDocumentResult;
    /**
     * The DXNotifyDocument
     * Meta informations extracted from the WSDL
     * - ref: tns:DXNotifyDocument
     * @var \StructType\DXNotifyDocument
     */
    public $DXNotifyDocument;
    /**
     * The DXDocumentResult
     * Meta informations extracted from the WSDL
     * - ref: tns:DXDocumentResult
     * @var \StructType\DXDocumentResult
     */
    public $DXDocumentResult;
    /**
     * The DXSysInfoRequest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DXSysInfoRequest
     * @var \StructType\DXSysInfoRequest
     */
    public $DXSysInfoRequest;
    /**
     * The DXSystemInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DXSystemInfo
     * @var \StructType\DXSystemInfo
     */
    public $DXSystemInfo;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * Constructor method for DXBox
     * @uses DXBox::setDXControl()
     * @uses DXBox::setDXPack()
     * @uses DXBox::setDXReceipt()
     * @uses DXBox::setDXFileRequest()
     * @uses DXBox::setDXFileData()
     * @uses DXBox::setDXFileReceipt()
     * @uses DXBox::setDXLookupTableRequest()
     * @uses DXBox::setDXLookupTableData()
     * @uses DXBox::setDXPutDocument()
     * @uses DXBox::setDXGetDocumentResult()
     * @uses DXBox::setDXNotifyDocument()
     * @uses DXBox::setDXDocumentResult()
     * @uses DXBox::setDXSysInfoRequest()
     * @uses DXBox::setDXSystemInfo()
     * @uses DXBox::setSignature()
     * @param \StructType\DXControl $dXControl
     * @param \StructType\DXPack $dXPack
     * @param \StructType\DXReceipt $dXReceipt
     * @param \StructType\DXFileRequest $dXFileRequest
     * @param \StructType\DXFileData $dXFileData
     * @param \StructType\DXFileReceipt $dXFileReceipt
     * @param \StructType\DXLookupTableRequest $dXLookupTableRequest
     * @param \StructType\DXLookupTableData $dXLookupTableData
     * @param \StructType\DXPutDocument $dXPutDocument
     * @param \StructType\DXGetDocumentResult $dXGetDocumentResult
     * @param \StructType\DXNotifyDocument $dXNotifyDocument
     * @param \StructType\DXDocumentResult $dXDocumentResult
     * @param \StructType\DXSysInfoRequest $dXSysInfoRequest
     * @param \StructType\DXSystemInfo $dXSystemInfo
     * @param \StructType\SignatureType $signature
     */
    public function __construct(\StructType\DXControl $dXControl = null, \StructType\DXPack $dXPack = null, \StructType\DXReceipt $dXReceipt = null, \StructType\DXFileRequest $dXFileRequest = null, \StructType\DXFileData $dXFileData = null, \StructType\DXFileReceipt $dXFileReceipt = null, \StructType\DXLookupTableRequest $dXLookupTableRequest = null, \StructType\DXLookupTableData $dXLookupTableData = null, \StructType\DXPutDocument $dXPutDocument = null, \StructType\DXGetDocumentResult $dXGetDocumentResult = null, \StructType\DXNotifyDocument $dXNotifyDocument = null, \StructType\DXDocumentResult $dXDocumentResult = null, \StructType\DXSysInfoRequest $dXSysInfoRequest = null, \StructType\DXSystemInfo $dXSystemInfo = null, \StructType\SignatureType $signature = null)
    {
        $this
            ->setDXControl($dXControl)
            ->setDXPack($dXPack)
            ->setDXReceipt($dXReceipt)
            ->setDXFileRequest($dXFileRequest)
            ->setDXFileData($dXFileData)
            ->setDXFileReceipt($dXFileReceipt)
            ->setDXLookupTableRequest($dXLookupTableRequest)
            ->setDXLookupTableData($dXLookupTableData)
            ->setDXPutDocument($dXPutDocument)
            ->setDXGetDocumentResult($dXGetDocumentResult)
            ->setDXNotifyDocument($dXNotifyDocument)
            ->setDXDocumentResult($dXDocumentResult)
            ->setDXSysInfoRequest($dXSysInfoRequest)
            ->setDXSystemInfo($dXSystemInfo)
            ->setSignature($signature);
    }
    /**
     * Get DXControl value
     * @return \StructType\DXControl|null
     */
    public function getDXControl()
    {
        return $this->DXControl;
    }
    /**
     * Set DXControl value
     * @param \StructType\DXControl $dXControl
     * @return \StructType\DXBox
     */
    public function setDXControl(\StructType\DXControl $dXControl = null)
    {
        $this->DXControl = $dXControl;
        return $this;
    }
    /**
     * Get DXPack value
     * @return \StructType\DXPack|null
     */
    public function getDXPack()
    {
        return $this->DXPack;
    }
    /**
     * Set DXPack value
     * @param \StructType\DXPack $dXPack
     * @return \StructType\DXBox
     */
    public function setDXPack(\StructType\DXPack $dXPack = null)
    {
        $this->DXPack = $dXPack;
        return $this;
    }
    /**
     * Get DXReceipt value
     * @return \StructType\DXReceipt|null
     */
    public function getDXReceipt()
    {
        return $this->DXReceipt;
    }
    /**
     * Set DXReceipt value
     * @param \StructType\DXReceipt $dXReceipt
     * @return \StructType\DXBox
     */
    public function setDXReceipt(\StructType\DXReceipt $dXReceipt = null)
    {
        $this->DXReceipt = $dXReceipt;
        return $this;
    }
    /**
     * Get DXFileRequest value
     * @return \StructType\DXFileRequest|null
     */
    public function getDXFileRequest()
    {
        return $this->DXFileRequest;
    }
    /**
     * Set DXFileRequest value
     * @param \StructType\DXFileRequest $dXFileRequest
     * @return \StructType\DXBox
     */
    public function setDXFileRequest(\StructType\DXFileRequest $dXFileRequest = null)
    {
        $this->DXFileRequest = $dXFileRequest;
        return $this;
    }
    /**
     * Get DXFileData value
     * @return \StructType\DXFileData|null
     */
    public function getDXFileData()
    {
        return $this->DXFileData;
    }
    /**
     * Set DXFileData value
     * @param \StructType\DXFileData $dXFileData
     * @return \StructType\DXBox
     */
    public function setDXFileData(\StructType\DXFileData $dXFileData = null)
    {
        $this->DXFileData = $dXFileData;
        return $this;
    }
    /**
     * Get DXFileReceipt value
     * @return \StructType\DXFileReceipt|null
     */
    public function getDXFileReceipt()
    {
        return $this->DXFileReceipt;
    }
    /**
     * Set DXFileReceipt value
     * @param \StructType\DXFileReceipt $dXFileReceipt
     * @return \StructType\DXBox
     */
    public function setDXFileReceipt(\StructType\DXFileReceipt $dXFileReceipt = null)
    {
        $this->DXFileReceipt = $dXFileReceipt;
        return $this;
    }
    /**
     * Get DXLookupTableRequest value
     * @return \StructType\DXLookupTableRequest|null
     */
    public function getDXLookupTableRequest()
    {
        return $this->DXLookupTableRequest;
    }
    /**
     * Set DXLookupTableRequest value
     * @param \StructType\DXLookupTableRequest $dXLookupTableRequest
     * @return \StructType\DXBox
     */
    public function setDXLookupTableRequest(\StructType\DXLookupTableRequest $dXLookupTableRequest = null)
    {
        $this->DXLookupTableRequest = $dXLookupTableRequest;
        return $this;
    }
    /**
     * Get DXLookupTableData value
     * @return \StructType\DXLookupTableData|null
     */
    public function getDXLookupTableData()
    {
        return $this->DXLookupTableData;
    }
    /**
     * Set DXLookupTableData value
     * @param \StructType\DXLookupTableData $dXLookupTableData
     * @return \StructType\DXBox
     */
    public function setDXLookupTableData(\StructType\DXLookupTableData $dXLookupTableData = null)
    {
        $this->DXLookupTableData = $dXLookupTableData;
        return $this;
    }
    /**
     * Get DXPutDocument value
     * @return \StructType\DXPutDocument|null
     */
    public function getDXPutDocument()
    {
        return $this->DXPutDocument;
    }
    /**
     * Set DXPutDocument value
     * @param \StructType\DXPutDocument $dXPutDocument
     * @return \StructType\DXBox
     */
    public function setDXPutDocument(\StructType\DXPutDocument $dXPutDocument = null)
    {
        $this->DXPutDocument = $dXPutDocument;
        return $this;
    }
    /**
     * Get DXGetDocumentResult value
     * @return \StructType\DXGetDocumentResult|null
     */
    public function getDXGetDocumentResult()
    {
        return $this->DXGetDocumentResult;
    }
    /**
     * Set DXGetDocumentResult value
     * @param \StructType\DXGetDocumentResult $dXGetDocumentResult
     * @return \StructType\DXBox
     */
    public function setDXGetDocumentResult(\StructType\DXGetDocumentResult $dXGetDocumentResult = null)
    {
        $this->DXGetDocumentResult = $dXGetDocumentResult;
        return $this;
    }
    /**
     * Get DXNotifyDocument value
     * @return \StructType\DXNotifyDocument|null
     */
    public function getDXNotifyDocument()
    {
        return $this->DXNotifyDocument;
    }
    /**
     * Set DXNotifyDocument value
     * @param \StructType\DXNotifyDocument $dXNotifyDocument
     * @return \StructType\DXBox
     */
    public function setDXNotifyDocument(\StructType\DXNotifyDocument $dXNotifyDocument = null)
    {
        $this->DXNotifyDocument = $dXNotifyDocument;
        return $this;
    }
    /**
     * Get DXDocumentResult value
     * @return \StructType\DXDocumentResult|null
     */
    public function getDXDocumentResult()
    {
        return $this->DXDocumentResult;
    }
    /**
     * Set DXDocumentResult value
     * @param \StructType\DXDocumentResult $dXDocumentResult
     * @return \StructType\DXBox
     */
    public function setDXDocumentResult(\StructType\DXDocumentResult $dXDocumentResult = null)
    {
        $this->DXDocumentResult = $dXDocumentResult;
        return $this;
    }
    /**
     * Get DXSysInfoRequest value
     * @return \StructType\DXSysInfoRequest|null
     */
    public function getDXSysInfoRequest()
    {
        return $this->DXSysInfoRequest;
    }
    /**
     * Set DXSysInfoRequest value
     * @param \StructType\DXSysInfoRequest $dXSysInfoRequest
     * @return \StructType\DXBox
     */
    public function setDXSysInfoRequest(\StructType\DXSysInfoRequest $dXSysInfoRequest = null)
    {
        $this->DXSysInfoRequest = $dXSysInfoRequest;
        return $this;
    }
    /**
     * Get DXSystemInfo value
     * @return \StructType\DXSystemInfo|null
     */
    public function getDXSystemInfo()
    {
        return $this->DXSystemInfo;
    }
    /**
     * Set DXSystemInfo value
     * @param \StructType\DXSystemInfo $dXSystemInfo
     * @return \StructType\DXBox
     */
    public function setDXSystemInfo(\StructType\DXSystemInfo $dXSystemInfo = null)
    {
        $this->DXSystemInfo = $dXSystemInfo;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\DXBox
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXBox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
