<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXBlock StructType
 * Meta informations extracted from the WSDL
 * - documentation: Служебный блок
 * @subpackage Structs
 */
abstract class DXBlock extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор блока | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The time_sent
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время включения блока в корневое сообщение протокола | Дата и время | Дата и время
     * - use: required
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_sent;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Адреса отправителя и получателя блока. При обмене данными через СМЭВ без использования подразделений может не заполняться
     * - minOccurs: 0
     * @var \StructType\Direction
     */
    public $Direction;
    /**
     * The session_id
     * Meta informations extracted from the WSDL
     * - documentation: Номер сессии | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $session_id;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - documentation: Последовательный номер сообщения в сессии | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $sequence;
    /**
     * The reply_to_type
     * Meta informations extracted from the WSDL
     * - documentation: Тип блока, на который данный блок является ответом
     * @var string
     */
    public $reply_to_type;
    /**
     * The reply_to
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор блока, на который данный блок является ответом | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $reply_to;
    /**
     * Constructor method for DXBlock
     * @uses DXBlock::setId()
     * @uses DXBlock::setTime_sent()
     * @uses DXBlock::setDirection()
     * @uses DXBlock::setSession_id()
     * @uses DXBlock::setSequence()
     * @uses DXBlock::setReply_to_type()
     * @uses DXBlock::setReply_to()
     * @param string $id
     * @param string $time_sent
     * @param \StructType\Direction $direction
     * @param string $session_id
     * @param int $sequence
     * @param string $reply_to_type
     * @param string $reply_to
     */
    public function __construct($id = null, $time_sent = null, \StructType\Direction $direction = null, $session_id = null, $sequence = null, $reply_to_type = null, $reply_to = null)
    {
        $this
            ->setId($id)
            ->setTime_sent($time_sent)
            ->setDirection($direction)
            ->setSession_id($session_id)
            ->setSequence($sequence)
            ->setReply_to_type($reply_to_type)
            ->setReply_to($reply_to);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DXBlock
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get time_sent value
     * @return string
     */
    public function getTime_sent()
    {
        return $this->time_sent;
    }
    /**
     * Set time_sent value
     * @param string $time_sent
     * @return \StructType\DXBlock
     */
    public function setTime_sent($time_sent = null)
    {
        $this->time_sent = $time_sent;
        return $this;
    }
    /**
     * Get Direction value
     * @return \StructType\Direction|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param \StructType\Direction $direction
     * @return \StructType\DXBlock
     */
    public function setDirection(\StructType\Direction $direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get session_id value
     * @return string|null
     */
    public function getSession_id()
    {
        return $this->session_id;
    }
    /**
     * Set session_id value
     * @param string $session_id
     * @return \StructType\DXBlock
     */
    public function setSession_id($session_id = null)
    {
        $this->session_id = $session_id;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\DXBlock
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get reply_to_type value
     * @return string|null
     */
    public function getReply_to_type()
    {
        return $this->reply_to_type;
    }
    /**
     * Set reply_to_type value
     * @uses \EnumType\BlockType::valueIsValid()
     * @uses \EnumType\BlockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reply_to_type
     * @return \StructType\DXBlock
     */
    public function setReply_to_type($reply_to_type = null)
    {
        $this->reply_to_type = $reply_to_type;
        return $this;
    }
    /**
     * Get reply_to value
     * @return string|null
     */
    public function getReply_to()
    {
        return $this->reply_to;
    }
    /**
     * Set reply_to value
     * @param string $reply_to
     * @return \StructType\DXBlock
     */
    public function setReply_to($reply_to = null)
    {
        $this->reply_to = $reply_to;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
