<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Валюты
 * @subpackage Structs
 */
class CurrencyProperty extends AbstractStructBase
{
    /**
     * The codeNum
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты цифровой | Валюта | Код валюты по общероссийскому классификатору валют. В случае отсутствия значения кода в
     * общероссийском классификаторе валют - используется значение из Классификатора клиринговых валют.
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $codeNum;
    /**
     * The codeAlpha
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты буквенный | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $codeAlpha;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование валюты | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for CurrencyProperty
     * @uses CurrencyProperty::setCodeNum()
     * @uses CurrencyProperty::setCodeAlpha()
     * @uses CurrencyProperty::setName()
     * @param string $codeNum
     * @param string $codeAlpha
     * @param string $name
     */
    public function __construct($codeNum = null, $codeAlpha = null, $name = null)
    {
        $this
            ->setCodeNum($codeNum)
            ->setCodeAlpha($codeAlpha)
            ->setName($name);
    }
    /**
     * Get codeNum value
     * @return string|null
     */
    public function getCodeNum()
    {
        return $this->codeNum;
    }
    /**
     * Set codeNum value
     * @param string $codeNum
     * @return \StructType\CurrencyProperty
     */
    public function setCodeNum($codeNum = null)
    {
        $this->codeNum = $codeNum;
        return $this;
    }
    /**
     * Get codeAlpha value
     * @return string|null
     */
    public function getCodeAlpha()
    {
        return $this->codeAlpha;
    }
    /**
     * Set codeAlpha value
     * @param string $codeAlpha
     * @return \StructType\CurrencyProperty
     */
    public function setCodeAlpha($codeAlpha = null)
    {
        $this->codeAlpha = $codeAlpha;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CurrencyProperty
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
