<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об общем и переданном количестве сведений
 * @subpackage Structs
 */
class CountDatumType extends InformationType
{
    /**
     * The itemKindData
     * Meta informations extracted from the WSDL
     * - documentation: Вид сведений | Вид сведений | NSI_MVV_KindData
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $itemKindData;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - documentation: Общее количество сведений | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $total;
    /**
     * The include
     * Meta informations extracted from the WSDL
     * - documentation: Переданное количество сведений | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $include;
    /**
     * The max
     * Meta informations extracted from the WSDL
     * - documentation: Ограничение | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $max;
    /**
     * Constructor method for CountDatumType
     * @uses CountDatumType::setItemKindData()
     * @uses CountDatumType::setTotal()
     * @uses CountDatumType::setInclude()
     * @uses CountDatumType::setMax()
     * @param string $itemKindData
     * @param int $total
     * @param int $include
     * @param int $max
     */
    public function __construct($itemKindData = null, $total = null, $include = null, $max = null)
    {
        $this
            ->setItemKindData($itemKindData)
            ->setTotal($total)
            ->setInclude($include)
            ->setMax($max);
    }
    /**
     * Get itemKindData value
     * @return string|null
     */
    public function getItemKindData()
    {
        return $this->itemKindData;
    }
    /**
     * Set itemKindData value
     * @param string $itemKindData
     * @return \StructType\CountDatumType
     */
    public function setItemKindData($itemKindData = null)
    {
        $this->itemKindData = $itemKindData;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\CountDatumType
     */
    public function setTotal($total = null)
    {
        $this->total = $total;
        return $this;
    }
    /**
     * Get include value
     * @return int|null
     */
    public function getInclude()
    {
        return $this->include;
    }
    /**
     * Set include value
     * @param int $include
     * @return \StructType\CountDatumType
     */
    public function setInclude($include = null)
    {
        $this->include = $include;
        return $this;
    }
    /**
     * Get max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->max;
    }
    /**
     * Set max value
     * @param int $max
     * @return \StructType\CountDatumType
     */
    public function setMax($max = null)
    {
        $this->max = $max;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
