<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContragentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных ContragentDatumType «Данные контрагента»
 * @subpackage Structs
 */
class ContragentDatumType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип контрагента | Физ. лицо, юр.лицо, инд. предприниматель
     * @var string
     */
    public $type;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование контрагента | ФИО контрагента-физического лица или наименование организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The FIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО контрагента | Обязательно для физического лица или ИП.
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $FIO;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН контрагента | Обязательно для юридического лица | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $INN;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС физического лица | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * The OGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОРГН контрагента | Обязательно для юридического лица или ИП | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $OGRN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Обязательно для юридического лица | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения контрагента | Заполняется для физического лица при наличии данных о дате рождения. В противном случае
     * заполняется только поле «Год рождения контрагента» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения контрагента | Обязательно для физического лица | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $birthYear;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения контрагента | Место рождения контрагента-физического лица | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Серия и номер документа (паспорта и пр.) | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $documentNumber;
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа, удостоверяющего личность | Код типа документа, удостоверяющего личность
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $documentType;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес контрагента
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $address;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $telephoneNumber;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * The postName
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Должность физического лица — представителя организации | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $postName;
    /**
     * Constructor method for ContragentDatumType
     * @uses ContragentDatumType::setType()
     * @uses ContragentDatumType::setName()
     * @uses ContragentDatumType::setFIO()
     * @uses ContragentDatumType::setINN()
     * @uses ContragentDatumType::setSNILS()
     * @uses ContragentDatumType::setOGRN()
     * @uses ContragentDatumType::setKPP()
     * @uses ContragentDatumType::setBirthDate()
     * @uses ContragentDatumType::setBirthYear()
     * @uses ContragentDatumType::setBirthPlace()
     * @uses ContragentDatumType::setDocumentNumber()
     * @uses ContragentDatumType::setDocumentType()
     * @uses ContragentDatumType::setAddress()
     * @uses ContragentDatumType::setTelephoneNumber()
     * @uses ContragentDatumType::setEmail()
     * @uses ContragentDatumType::setPostName()
     * @param string $type
     * @param string $name
     * @param \StructType\FioType $fIO
     * @param string $iNN
     * @param string $sNILS
     * @param string $oGRN
     * @param string $kPP
     * @param string $birthDate
     * @param string $birthYear
     * @param string $birthPlace
     * @param string $documentNumber
     * @param string $documentType
     * @param \StructType\AddressType $address
     * @param string $telephoneNumber
     * @param string $email
     * @param string $postName
     */
    public function __construct($type = null, $name = null, \StructType\FioType $fIO = null, $iNN = null, $sNILS = null, $oGRN = null, $kPP = null, $birthDate = null, $birthYear = null, $birthPlace = null, $documentNumber = null, $documentType = null, \StructType\AddressType $address = null, $telephoneNumber = null, $email = null, $postName = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setFIO($fIO)
            ->setINN($iNN)
            ->setSNILS($sNILS)
            ->setOGRN($oGRN)
            ->setKPP($kPP)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setBirthPlace($birthPlace)
            ->setDocumentNumber($documentNumber)
            ->setDocumentType($documentType)
            ->setAddress($address)
            ->setTelephoneNumber($telephoneNumber)
            ->setEmail($email)
            ->setPostName($postName);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ContragentDatumType
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ContragentDatumType
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get FIO value
     * @return \StructType\FioType|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param \StructType\FioType $fIO
     * @return \StructType\ContragentDatumType
     */
    public function setFIO(\StructType\FioType $fIO = null)
    {
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\ContragentDatumType
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \StructType\ContragentDatumType
     */
    public function setSNILS($sNILS = null)
    {
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Get OGRN value
     * @return string|null
     */
    public function getOGRN()
    {
        return $this->OGRN;
    }
    /**
     * Set OGRN value
     * @param string $oGRN
     * @return \StructType\ContragentDatumType
     */
    public function setOGRN($oGRN = null)
    {
        $this->OGRN = $oGRN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \StructType\ContragentDatumType
     */
    public function setKPP($kPP = null)
    {
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\ContragentDatumType
     */
    public function setBirthDate($birthDate = null)
    {
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->birthYear;
    }
    /**
     * Set birthYear value
     * @param string $birthYear
     * @return \StructType\ContragentDatumType
     */
    public function setBirthYear($birthYear = null)
    {
        $this->birthYear = $birthYear;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \StructType\ContragentDatumType
     */
    public function setBirthPlace($birthPlace = null)
    {
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\ContragentDatumType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \StructType\ContragentDatumType
     */
    public function setDocumentType($documentType = null)
    {
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\AddressType $address
     * @return \StructType\ContragentDatumType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\ContragentDatumType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ContragentDatumType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get postName value
     * @return string|null
     */
    public function getPostName()
    {
        return $this->postName;
    }
    /**
     * Set postName value
     * @param string $postName
     * @return \StructType\ContragentDatumType
     */
    public function setPostName($postName = null)
    {
        $this->postName = $postName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContragentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
