<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyExtDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расширенные сведения о юридическом лице
 * @subpackage Structs
 */
class CompanyExtDatumType extends CompanyDatumType
{
    /**
     * The documentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа ФНС | Идентификатор документа в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 9
     * @var int
     */
    public $documentId;
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах экономической деятельности
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OkvedDetailType[]
     */
    public $OKVED;
    /**
     * The statusId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $statusId;
    /**
     * The nameActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата внесения записи со сведениями о наименовании в ЕГРЮЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $nameActDate;
    /**
     * The shortName
     * Meta informations extracted from the WSDL
     * - documentation: Сокращенное наименование юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $shortName;
    /**
     * The brandName
     * Meta informations extracted from the WSDL
     * - documentation: Фирменное наименование юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $brandName;
    /**
     * The nationalName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование на национальном языке | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $nationalName;
    /**
     * The nationalLangId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор национального языка | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $nationalLangId;
    /**
     * The nationalLangCode
     * Meta informations extracted from the WSDL
     * - documentation: Код национального языка | Код языка | По общероссийскому классификатору ОКИН
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $nationalLangCode;
    /**
     * The nationalLangName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование национального языка | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $nationalLangName;
    /**
     * The foreignName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование на иностранном языке | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foreignName;
    /**
     * The foreignLangId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор иностранного языка | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $foreignLangId;
    /**
     * The foreignLangCode
     * Meta informations extracted from the WSDL
     * - documentation: Код иностранного языка | Код языка | По общероссийскому классификатору ОКИН
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $foreignLangCode;
    /**
     * The foreignLandName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование иностранного языка | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foreignLandName;
    /**
     * The capitalActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата сведений о капитале в ЕГРЮЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $capitalActDate;
    /**
     * The capitalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма капитала | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $capitalAmount;
    /**
     * The capitalKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида капитал | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $capitalKindId;
    /**
     * The capitalKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида капитала | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $capitalKindName;
    /**
     * The foundRegNum
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН или регистрационный номер для юридических лиц, созданных до 01.07.2002 | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foundRegNum;
    /**
     * The foundRegKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида регистрации сведений об образовании юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $foundRegKindId;
    /**
     * The foundRegKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида регистрации сведений об образовании юридического лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foundRegKindName;
    /**
     * The closureRegNum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер прекращения деятельности | Строка длиной от 1 до 13 символов
     * - minOccurs: 0
     * - maxLength: 13
     * - minLength: 1
     * @var string
     */
    public $closureRegNum;
    /**
     * The closureDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации прекращения деятельности | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $closureDate;
    /**
     * The closureRegKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор способа прекращения деятельности (вид регистрации) | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $closureRegKindId;
    /**
     * The closureRegKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование способа прекращения деятельности (вид регистрации) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $closureRegKindName;
    /**
     * The founderCompanyCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — российских юридических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderCompanyCount;
    /**
     * The founderForeignCompanyCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — иностранных юридических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderForeignCompanyCount;
    /**
     * The founderPersonCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — физических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderPersonCount;
    /**
     * Constructor method for CompanyExtDatumType
     * @uses CompanyExtDatumType::setDocumentId()
     * @uses CompanyExtDatumType::setOKVED()
     * @uses CompanyExtDatumType::setStatusId()
     * @uses CompanyExtDatumType::setNameActDate()
     * @uses CompanyExtDatumType::setShortName()
     * @uses CompanyExtDatumType::setBrandName()
     * @uses CompanyExtDatumType::setNationalName()
     * @uses CompanyExtDatumType::setNationalLangId()
     * @uses CompanyExtDatumType::setNationalLangCode()
     * @uses CompanyExtDatumType::setNationalLangName()
     * @uses CompanyExtDatumType::setForeignName()
     * @uses CompanyExtDatumType::setForeignLangId()
     * @uses CompanyExtDatumType::setForeignLangCode()
     * @uses CompanyExtDatumType::setForeignLandName()
     * @uses CompanyExtDatumType::setCapitalActDate()
     * @uses CompanyExtDatumType::setCapitalAmount()
     * @uses CompanyExtDatumType::setCapitalKindId()
     * @uses CompanyExtDatumType::setCapitalKindName()
     * @uses CompanyExtDatumType::setFoundRegNum()
     * @uses CompanyExtDatumType::setFoundRegKindId()
     * @uses CompanyExtDatumType::setFoundRegKindName()
     * @uses CompanyExtDatumType::setClosureRegNum()
     * @uses CompanyExtDatumType::setClosureDate()
     * @uses CompanyExtDatumType::setClosureRegKindId()
     * @uses CompanyExtDatumType::setClosureRegKindName()
     * @uses CompanyExtDatumType::setFounderCompanyCount()
     * @uses CompanyExtDatumType::setFounderForeignCompanyCount()
     * @uses CompanyExtDatumType::setFounderPersonCount()
     * @param int $documentId
     * @param \StructType\OkvedDetailType[] $oKVED
     * @param int $statusId
     * @param string $nameActDate
     * @param string $shortName
     * @param string $brandName
     * @param string $nationalName
     * @param int $nationalLangId
     * @param string $nationalLangCode
     * @param string $nationalLangName
     * @param string $foreignName
     * @param int $foreignLangId
     * @param string $foreignLangCode
     * @param string $foreignLandName
     * @param string $capitalActDate
     * @param float $capitalAmount
     * @param int $capitalKindId
     * @param string $capitalKindName
     * @param string $foundRegNum
     * @param int $foundRegKindId
     * @param string $foundRegKindName
     * @param string $closureRegNum
     * @param string $closureDate
     * @param int $closureRegKindId
     * @param string $closureRegKindName
     * @param int $founderCompanyCount
     * @param int $founderForeignCompanyCount
     * @param int $founderPersonCount
     */
    public function __construct($documentId = null, array $oKVED = array(), $statusId = null, $nameActDate = null, $shortName = null, $brandName = null, $nationalName = null, $nationalLangId = null, $nationalLangCode = null, $nationalLangName = null, $foreignName = null, $foreignLangId = null, $foreignLangCode = null, $foreignLandName = null, $capitalActDate = null, $capitalAmount = null, $capitalKindId = null, $capitalKindName = null, $foundRegNum = null, $foundRegKindId = null, $foundRegKindName = null, $closureRegNum = null, $closureDate = null, $closureRegKindId = null, $closureRegKindName = null, $founderCompanyCount = null, $founderForeignCompanyCount = null, $founderPersonCount = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setOKVED($oKVED)
            ->setStatusId($statusId)
            ->setNameActDate($nameActDate)
            ->setShortName($shortName)
            ->setBrandName($brandName)
            ->setNationalName($nationalName)
            ->setNationalLangId($nationalLangId)
            ->setNationalLangCode($nationalLangCode)
            ->setNationalLangName($nationalLangName)
            ->setForeignName($foreignName)
            ->setForeignLangId($foreignLangId)
            ->setForeignLangCode($foreignLangCode)
            ->setForeignLandName($foreignLandName)
            ->setCapitalActDate($capitalActDate)
            ->setCapitalAmount($capitalAmount)
            ->setCapitalKindId($capitalKindId)
            ->setCapitalKindName($capitalKindName)
            ->setFoundRegNum($foundRegNum)
            ->setFoundRegKindId($foundRegKindId)
            ->setFoundRegKindName($foundRegKindName)
            ->setClosureRegNum($closureRegNum)
            ->setClosureDate($closureDate)
            ->setClosureRegKindId($closureRegKindId)
            ->setClosureRegKindName($closureRegKindName)
            ->setFounderCompanyCount($founderCompanyCount)
            ->setFounderForeignCompanyCount($founderForeignCompanyCount)
            ->setFounderPersonCount($founderPersonCount);
    }
    /**
     * Get documentId value
     * @return int|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param int $documentId
     * @return \StructType\CompanyExtDatumType
     */
    public function setDocumentId($documentId = null)
    {
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get OKVED value
     * @return \StructType\OkvedDetailType[]|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @throws \InvalidArgumentException
     * @param \StructType\OkvedDetailType[] $oKVED
     * @return \StructType\CompanyExtDatumType
     */
    public function setOKVED(array $oKVED = array())
    {
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Add item to OKVED value
     * @throws \InvalidArgumentException
     * @param \StructType\OkvedDetailType $item
     * @return \StructType\CompanyExtDatumType
     */
    public function addToOKVED(\StructType\OkvedDetailType $item)
    {
        $this->OKVED[] = $item;
        return $this;
    }
    /**
     * Get statusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \StructType\CompanyExtDatumType
     */
    public function setStatusId($statusId = null)
    {
        $this->statusId = $statusId;
        return $this;
    }
    /**
     * Get nameActDate value
     * @return string|null
     */
    public function getNameActDate()
    {
        return $this->nameActDate;
    }
    /**
     * Set nameActDate value
     * @param string $nameActDate
     * @return \StructType\CompanyExtDatumType
     */
    public function setNameActDate($nameActDate = null)
    {
        $this->nameActDate = $nameActDate;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \StructType\CompanyExtDatumType
     */
    public function setShortName($shortName = null)
    {
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * Get brandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->brandName;
    }
    /**
     * Set brandName value
     * @param string $brandName
     * @return \StructType\CompanyExtDatumType
     */
    public function setBrandName($brandName = null)
    {
        $this->brandName = $brandName;
        return $this;
    }
    /**
     * Get nationalName value
     * @return string|null
     */
    public function getNationalName()
    {
        return $this->nationalName;
    }
    /**
     * Set nationalName value
     * @param string $nationalName
     * @return \StructType\CompanyExtDatumType
     */
    public function setNationalName($nationalName = null)
    {
        $this->nationalName = $nationalName;
        return $this;
    }
    /**
     * Get nationalLangId value
     * @return int|null
     */
    public function getNationalLangId()
    {
        return $this->nationalLangId;
    }
    /**
     * Set nationalLangId value
     * @param int $nationalLangId
     * @return \StructType\CompanyExtDatumType
     */
    public function setNationalLangId($nationalLangId = null)
    {
        $this->nationalLangId = $nationalLangId;
        return $this;
    }
    /**
     * Get nationalLangCode value
     * @return string|null
     */
    public function getNationalLangCode()
    {
        return $this->nationalLangCode;
    }
    /**
     * Set nationalLangCode value
     * @param string $nationalLangCode
     * @return \StructType\CompanyExtDatumType
     */
    public function setNationalLangCode($nationalLangCode = null)
    {
        $this->nationalLangCode = $nationalLangCode;
        return $this;
    }
    /**
     * Get nationalLangName value
     * @return string|null
     */
    public function getNationalLangName()
    {
        return $this->nationalLangName;
    }
    /**
     * Set nationalLangName value
     * @param string $nationalLangName
     * @return \StructType\CompanyExtDatumType
     */
    public function setNationalLangName($nationalLangName = null)
    {
        $this->nationalLangName = $nationalLangName;
        return $this;
    }
    /**
     * Get foreignName value
     * @return string|null
     */
    public function getForeignName()
    {
        return $this->foreignName;
    }
    /**
     * Set foreignName value
     * @param string $foreignName
     * @return \StructType\CompanyExtDatumType
     */
    public function setForeignName($foreignName = null)
    {
        $this->foreignName = $foreignName;
        return $this;
    }
    /**
     * Get foreignLangId value
     * @return int|null
     */
    public function getForeignLangId()
    {
        return $this->foreignLangId;
    }
    /**
     * Set foreignLangId value
     * @param int $foreignLangId
     * @return \StructType\CompanyExtDatumType
     */
    public function setForeignLangId($foreignLangId = null)
    {
        $this->foreignLangId = $foreignLangId;
        return $this;
    }
    /**
     * Get foreignLangCode value
     * @return string|null
     */
    public function getForeignLangCode()
    {
        return $this->foreignLangCode;
    }
    /**
     * Set foreignLangCode value
     * @param string $foreignLangCode
     * @return \StructType\CompanyExtDatumType
     */
    public function setForeignLangCode($foreignLangCode = null)
    {
        $this->foreignLangCode = $foreignLangCode;
        return $this;
    }
    /**
     * Get foreignLandName value
     * @return string|null
     */
    public function getForeignLandName()
    {
        return $this->foreignLandName;
    }
    /**
     * Set foreignLandName value
     * @param string $foreignLandName
     * @return \StructType\CompanyExtDatumType
     */
    public function setForeignLandName($foreignLandName = null)
    {
        $this->foreignLandName = $foreignLandName;
        return $this;
    }
    /**
     * Get capitalActDate value
     * @return string|null
     */
    public function getCapitalActDate()
    {
        return $this->capitalActDate;
    }
    /**
     * Set capitalActDate value
     * @param string $capitalActDate
     * @return \StructType\CompanyExtDatumType
     */
    public function setCapitalActDate($capitalActDate = null)
    {
        $this->capitalActDate = $capitalActDate;
        return $this;
    }
    /**
     * Get capitalAmount value
     * @return float|null
     */
    public function getCapitalAmount()
    {
        return $this->capitalAmount;
    }
    /**
     * Set capitalAmount value
     * @param float $capitalAmount
     * @return \StructType\CompanyExtDatumType
     */
    public function setCapitalAmount($capitalAmount = null)
    {
        $this->capitalAmount = $capitalAmount;
        return $this;
    }
    /**
     * Get capitalKindId value
     * @return int|null
     */
    public function getCapitalKindId()
    {
        return $this->capitalKindId;
    }
    /**
     * Set capitalKindId value
     * @param int $capitalKindId
     * @return \StructType\CompanyExtDatumType
     */
    public function setCapitalKindId($capitalKindId = null)
    {
        $this->capitalKindId = $capitalKindId;
        return $this;
    }
    /**
     * Get capitalKindName value
     * @return string|null
     */
    public function getCapitalKindName()
    {
        return $this->capitalKindName;
    }
    /**
     * Set capitalKindName value
     * @param string $capitalKindName
     * @return \StructType\CompanyExtDatumType
     */
    public function setCapitalKindName($capitalKindName = null)
    {
        $this->capitalKindName = $capitalKindName;
        return $this;
    }
    /**
     * Get foundRegNum value
     * @return string|null
     */
    public function getFoundRegNum()
    {
        return $this->foundRegNum;
    }
    /**
     * Set foundRegNum value
     * @param string $foundRegNum
     * @return \StructType\CompanyExtDatumType
     */
    public function setFoundRegNum($foundRegNum = null)
    {
        $this->foundRegNum = $foundRegNum;
        return $this;
    }
    /**
     * Get foundRegKindId value
     * @return int|null
     */
    public function getFoundRegKindId()
    {
        return $this->foundRegKindId;
    }
    /**
     * Set foundRegKindId value
     * @param int $foundRegKindId
     * @return \StructType\CompanyExtDatumType
     */
    public function setFoundRegKindId($foundRegKindId = null)
    {
        $this->foundRegKindId = $foundRegKindId;
        return $this;
    }
    /**
     * Get foundRegKindName value
     * @return string|null
     */
    public function getFoundRegKindName()
    {
        return $this->foundRegKindName;
    }
    /**
     * Set foundRegKindName value
     * @param string $foundRegKindName
     * @return \StructType\CompanyExtDatumType
     */
    public function setFoundRegKindName($foundRegKindName = null)
    {
        $this->foundRegKindName = $foundRegKindName;
        return $this;
    }
    /**
     * Get closureRegNum value
     * @return string|null
     */
    public function getClosureRegNum()
    {
        return $this->closureRegNum;
    }
    /**
     * Set closureRegNum value
     * @param string $closureRegNum
     * @return \StructType\CompanyExtDatumType
     */
    public function setClosureRegNum($closureRegNum = null)
    {
        $this->closureRegNum = $closureRegNum;
        return $this;
    }
    /**
     * Get closureDate value
     * @return string|null
     */
    public function getClosureDate()
    {
        return $this->closureDate;
    }
    /**
     * Set closureDate value
     * @param string $closureDate
     * @return \StructType\CompanyExtDatumType
     */
    public function setClosureDate($closureDate = null)
    {
        $this->closureDate = $closureDate;
        return $this;
    }
    /**
     * Get closureRegKindId value
     * @return int|null
     */
    public function getClosureRegKindId()
    {
        return $this->closureRegKindId;
    }
    /**
     * Set closureRegKindId value
     * @param int $closureRegKindId
     * @return \StructType\CompanyExtDatumType
     */
    public function setClosureRegKindId($closureRegKindId = null)
    {
        $this->closureRegKindId = $closureRegKindId;
        return $this;
    }
    /**
     * Get closureRegKindName value
     * @return string|null
     */
    public function getClosureRegKindName()
    {
        return $this->closureRegKindName;
    }
    /**
     * Set closureRegKindName value
     * @param string $closureRegKindName
     * @return \StructType\CompanyExtDatumType
     */
    public function setClosureRegKindName($closureRegKindName = null)
    {
        $this->closureRegKindName = $closureRegKindName;
        return $this;
    }
    /**
     * Get founderCompanyCount value
     * @return int|null
     */
    public function getFounderCompanyCount()
    {
        return $this->founderCompanyCount;
    }
    /**
     * Set founderCompanyCount value
     * @param int $founderCompanyCount
     * @return \StructType\CompanyExtDatumType
     */
    public function setFounderCompanyCount($founderCompanyCount = null)
    {
        $this->founderCompanyCount = $founderCompanyCount;
        return $this;
    }
    /**
     * Get founderForeignCompanyCount value
     * @return int|null
     */
    public function getFounderForeignCompanyCount()
    {
        return $this->founderForeignCompanyCount;
    }
    /**
     * Set founderForeignCompanyCount value
     * @param int $founderForeignCompanyCount
     * @return \StructType\CompanyExtDatumType
     */
    public function setFounderForeignCompanyCount($founderForeignCompanyCount = null)
    {
        $this->founderForeignCompanyCount = $founderForeignCompanyCount;
        return $this;
    }
    /**
     * Get founderPersonCount value
     * @return int|null
     */
    public function getFounderPersonCount()
    {
        return $this->founderPersonCount;
    }
    /**
     * Set founderPersonCount value
     * @param int $founderPersonCount
     * @return \StructType\CompanyExtDatumType
     */
    public function setFounderPersonCount($founderPersonCount = null)
    {
        $this->founderPersonCount = $founderPersonCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyExtDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
