<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о юридическом лице
 * @subpackage Structs
 */
class CompanyDatumType extends OrganizationDatumType
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП организации | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The OGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН организации | Основной государственный регистрационный номер (ОГРН)
     * - minOccurs: 0
     * - length: 13
     * - pattern: [0-9]{13}
     * @var string
     */
    public $OGRN;
    /**
     * The OGRNDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата присвоения ОГРН | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OGRNDate;
    /**
     * The KIO
     * Meta informations extracted from the WSDL
     * - documentation: Код иностранной организации | Код иностранной организации
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $KIO;
    /**
     * The statusName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $statusName;
    /**
     * The statusDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия указанного статуса (состояния) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $statusDate;
    /**
     * The numSt
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер учредителя — юридического лица (до 01.07.2002) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $numSt;
    /**
     * The foundDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации образования учредителя — юридического лица | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $foundDate;
    /**
     * The FNSResource
     * Meta informations extracted from the WSDL
     * - documentation: Вид ресурса - источника сведений | Вид ресурса (реестра) ФНС
     * - minOccurs: 0
     * - maxInclusive: 3
     * - minInclusive: 1
     * @var int
     */
    public $FNSResource;
    /**
     * The OPFId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ОПФ | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $OPFId;
    /**
     * The OPFKind
     * Meta informations extracted from the WSDL
     * - documentation: Наименование классификатора: ОКОПФ, КОПФ
     * - minOccurs: 0
     * @var string
     */
    public $OPFKind;
    /**
     * The OPFCode
     * Meta informations extracted from the WSDL
     * - documentation: Код по справочнику ОКОПФ или КОПФ | Код по справочнику ОКОПФ или КОПФ
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $OPFCode;
    /**
     * The OPFName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОПФ | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $OPFName;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * Constructor method for CompanyDatumType
     * @uses CompanyDatumType::setINN()
     * @uses CompanyDatumType::setKPP()
     * @uses CompanyDatumType::setOGRN()
     * @uses CompanyDatumType::setOGRNDate()
     * @uses CompanyDatumType::setKIO()
     * @uses CompanyDatumType::setStatusName()
     * @uses CompanyDatumType::setStatusDate()
     * @uses CompanyDatumType::setNumSt()
     * @uses CompanyDatumType::setFoundDate()
     * @uses CompanyDatumType::setFNSResource()
     * @uses CompanyDatumType::setOPFId()
     * @uses CompanyDatumType::setOPFKind()
     * @uses CompanyDatumType::setOPFCode()
     * @uses CompanyDatumType::setOPFName()
     * @uses CompanyDatumType::setEmail()
     * @param string $iNN
     * @param string $kPP
     * @param string $oGRN
     * @param string $oGRNDate
     * @param string $kIO
     * @param string $statusName
     * @param string $statusDate
     * @param string $numSt
     * @param string $foundDate
     * @param int $fNSResource
     * @param int $oPFId
     * @param string $oPFKind
     * @param string $oPFCode
     * @param string $oPFName
     * @param string $email
     */
    public function __construct($iNN = null, $kPP = null, $oGRN = null, $oGRNDate = null, $kIO = null, $statusName = null, $statusDate = null, $numSt = null, $foundDate = null, $fNSResource = null, $oPFId = null, $oPFKind = null, $oPFCode = null, $oPFName = null, $email = null)
    {
        $this
            ->setINN($iNN)
            ->setKPP($kPP)
            ->setOGRN($oGRN)
            ->setOGRNDate($oGRNDate)
            ->setKIO($kIO)
            ->setStatusName($statusName)
            ->setStatusDate($statusDate)
            ->setNumSt($numSt)
            ->setFoundDate($foundDate)
            ->setFNSResource($fNSResource)
            ->setOPFId($oPFId)
            ->setOPFKind($oPFKind)
            ->setOPFCode($oPFCode)
            ->setOPFName($oPFName)
            ->setEmail($email);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\CompanyDatumType
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \StructType\CompanyDatumType
     */
    public function setKPP($kPP = null)
    {
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get OGRN value
     * @return string|null
     */
    public function getOGRN()
    {
        return $this->OGRN;
    }
    /**
     * Set OGRN value
     * @param string $oGRN
     * @return \StructType\CompanyDatumType
     */
    public function setOGRN($oGRN = null)
    {
        $this->OGRN = $oGRN;
        return $this;
    }
    /**
     * Get OGRNDate value
     * @return string|null
     */
    public function getOGRNDate()
    {
        return $this->OGRNDate;
    }
    /**
     * Set OGRNDate value
     * @param string $oGRNDate
     * @return \StructType\CompanyDatumType
     */
    public function setOGRNDate($oGRNDate = null)
    {
        $this->OGRNDate = $oGRNDate;
        return $this;
    }
    /**
     * Get KIO value
     * @return string|null
     */
    public function getKIO()
    {
        return $this->KIO;
    }
    /**
     * Set KIO value
     * @param string $kIO
     * @return \StructType\CompanyDatumType
     */
    public function setKIO($kIO = null)
    {
        $this->KIO = $kIO;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \StructType\CompanyDatumType
     */
    public function setStatusName($statusName = null)
    {
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \StructType\CompanyDatumType
     */
    public function setStatusDate($statusDate = null)
    {
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get numSt value
     * @return string|null
     */
    public function getNumSt()
    {
        return $this->numSt;
    }
    /**
     * Set numSt value
     * @param string $numSt
     * @return \StructType\CompanyDatumType
     */
    public function setNumSt($numSt = null)
    {
        $this->numSt = $numSt;
        return $this;
    }
    /**
     * Get foundDate value
     * @return string|null
     */
    public function getFoundDate()
    {
        return $this->foundDate;
    }
    /**
     * Set foundDate value
     * @param string $foundDate
     * @return \StructType\CompanyDatumType
     */
    public function setFoundDate($foundDate = null)
    {
        $this->foundDate = $foundDate;
        return $this;
    }
    /**
     * Get FNSResource value
     * @return int|null
     */
    public function getFNSResource()
    {
        return $this->FNSResource;
    }
    /**
     * Set FNSResource value
     * @param int $fNSResource
     * @return \StructType\CompanyDatumType
     */
    public function setFNSResource($fNSResource = null)
    {
        $this->FNSResource = $fNSResource;
        return $this;
    }
    /**
     * Get OPFId value
     * @return int|null
     */
    public function getOPFId()
    {
        return $this->OPFId;
    }
    /**
     * Set OPFId value
     * @param int $oPFId
     * @return \StructType\CompanyDatumType
     */
    public function setOPFId($oPFId = null)
    {
        $this->OPFId = $oPFId;
        return $this;
    }
    /**
     * Get OPFKind value
     * @return string|null
     */
    public function getOPFKind()
    {
        return $this->OPFKind;
    }
    /**
     * Set OPFKind value
     * @uses \EnumType\OPFKindType::valueIsValid()
     * @uses \EnumType\OPFKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $oPFKind
     * @return \StructType\CompanyDatumType
     */
    public function setOPFKind($oPFKind = null)
    {
        $this->OPFKind = $oPFKind;
        return $this;
    }
    /**
     * Get OPFCode value
     * @return string|null
     */
    public function getOPFCode()
    {
        return $this->OPFCode;
    }
    /**
     * Set OPFCode value
     * @param string $oPFCode
     * @return \StructType\CompanyDatumType
     */
    public function setOPFCode($oPFCode = null)
    {
        $this->OPFCode = $oPFCode;
        return $this;
    }
    /**
     * Get OPFName value
     * @return string|null
     */
    public function getOPFName()
    {
        return $this->OPFName;
    }
    /**
     * Set OPFName value
     * @param string $oPFName
     * @return \StructType\CompanyDatumType
     */
    public function setOPFName($oPFName = null)
    {
        $this->OPFName = $oPFName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CompanyDatumType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
