<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyAddressDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Адрес юридического лица
 * @subpackage Structs
 */
class CompanyAddressDatumType extends AddressDataType
{
    /**
     * The organName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, адрес которого является адресом (местом нахождения) юридического лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $organName;
    /**
     * The addressKindId
     * Meta informations extracted from the WSDL
     * - documentation: Вид адреса юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $addressKindId;
    /**
     * The addressKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида адреса юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $addressKindName;
    /**
     * Constructor method for CompanyAddressDatumType
     * @uses CompanyAddressDatumType::setOrganName()
     * @uses CompanyAddressDatumType::setAddressKindId()
     * @uses CompanyAddressDatumType::setAddressKindName()
     * @param string $organName
     * @param int $addressKindId
     * @param string $addressKindName
     */
    public function __construct($organName = null, $addressKindId = null, $addressKindName = null)
    {
        $this
            ->setOrganName($organName)
            ->setAddressKindId($addressKindId)
            ->setAddressKindName($addressKindName);
    }
    /**
     * Get organName value
     * @return string|null
     */
    public function getOrganName()
    {
        return $this->organName;
    }
    /**
     * Set organName value
     * @param string $organName
     * @return \StructType\CompanyAddressDatumType
     */
    public function setOrganName($organName = null)
    {
        $this->organName = $organName;
        return $this;
    }
    /**
     * Get addressKindId value
     * @return int|null
     */
    public function getAddressKindId()
    {
        return $this->addressKindId;
    }
    /**
     * Set addressKindId value
     * @param int $addressKindId
     * @return \StructType\CompanyAddressDatumType
     */
    public function setAddressKindId($addressKindId = null)
    {
        $this->addressKindId = $addressKindId;
        return $this;
    }
    /**
     * Get addressKindName value
     * @return string|null
     */
    public function getAddressKindName()
    {
        return $this->addressKindName;
    }
    /**
     * Set addressKindName value
     * @param string $addressKindName
     * @return \StructType\CompanyAddressDatumType
     */
    public function setAddressKindName($addressKindName = null)
    {
        $this->addressKindName = $addressKindName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyAddressDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
