<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimerIPListResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ClaimerIPListResponseType «Список исполнительных производств по взыскателю» | ЭП
 * @subpackage Structs
 */
class ClaimerIPListResponseType extends AbstractStructBase
{
    /**
     * The responseKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ответа ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $responseKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The IPInformation
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об исполнительных производствах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BriefIPInformationType[]
     */
    public $IPInformation;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ClaimerIPListResponseType
     * @uses ClaimerIPListResponseType::setResponseKey()
     * @uses ClaimerIPListResponseType::setRequestKey()
     * @uses ClaimerIPListResponseType::setIPInformation()
     * @uses ClaimerIPListResponseType::setSignature()
     * @uses ClaimerIPListResponseType::setId()
     * @param int $responseKey
     * @param string $requestKey
     * @param \StructType\BriefIPInformationType[] $iPInformation
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($responseKey = null, $requestKey = null, array $iPInformation = array(), array $signature = array(), $id = null)
    {
        $this
            ->setResponseKey($responseKey)
            ->setRequestKey($requestKey)
            ->setIPInformation($iPInformation)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get responseKey value
     * @return int|null
     */
    public function getResponseKey()
    {
        return $this->responseKey;
    }
    /**
     * Set responseKey value
     * @param int $responseKey
     * @return \StructType\ClaimerIPListResponseType
     */
    public function setResponseKey($responseKey = null)
    {
        $this->responseKey = $responseKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\ClaimerIPListResponseType
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get IPInformation value
     * @return \StructType\BriefIPInformationType[]|null
     */
    public function getIPInformation()
    {
        return $this->IPInformation;
    }
    /**
     * Set IPInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BriefIPInformationType[] $iPInformation
     * @return \StructType\ClaimerIPListResponseType
     */
    public function setIPInformation(array $iPInformation = array())
    {
        $this->IPInformation = $iPInformation;
        return $this;
    }
    /**
     * Add item to IPInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BriefIPInformationType $item
     * @return \StructType\ClaimerIPListResponseType
     */
    public function addToIPInformation(\StructType\BriefIPInformationType $item)
    {
        $this->IPInformation[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ClaimerIPListResponseType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ClaimerIPListResponseType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ClaimerIPListResponseType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClaimerIPListResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
