<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimerIPListRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ClaimerIPListRequestType «Запрос реестра ИП по взыскателю» | ЭП
 * @subpackage Structs
 */
class ClaimerIPListRequestType extends AbstractStructBase
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН взыскателя | ИНН юридического лица
     * - minOccurs: 1
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного документа | Номер документа
     * - minOccurs: 1
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ClaimerIPListRequestType
     * @uses ClaimerIPListRequestType::setINN()
     * @uses ClaimerIPListRequestType::setIDNum()
     * @uses ClaimerIPListRequestType::setRequestKey()
     * @uses ClaimerIPListRequestType::setSignature()
     * @uses ClaimerIPListRequestType::setId()
     * @param string $iNN
     * @param string $iDNum
     * @param string $requestKey
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iNN = null, $iDNum = null, $requestKey = null, array $signature = array(), $id = null)
    {
        $this
            ->setINN($iNN)
            ->setIDNum($iDNum)
            ->setRequestKey($requestKey)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get INN value
     * @return string
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \StructType\ClaimerIPListRequestType
     */
    public function setINN($iNN = null)
    {
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\ClaimerIPListRequestType
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\ClaimerIPListRequestType
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ClaimerIPListRequestType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ClaimerIPListRequestType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ClaimerIPListRequestType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClaimerIPListRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
