<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitizenQuestionsResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Статус вопроса по обращению гражданина, полученного из Администрации Президента
 * - type: tns:CitizenQuestionsResult
 * @subpackage Structs
 */
class CitizenQuestionsResult extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор обращения | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The IsAppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия статуса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsAppStatus;
    /**
     * The TreatmentText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обращения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $TreatmentText;
    /**
     * The IncomingDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата поступления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IncomingDate;
    /**
     * The CitizenQuestionsResData
     * Meta informations extracted from the WSDL
     * - documentation: Данные по вопросам обращений граждан
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CitizenQuestionsResData[]
     */
    public $CitizenQuestionsResData;
    /**
     * Constructor method for CitizenQuestionsResult
     * @uses CitizenQuestionsResult::setInternalKey()
     * @uses CitizenQuestionsResult::setRequestExternalKey()
     * @uses CitizenQuestionsResult::setIsAppStatus()
     * @uses CitizenQuestionsResult::setTreatmentText()
     * @uses CitizenQuestionsResult::setIncomingDate()
     * @uses CitizenQuestionsResult::setCitizenQuestionsResData()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param bool $isAppStatus
     * @param string $treatmentText
     * @param string $incomingDate
     * @param \StructType\CitizenQuestionsResData[] $citizenQuestionsResData
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $isAppStatus = null, $treatmentText = null, $incomingDate = null, array $citizenQuestionsResData = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setIsAppStatus($isAppStatus)
            ->setTreatmentText($treatmentText)
            ->setIncomingDate($incomingDate)
            ->setCitizenQuestionsResData($citizenQuestionsResData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\CitizenQuestionsResult
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\CitizenQuestionsResult
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get IsAppStatus value
     * @return bool|null
     */
    public function getIsAppStatus()
    {
        return $this->IsAppStatus;
    }
    /**
     * Set IsAppStatus value
     * @param bool $isAppStatus
     * @return \StructType\CitizenQuestionsResult
     */
    public function setIsAppStatus($isAppStatus = null)
    {
        $this->IsAppStatus = $isAppStatus;
        return $this;
    }
    /**
     * Get TreatmentText value
     * @return string|null
     */
    public function getTreatmentText()
    {
        return $this->TreatmentText;
    }
    /**
     * Set TreatmentText value
     * @param string $treatmentText
     * @return \StructType\CitizenQuestionsResult
     */
    public function setTreatmentText($treatmentText = null)
    {
        $this->TreatmentText = $treatmentText;
        return $this;
    }
    /**
     * Get IncomingDate value
     * @return string|null
     */
    public function getIncomingDate()
    {
        return $this->IncomingDate;
    }
    /**
     * Set IncomingDate value
     * @param string $incomingDate
     * @return \StructType\CitizenQuestionsResult
     */
    public function setIncomingDate($incomingDate = null)
    {
        $this->IncomingDate = $incomingDate;
        return $this;
    }
    /**
     * Get CitizenQuestionsResData value
     * @return \StructType\CitizenQuestionsResData[]|null
     */
    public function getCitizenQuestionsResData()
    {
        return $this->CitizenQuestionsResData;
    }
    /**
     * Set CitizenQuestionsResData value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenQuestionsResData[] $citizenQuestionsResData
     * @return \StructType\CitizenQuestionsResult
     */
    public function setCitizenQuestionsResData(array $citizenQuestionsResData = array())
    {
        $this->CitizenQuestionsResData = $citizenQuestionsResData;
        return $this;
    }
    /**
     * Add item to CitizenQuestionsResData value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenQuestionsResData $item
     * @return \StructType\CitizenQuestionsResult
     */
    public function addToCitizenQuestionsResData(\StructType\CitizenQuestionsResData $item)
    {
        $this->CitizenQuestionsResData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CitizenQuestionsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
