<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос в ВУЦ | ЭП
 * - type: tns:CaRequest
 * @subpackage Structs
 */
class CaRequest extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The spiKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $spiKey;
    /**
     * The spiPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $spiPost;
    /**
     * The spiFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ
     * @var \StructType\FioType
     */
    public $spiFIO;
    /**
     * The chiefSpiKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор старшего СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $chiefSpiKey;
    /**
     * The chiefSpiPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности старшего СПИ | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $chiefSpiPost;
    /**
     * The chiefSpiFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ
     * @var \StructType\FioType
     */
    public $chiefSpiFIO;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - documentation: Тип запроса ВУЦ | Тип запроса в ВУЦ
     * - length: 1
     * @var string
     */
    public $requestType;
    /**
     * The certRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос ВУЦ | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $certRequest;
    /**
     * The certSign
     * Meta informations extracted from the WSDL
     * - documentation: ЭП запроса | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $certSign;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for CaRequest
     * @uses CaRequest::setInternalKey()
     * @uses CaRequest::setDocNumber()
     * @uses CaRequest::setDocDate()
     * @uses CaRequest::setSpiKey()
     * @uses CaRequest::setSpiPost()
     * @uses CaRequest::setSpiFIO()
     * @uses CaRequest::setChiefSpiKey()
     * @uses CaRequest::setChiefSpiPost()
     * @uses CaRequest::setChiefSpiFIO()
     * @uses CaRequest::setRequestType()
     * @uses CaRequest::setCertRequest()
     * @uses CaRequest::setCertSign()
     * @uses CaRequest::setSignDateTime()
     * @uses CaRequest::setSignature()
     * @param int $internalKey
     * @param string $docNumber
     * @param string $docDate
     * @param int $spiKey
     * @param string $spiPost
     * @param \StructType\FioType $spiFIO
     * @param int $chiefSpiKey
     * @param string $chiefSpiPost
     * @param \StructType\FioType $chiefSpiFIO
     * @param string $requestType
     * @param string $certRequest
     * @param string $certSign
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $docNumber = null, $docDate = null, $spiKey = null, $spiPost = null, \StructType\FioType $spiFIO = null, $chiefSpiKey = null, $chiefSpiPost = null, \StructType\FioType $chiefSpiFIO = null, $requestType = null, $certRequest = null, $certSign = null, $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setSpiKey($spiKey)
            ->setSpiPost($spiPost)
            ->setSpiFIO($spiFIO)
            ->setChiefSpiKey($chiefSpiKey)
            ->setChiefSpiPost($chiefSpiPost)
            ->setChiefSpiFIO($chiefSpiFIO)
            ->setRequestType($requestType)
            ->setCertRequest($certRequest)
            ->setCertSign($certSign)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\CaRequest
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\CaRequest
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\CaRequest
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get spiKey value
     * @return int|null
     */
    public function getSpiKey()
    {
        return $this->spiKey;
    }
    /**
     * Set spiKey value
     * @param int $spiKey
     * @return \StructType\CaRequest
     */
    public function setSpiKey($spiKey = null)
    {
        $this->spiKey = $spiKey;
        return $this;
    }
    /**
     * Get spiPost value
     * @return string|null
     */
    public function getSpiPost()
    {
        return $this->spiPost;
    }
    /**
     * Set spiPost value
     * @param string $spiPost
     * @return \StructType\CaRequest
     */
    public function setSpiPost($spiPost = null)
    {
        $this->spiPost = $spiPost;
        return $this;
    }
    /**
     * Get spiFIO value
     * @return \StructType\FioType|null
     */
    public function getSpiFIO()
    {
        return $this->spiFIO;
    }
    /**
     * Set spiFIO value
     * @param \StructType\FioType $spiFIO
     * @return \StructType\CaRequest
     */
    public function setSpiFIO(\StructType\FioType $spiFIO = null)
    {
        $this->spiFIO = $spiFIO;
        return $this;
    }
    /**
     * Get chiefSpiKey value
     * @return int|null
     */
    public function getChiefSpiKey()
    {
        return $this->chiefSpiKey;
    }
    /**
     * Set chiefSpiKey value
     * @param int $chiefSpiKey
     * @return \StructType\CaRequest
     */
    public function setChiefSpiKey($chiefSpiKey = null)
    {
        $this->chiefSpiKey = $chiefSpiKey;
        return $this;
    }
    /**
     * Get chiefSpiPost value
     * @return string|null
     */
    public function getChiefSpiPost()
    {
        return $this->chiefSpiPost;
    }
    /**
     * Set chiefSpiPost value
     * @param string $chiefSpiPost
     * @return \StructType\CaRequest
     */
    public function setChiefSpiPost($chiefSpiPost = null)
    {
        $this->chiefSpiPost = $chiefSpiPost;
        return $this;
    }
    /**
     * Get chiefSpiFIO value
     * @return \StructType\FioType|null
     */
    public function getChiefSpiFIO()
    {
        return $this->chiefSpiFIO;
    }
    /**
     * Set chiefSpiFIO value
     * @param \StructType\FioType $chiefSpiFIO
     * @return \StructType\CaRequest
     */
    public function setChiefSpiFIO(\StructType\FioType $chiefSpiFIO = null)
    {
        $this->chiefSpiFIO = $chiefSpiFIO;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @param string $requestType
     * @return \StructType\CaRequest
     */
    public function setRequestType($requestType = null)
    {
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get certRequest value
     * @return string|null
     */
    public function getCertRequest()
    {
        return $this->certRequest;
    }
    /**
     * Set certRequest value
     * @param string $certRequest
     * @return \StructType\CaRequest
     */
    public function setCertRequest($certRequest = null)
    {
        $this->certRequest = $certRequest;
        return $this;
    }
    /**
     * Get certSign value
     * @return string|null
     */
    public function getCertSign()
    {
        return $this->certSign;
    }
    /**
     * Set certSign value
     * @param string $certSign
     * @return \StructType\CaRequest
     */
    public function setCertSign($certSign = null)
    {
        $this->certSign = $certSign;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\CaRequest
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\CaRequest
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\CaRequest
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CaRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
