<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BKIDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о бюро кредитных историй
 * @subpackage Structs
 */
class BKIDatumType extends InformationType
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Номер БКИ | Строка длиной от 1 до 10 символов
     * - minOccurs: 1
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование БКИ | Строка длиной от 1 до 255 символов
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес БКИ | Строка длиной от 1 до 300 символов
     * - minOccurs: 1
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон БКИ | Строка длиной от 1 до 100 символов
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Phone;
    /**
     * Constructor method for BKIDatumType
     * @uses BKIDatumType::setNumber()
     * @uses BKIDatumType::setName()
     * @uses BKIDatumType::setAddress()
     * @uses BKIDatumType::setPhone()
     * @param string $number
     * @param string $name
     * @param string $address
     * @param string $phone
     */
    public function __construct($number = null, $name = null, $address = null, $phone = null)
    {
        $this
            ->setNumber($number)
            ->setName($name)
            ->setAddress($address)
            ->setPhone($phone);
    }
    /**
     * Get Number value
     * @return string
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\BKIDatumType
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BKIDatumType
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\BKIDatumType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\BKIDatumType
     */
    public function setPhone($phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BKIDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
