<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccDepoDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccDepoDataType "Наличие счетов ДЕПО"
 * @subpackage Structs
 */
class AvailabilityAccDepoDataType extends InformationType
{
    /**
     * The StrAcc
     * Meta informations extracted from the WSDL
     * - documentation: Счет ДЕПО | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $StrAcc;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for AvailabilityAccDepoDataType
     * @uses AvailabilityAccDepoDataType::setStrAcc()
     * @uses AvailabilityAccDepoDataType::setDeptCode()
     * @param string $strAcc
     * @param string $deptCode
     */
    public function __construct($strAcc = null, $deptCode = null)
    {
        $this
            ->setStrAcc($strAcc)
            ->setDeptCode($deptCode);
    }
    /**
     * Get StrAcc value
     * @return string|null
     */
    public function getStrAcc()
    {
        return $this->StrAcc;
    }
    /**
     * Set StrAcc value
     * @param string $strAcc
     * @return \StructType\AvailabilityAccDepoDataType
     */
    public function setStrAcc($strAcc = null)
    {
        $this->StrAcc = $strAcc;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\AvailabilityAccDepoDataType
     */
    public function setDeptCode($deptCode = null)
    {
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityAccDepoDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
