<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccDataType "Наличие денежных средств на счете"
 * @subpackage Structs
 */
class AvailabilityAccDataType extends AccountDatumType
{
    /**
     * The Summa
     * Meta informations extracted from the WSDL
     * - documentation: Cумма в валюте счета | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Summa;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Валюта счета | Указывается код валюты счета в соответствии с Общероссийским классификатором валют. В случае отсутствия
     * значения кода в общероссийском классификаторе валют, используется значение из Классификатора клиринговых валют. | Валюта | Код валюты
     * по общероссийскому классификатору валют. В случае отсутствия значения кода в общероссийском классификаторе валют - используется
     * значение из Классификатора клиринговых валют.
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The SummaInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сумме | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SummaInfo;
    /**
     * The SummaRUB
     * Meta informations extracted from the WSDL
     * - documentation: Сумма в рублях | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SummaRUB;
    /**
     * The DateChange
     * Meta informations extracted from the WSDL
     * - documentation: Дата курса | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateChange;
    /**
     * The UnityExchange
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сумме | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $UnityExchange;
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - documentation: Курс валюты | Обязательно заполняется курс валюты, в случае если валюта счета отлична от значения «810», «643». Указывается курс
     * валюты банка, либо, в случае отсутствия в банке собственного курса валюты, курс валюты ЦБ РФ, на дату формирования ответа. | Курс валюты
     * - minOccurs: 0
     * - fractionDigits: 4
     * - totalDigits: 15
     * @var float
     */
    public $ExchangeRate;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for AvailabilityAccDataType
     * @uses AvailabilityAccDataType::setSumma()
     * @uses AvailabilityAccDataType::setCurrencyCode()
     * @uses AvailabilityAccDataType::setSummaInfo()
     * @uses AvailabilityAccDataType::setSummaRUB()
     * @uses AvailabilityAccDataType::setDateChange()
     * @uses AvailabilityAccDataType::setUnityExchange()
     * @uses AvailabilityAccDataType::setExchangeRate()
     * @uses AvailabilityAccDataType::setDeptCode()
     * @param float $summa
     * @param string $currencyCode
     * @param string $summaInfo
     * @param float $summaRUB
     * @param string $dateChange
     * @param string $unityExchange
     * @param float $exchangeRate
     * @param string $deptCode
     */
    public function __construct($summa = null, $currencyCode = null, $summaInfo = null, $summaRUB = null, $dateChange = null, $unityExchange = null, $exchangeRate = null, $deptCode = null)
    {
        $this
            ->setSumma($summa)
            ->setCurrencyCode($currencyCode)
            ->setSummaInfo($summaInfo)
            ->setSummaRUB($summaRUB)
            ->setDateChange($dateChange)
            ->setUnityExchange($unityExchange)
            ->setExchangeRate($exchangeRate)
            ->setDeptCode($deptCode);
    }
    /**
     * Get Summa value
     * @return float|null
     */
    public function getSumma()
    {
        return $this->Summa;
    }
    /**
     * Set Summa value
     * @param float $summa
     * @return \StructType\AvailabilityAccDataType
     */
    public function setSumma($summa = null)
    {
        $this->Summa = $summa;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AvailabilityAccDataType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get SummaInfo value
     * @return string|null
     */
    public function getSummaInfo()
    {
        return $this->SummaInfo;
    }
    /**
     * Set SummaInfo value
     * @param string $summaInfo
     * @return \StructType\AvailabilityAccDataType
     */
    public function setSummaInfo($summaInfo = null)
    {
        $this->SummaInfo = $summaInfo;
        return $this;
    }
    /**
     * Get SummaRUB value
     * @return float|null
     */
    public function getSummaRUB()
    {
        return $this->SummaRUB;
    }
    /**
     * Set SummaRUB value
     * @param float $summaRUB
     * @return \StructType\AvailabilityAccDataType
     */
    public function setSummaRUB($summaRUB = null)
    {
        $this->SummaRUB = $summaRUB;
        return $this;
    }
    /**
     * Get DateChange value
     * @return string|null
     */
    public function getDateChange()
    {
        return $this->DateChange;
    }
    /**
     * Set DateChange value
     * @param string $dateChange
     * @return \StructType\AvailabilityAccDataType
     */
    public function setDateChange($dateChange = null)
    {
        $this->DateChange = $dateChange;
        return $this;
    }
    /**
     * Get UnityExchange value
     * @return string|null
     */
    public function getUnityExchange()
    {
        return $this->UnityExchange;
    }
    /**
     * Set UnityExchange value
     * @param string $unityExchange
     * @return \StructType\AvailabilityAccDataType
     */
    public function setUnityExchange($unityExchange = null)
    {
        $this->UnityExchange = $unityExchange;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\AvailabilityAccDataType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\AvailabilityAccDataType
     */
    public function setDeptCode($deptCode = null)
    {
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityAccDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
