<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoProcessRq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Автоматическая обработка документов
 * @subpackage Structs
 */
class AutoProcessRq extends SyncRq
{
    /**
     * The ipDataRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос информации о наличии и реквизитах ИП
     * @var \StructType\IPDataRequest
     */
    public $ipDataRequest;
    /**
     * The debtorIPListRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестра ИП по должнику
     * @var \StructType\DebtorIPListRequestType
     */
    public $debtorIPListRequest;
    /**
     * Constructor method for AutoProcessRq
     * @uses AutoProcessRq::setIpDataRequest()
     * @uses AutoProcessRq::setDebtorIPListRequest()
     * @param \StructType\IPDataRequest $ipDataRequest
     * @param \StructType\DebtorIPListRequestType $debtorIPListRequest
     */
    public function __construct(\StructType\IPDataRequest $ipDataRequest = null, \StructType\DebtorIPListRequestType $debtorIPListRequest = null)
    {
        $this
            ->setIpDataRequest($ipDataRequest)
            ->setDebtorIPListRequest($debtorIPListRequest);
    }
    /**
     * Get ipDataRequest value
     * @return \StructType\IPDataRequest|null
     */
    public function getIpDataRequest()
    {
        return $this->ipDataRequest;
    }
    /**
     * Set ipDataRequest value
     * @param \StructType\IPDataRequest $ipDataRequest
     * @return \StructType\AutoProcessRq
     */
    public function setIpDataRequest(\StructType\IPDataRequest $ipDataRequest = null)
    {
        $this->ipDataRequest = $ipDataRequest;
        return $this;
    }
    /**
     * Get debtorIPListRequest value
     * @return \StructType\DebtorIPListRequestType|null
     */
    public function getDebtorIPListRequest()
    {
        return $this->debtorIPListRequest;
    }
    /**
     * Set debtorIPListRequest value
     * @param \StructType\DebtorIPListRequestType $debtorIPListRequest
     * @return \StructType\AutoProcessRq
     */
    public function setDebtorIPListRequest(\StructType\DebtorIPListRequestType $debtorIPListRequest = null)
    {
        $this->debtorIPListRequest = $debtorIPListRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoProcessRq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
