<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных AttachmentType "Прикрепленный файл"
 * @subpackage Structs
 */
class AttachmentType extends AbstractStructBase
{
    /**
     * The fileName
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $fileName;
    /**
     * The fileTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип прикреплённого файла
     * - minOccurs: 0
     * @var string
     */
    public $fileTypeCode;
    /**
     * The contentType
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип вложения
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $contentType;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Данные
     * - expectedContentTypes: application/pdf
     * @var string
     */
    public $data;
    /**
     * Constructor method for AttachmentType
     * @uses AttachmentType::setFileName()
     * @uses AttachmentType::setFileTypeCode()
     * @uses AttachmentType::setContentType()
     * @uses AttachmentType::setData()
     * @param string $fileName
     * @param string $fileTypeCode
     * @param string $contentType
     * @param string $data
     */
    public function __construct($fileName = null, $fileTypeCode = null, $contentType = null, $data = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileTypeCode($fileTypeCode)
            ->setContentType($contentType)
            ->setData($data);
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\AttachmentType
     */
    public function setFileName($fileName = null)
    {
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileTypeCode value
     * @return string|null
     */
    public function getFileTypeCode()
    {
        return $this->fileTypeCode;
    }
    /**
     * Set fileTypeCode value
     * @uses \EnumType\FileType::valueIsValid()
     * @uses \EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileTypeCode
     * @return \StructType\AttachmentType
     */
    public function setFileTypeCode($fileTypeCode = null)
    {
        $this->fileTypeCode = $fileTypeCode;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\AttachmentType
     */
    public function setContentType($contentType = null)
    {
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\AttachmentType
     */
    public function setData($data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
