<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnswerAppResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос статуса рассмотрения обращения
 * - type: tns:AnswerAppResult
 * @subpackage Structs
 */
class AnswerAppResult extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The CitizensRegistryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $CitizensRegistryKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IsAppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия статуса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsAppStatus;
    /**
     * The ClaimerEmail
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты заявителя | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ClaimerEmail;
    /**
     * The ExternalRegistrationDate
     * Meta informations extracted from the WSDL
     * - documentation: Внешняя дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ExternalRegistrationDate;
    /**
     * The InternalRegistrationNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $InternalRegistrationNumber;
    /**
     * The InternalRegistrationDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $InternalRegistrationDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обращения
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текстовое сообщение | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Text;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for AnswerAppResult
     * @uses AnswerAppResult::setInternalKey()
     * @uses AnswerAppResult::setCitizensRegistryKey()
     * @uses AnswerAppResult::setExternalKey()
     * @uses AnswerAppResult::setIsAppStatus()
     * @uses AnswerAppResult::setClaimerEmail()
     * @uses AnswerAppResult::setExternalRegistrationDate()
     * @uses AnswerAppResult::setInternalRegistrationNumber()
     * @uses AnswerAppResult::setInternalRegistrationDate()
     * @uses AnswerAppResult::setStatus()
     * @uses AnswerAppResult::setText()
     * @uses AnswerAppResult::setId()
     * @param int $internalKey
     * @param int $citizensRegistryKey
     * @param string $externalKey
     * @param bool $isAppStatus
     * @param string $claimerEmail
     * @param string $externalRegistrationDate
     * @param string $internalRegistrationNumber
     * @param string $internalRegistrationDate
     * @param string $status
     * @param string $text
     * @param string $id
     */
    public function __construct($internalKey = null, $citizensRegistryKey = null, $externalKey = null, $isAppStatus = null, $claimerEmail = null, $externalRegistrationDate = null, $internalRegistrationNumber = null, $internalRegistrationDate = null, $status = null, $text = null, $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setCitizensRegistryKey($citizensRegistryKey)
            ->setExternalKey($externalKey)
            ->setIsAppStatus($isAppStatus)
            ->setClaimerEmail($claimerEmail)
            ->setExternalRegistrationDate($externalRegistrationDate)
            ->setInternalRegistrationNumber($internalRegistrationNumber)
            ->setInternalRegistrationDate($internalRegistrationDate)
            ->setStatus($status)
            ->setText($text)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\AnswerAppResult
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get CitizensRegistryKey value
     * @return int|null
     */
    public function getCitizensRegistryKey()
    {
        return $this->CitizensRegistryKey;
    }
    /**
     * Set CitizensRegistryKey value
     * @param int $citizensRegistryKey
     * @return \StructType\AnswerAppResult
     */
    public function setCitizensRegistryKey($citizensRegistryKey = null)
    {
        $this->CitizensRegistryKey = $citizensRegistryKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\AnswerAppResult
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IsAppStatus value
     * @return bool|null
     */
    public function getIsAppStatus()
    {
        return $this->IsAppStatus;
    }
    /**
     * Set IsAppStatus value
     * @param bool $isAppStatus
     * @return \StructType\AnswerAppResult
     */
    public function setIsAppStatus($isAppStatus = null)
    {
        $this->IsAppStatus = $isAppStatus;
        return $this;
    }
    /**
     * Get ClaimerEmail value
     * @return string|null
     */
    public function getClaimerEmail()
    {
        return $this->ClaimerEmail;
    }
    /**
     * Set ClaimerEmail value
     * @param string $claimerEmail
     * @return \StructType\AnswerAppResult
     */
    public function setClaimerEmail($claimerEmail = null)
    {
        $this->ClaimerEmail = $claimerEmail;
        return $this;
    }
    /**
     * Get ExternalRegistrationDate value
     * @return string|null
     */
    public function getExternalRegistrationDate()
    {
        return $this->ExternalRegistrationDate;
    }
    /**
     * Set ExternalRegistrationDate value
     * @param string $externalRegistrationDate
     * @return \StructType\AnswerAppResult
     */
    public function setExternalRegistrationDate($externalRegistrationDate = null)
    {
        $this->ExternalRegistrationDate = $externalRegistrationDate;
        return $this;
    }
    /**
     * Get InternalRegistrationNumber value
     * @return string|null
     */
    public function getInternalRegistrationNumber()
    {
        return $this->InternalRegistrationNumber;
    }
    /**
     * Set InternalRegistrationNumber value
     * @param string $internalRegistrationNumber
     * @return \StructType\AnswerAppResult
     */
    public function setInternalRegistrationNumber($internalRegistrationNumber = null)
    {
        $this->InternalRegistrationNumber = $internalRegistrationNumber;
        return $this;
    }
    /**
     * Get InternalRegistrationDate value
     * @return string|null
     */
    public function getInternalRegistrationDate()
    {
        return $this->InternalRegistrationDate;
    }
    /**
     * Set InternalRegistrationDate value
     * @param string $internalRegistrationDate
     * @return \StructType\AnswerAppResult
     */
    public function setInternalRegistrationDate($internalRegistrationDate = null)
    {
        $this->InternalRegistrationDate = $internalRegistrationDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ApplicationStatus::valueIsValid()
     * @uses \EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AnswerAppResult
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\AnswerAppResult
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\AnswerAppResult
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnswerAppResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
