<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Answer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Answer "Ответ на запрос СПИ" | ЭП
 * - type: tns:Answer
 * @subpackage Structs
 */
class Answer extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор ответа, присвоенный АИС внешнего контрагента Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The QueryInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ФССП России | Уникальный идентификатор запроса СПИ, присвоенный АИС ФССП России и переданный ранее внешнему
     * контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $QueryInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП Росии и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The applicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ заявления ЕПГУ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $applicationKey;
    /**
     * The answerDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $answerDate;
    /**
     * The AnswerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ответа | Тип ответа на запрос СПИ | NSI_MVV_QueryAnswer
     * - length: 2
     * @var string
     */
    public $AnswerType;
    /**
     * The authorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorName;
    /**
     * The authorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $authorPost;
    /**
     * The authorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorEmail;
    /**
     * The authorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $authorTelephone;
    /**
     * The LegalImpossibility
     * Meta informations extracted from the WSDL
     * - documentation: Причины невозможности исполнения требований СПИ | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $LegalImpossibility;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Answer
     * @uses Answer::setExternalKey()
     * @uses Answer::setQueryInternalKey()
     * @uses Answer::setIpInternalKey()
     * @uses Answer::setApplicationKey()
     * @uses Answer::setAnswerDate()
     * @uses Answer::setAnswerType()
     * @uses Answer::setAuthorName()
     * @uses Answer::setAuthorPost()
     * @uses Answer::setAuthorEmail()
     * @uses Answer::setAuthorTelephone()
     * @uses Answer::setLegalImpossibility()
     * @uses Answer::setData()
     * @uses Answer::setAttachments()
     * @uses Answer::setSignDateTime()
     * @uses Answer::setSignature()
     * @uses Answer::setId()
     * @param string $externalKey
     * @param int $queryInternalKey
     * @param int $ipInternalKey
     * @param string $applicationKey
     * @param string $answerDate
     * @param string $answerType
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     * @param string $legalImpossibility
     * @param \StructType\Data[] $data
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $queryInternalKey = null, $ipInternalKey = null, $applicationKey = null, $answerDate = null, $answerType = null, $authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null, $legalImpossibility = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setQueryInternalKey($queryInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setApplicationKey($applicationKey)
            ->setAnswerDate($answerDate)
            ->setAnswerType($answerType)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone)
            ->setLegalImpossibility($legalImpossibility)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\Answer
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get QueryInternalKey value
     * @return int|null
     */
    public function getQueryInternalKey()
    {
        return $this->QueryInternalKey;
    }
    /**
     * Set QueryInternalKey value
     * @param int $queryInternalKey
     * @return \StructType\Answer
     */
    public function setQueryInternalKey($queryInternalKey = null)
    {
        $this->QueryInternalKey = $queryInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\Answer
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get applicationKey value
     * @return string|null
     */
    public function getApplicationKey()
    {
        return $this->applicationKey;
    }
    /**
     * Set applicationKey value
     * @param string $applicationKey
     * @return \StructType\Answer
     */
    public function setApplicationKey($applicationKey = null)
    {
        $this->applicationKey = $applicationKey;
        return $this;
    }
    /**
     * Get answerDate value
     * @return string|null
     */
    public function getAnswerDate()
    {
        return $this->answerDate;
    }
    /**
     * Set answerDate value
     * @param string $answerDate
     * @return \StructType\Answer
     */
    public function setAnswerDate($answerDate = null)
    {
        $this->answerDate = $answerDate;
        return $this;
    }
    /**
     * Get AnswerType value
     * @return string|null
     */
    public function getAnswerType()
    {
        return $this->AnswerType;
    }
    /**
     * Set AnswerType value
     * @param string $answerType
     * @return \StructType\Answer
     */
    public function setAnswerType($answerType = null)
    {
        $this->AnswerType = $answerType;
        return $this;
    }
    /**
     * Get authorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->authorName;
    }
    /**
     * Set authorName value
     * @param string $authorName
     * @return \StructType\Answer
     */
    public function setAuthorName($authorName = null)
    {
        $this->authorName = $authorName;
        return $this;
    }
    /**
     * Get authorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->authorPost;
    }
    /**
     * Set authorPost value
     * @param string $authorPost
     * @return \StructType\Answer
     */
    public function setAuthorPost($authorPost = null)
    {
        $this->authorPost = $authorPost;
        return $this;
    }
    /**
     * Get authorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->authorEmail;
    }
    /**
     * Set authorEmail value
     * @param string $authorEmail
     * @return \StructType\Answer
     */
    public function setAuthorEmail($authorEmail = null)
    {
        $this->authorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get authorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->authorTelephone;
    }
    /**
     * Set authorTelephone value
     * @param string $authorTelephone
     * @return \StructType\Answer
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        $this->authorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Get LegalImpossibility value
     * @return string|null
     */
    public function getLegalImpossibility()
    {
        return $this->LegalImpossibility;
    }
    /**
     * Set LegalImpossibility value
     * @param string $legalImpossibility
     * @return \StructType\Answer
     */
    public function setLegalImpossibility($legalImpossibility = null)
    {
        $this->LegalImpossibility = $legalImpossibility;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\Answer
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Answer
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\Answer
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\Answer
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\Answer
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\Answer
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\Answer
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Answer
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Answer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
