<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AddressDataType "Адрес" | Используется для передачи данных о адресе физического или юридического лица
 * @subpackage Structs
 */
class AddressDataType extends InformationType
{
    /**
     * The StrAddr
     * Meta informations extracted from the WSDL
     * - documentation: СтрокаАдреса | Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия
     * кода страны) в произвольном формате | Строка длиной от 1 до 1500 символов
     * - maxLength: 1500
     * - minLength: 1
     * @var string
     */
    public $StrAddr;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес в расшифровке
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDate;
    /**
     * The RegEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegEndDate;
    /**
     * Constructor method for AddressDataType
     * @uses AddressDataType::setStrAddr()
     * @uses AddressDataType::setAddress()
     * @uses AddressDataType::setRegDate()
     * @uses AddressDataType::setRegEndDate()
     * @param string $strAddr
     * @param \StructType\AddressType $address
     * @param string $regDate
     * @param string $regEndDate
     */
    public function __construct($strAddr = null, \StructType\AddressType $address = null, $regDate = null, $regEndDate = null)
    {
        $this
            ->setStrAddr($strAddr)
            ->setAddress($address)
            ->setRegDate($regDate)
            ->setRegEndDate($regEndDate);
    }
    /**
     * Get StrAddr value
     * @return string|null
     */
    public function getStrAddr()
    {
        return $this->StrAddr;
    }
    /**
     * Set StrAddr value
     * @param string $strAddr
     * @return \StructType\AddressDataType
     */
    public function setStrAddr($strAddr = null)
    {
        $this->StrAddr = $strAddr;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\AddressDataType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \StructType\AddressDataType
     */
    public function setRegDate($regDate = null)
    {
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get RegEndDate value
     * @return string|null
     */
    public function getRegEndDate()
    {
        return $this->RegEndDate;
    }
    /**
     * Set RegEndDate value
     * @param string $regEndDate
     * @return \StructType\AddressDataType
     */
    public function setRegEndDate($regEndDate = null)
    {
        $this->RegEndDate = $regEndDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
