<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Постановление об аресте и ограничении | Тип данных документа «Постановление об аресте и ограничении» используется для
 * передачи внешнему контрагенту сведений об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество
 * должников
 * - type: tns:ActInfoType
 * @subpackage Structs
 */
class ActInfoType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Уникальный идентификатор постановления, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата вынесения постановления о наложении ограничения (ареста)/о снятии ограничения (ареста). | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Электронный номер постановления | Электронный номер постановления о наложении ограничения (ареста)/о снятии ограничения
     * (ареста), заполняется в формате: NNNNNNNNN/DDDDD», где NNNNNNNNN - числовой идентификатор документа, DDDDD - код отдела СП по справочнику ВКСП. | Номер
     * документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код | Штрих-код документа в формате code 39. Значение этого поля имеет формат: «NNNNNNNNN/DDDD», где NNNNNNNNN — числовой идентификатор
     * документа, DDDD — код отдела СП по справочнику ВКСП. | Штрих-код в формате code39
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, вынесшего постановление. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ/должностного лица ФССП России, утвердившего документ. | Полное имя физического лица (фамилия, имя,
     * отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ/должностного лица ФССП России, утвердившего документ. | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма средств, на которую накладывается арест | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия ограничения | Если дата начала действия ограничения не указана, ограничение действует с момента
     * получения документа. | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия ограничения | Если дата окончания действия ограничения не указана, ограничение действует до явного
     * снятия ограничения. | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The AppOrder
     * Meta informations extracted from the WSDL
     * - documentation: Порядок обжалования | Порядок обжалования постановления, значение по умолчанию - «Постановление судебного
     * пристава-исполнителя может быть обжаловано в порядке подчиненности вышестоящему должностному лицу службы судебных приставов или
     * оспорено в суде в 10-дневный срок». | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AppOrder;
    /**
     * The DocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocCode;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Текст основания принятия решения. | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Статья основания решения. | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The Part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Подпункт статьи основания решения. | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Part;
    /**
     * The ResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Оригинал постановления СПИ, вынесенного в соответствии с Приказом ФССП России от 22.04.2015 № 248 «Об
     * утверждении требований к формату постановления судебного пристава-исполнителя или иного должностного лица Федеральной службы
     * судебных приставов, вынесенного в форме электронного документа» в форме электронного документа в формате в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $ResolutionBase;
    /**
     * The SignatureResolutionBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП постановления СПИ | ЭП постановления СПИ вынесенного в электронном виде, элемента «ResolutionBase» в формате pkcs#7, в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $SignatureResolutionBase;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике.
     * - minOccurs: 0
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * Constructor method for ActInfoType
     * @uses ActInfoType::setInternalKey()
     * @uses ActInfoType::setDocDate()
     * @uses ActInfoType::setDocNum()
     * @uses ActInfoType::setBarcode()
     * @uses ActInfoType::setSPI()
     * @uses ActInfoType::setSPIFio()
     * @uses ActInfoType::setSPITel()
     * @uses ActInfoType::setSPIPost()
     * @uses ActInfoType::setAmount()
     * @uses ActInfoType::setStartDate()
     * @uses ActInfoType::setFinDate()
     * @uses ActInfoType::setAppOrder()
     * @uses ActInfoType::setDocCode()
     * @uses ActInfoType::setReason()
     * @uses ActInfoType::setArticle()
     * @uses ActInfoType::setPoint()
     * @uses ActInfoType::setPart()
     * @uses ActInfoType::setResolutionBase()
     * @uses ActInfoType::setSignatureResolutionBase()
     * @uses ActInfoType::setIP()
     * @uses ActInfoType::setData()
     * @param int $internalKey
     * @param string $docDate
     * @param string $docNum
     * @param string $barcode
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPITel
     * @param string $sPIPost
     * @param float $amount
     * @param string $startDate
     * @param string $finDate
     * @param string $appOrder
     * @param string $docCode
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param string $resolutionBase
     * @param string $signatureResolutionBase
     * @param \StructType\IP $iP
     * @param \StructType\Data[] $data
     */
    public function __construct($internalKey = null, $docDate = null, $docNum = null, $barcode = null, $sPI = null, $sPIFio = null, $sPITel = null, $sPIPost = null, $amount = null, $startDate = null, $finDate = null, $appOrder = null, $docCode = null, $reason = null, $article = null, $point = null, $part = null, $resolutionBase = null, $signatureResolutionBase = null, \StructType\IP $iP = null, array $data = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setDocNum($docNum)
            ->setBarcode($barcode)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setAmount($amount)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setAppOrder($appOrder)
            ->setDocCode($docCode)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setResolutionBase($resolutionBase)
            ->setSignatureResolutionBase($signatureResolutionBase)
            ->setIP($iP)
            ->setData($data);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\ActInfoType
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\ActInfoType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\ActInfoType
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\ActInfoType
     */
    public function setBarcode($barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\ActInfoType
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\ActInfoType
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\ActInfoType
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\ActInfoType
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ActInfoType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ActInfoType
     */
    public function setStartDate($startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \StructType\ActInfoType
     */
    public function setFinDate($finDate = null)
    {
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get AppOrder value
     * @return string|null
     */
    public function getAppOrder()
    {
        return $this->AppOrder;
    }
    /**
     * Set AppOrder value
     * @param string $appOrder
     * @return \StructType\ActInfoType
     */
    public function setAppOrder($appOrder = null)
    {
        $this->AppOrder = $appOrder;
        return $this;
    }
    /**
     * Get DocCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->DocCode;
    }
    /**
     * Set DocCode value
     * @param string $docCode
     * @return \StructType\ActInfoType
     */
    public function setDocCode($docCode = null)
    {
        $this->DocCode = $docCode;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\ActInfoType
     */
    public function setReason($reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\ActInfoType
     */
    public function setArticle($article = null)
    {
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \StructType\ActInfoType
     */
    public function setPoint($point = null)
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Get Part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @param string $part
     * @return \StructType\ActInfoType
     */
    public function setPart($part = null)
    {
        $this->Part = $part;
        return $this;
    }
    /**
     * Get ResolutionBase value
     * @return string|null
     */
    public function getResolutionBase()
    {
        return $this->ResolutionBase;
    }
    /**
     * Set ResolutionBase value
     * @param string $resolutionBase
     * @return \StructType\ActInfoType
     */
    public function setResolutionBase($resolutionBase = null)
    {
        $this->ResolutionBase = $resolutionBase;
        return $this;
    }
    /**
     * Get SignatureResolutionBase value
     * @return string|null
     */
    public function getSignatureResolutionBase()
    {
        return $this->SignatureResolutionBase;
    }
    /**
     * Set SignatureResolutionBase value
     * @param string $signatureResolutionBase
     * @return \StructType\ActInfoType
     */
    public function setSignatureResolutionBase($signatureResolutionBase = null)
    {
        $this->SignatureResolutionBase = $signatureResolutionBase;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\ActInfoType
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\ActInfoType
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\ActInfoType
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
