<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер AccountType "Состояние счета"
 * @subpackage Structs
 */
class AccountType extends AbstractStructBase
{
    /**
     * The AccountCode
     * Meta informations extracted from the WSDL
     * - documentation: Код счета | Код счета из справочника «Бухгалтерские счета» | Код счета | NSI_MVV_AccountingAccountCode
     * - maxLength: 13
     * - minLength: 1
     * @var string
     */
    public $AccountCode;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for AccountType
     * @uses AccountType::setAccountCode()
     * @uses AccountType::setAmount()
     * @param string $accountCode
     * @param float $amount
     */
    public function __construct($accountCode = null, $amount = null)
    {
        $this
            ->setAccountCode($accountCode)
            ->setAmount($amount);
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\AccountType
     */
    public function setAccountCode($accountCode = null)
    {
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
