<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ AccountQuery "Запрос СПИ на предоставление сведений об архивных счетах и движении денежных средств" | ЭП
 * - type: tns:AccountQuery
 * @subpackage Structs
 */
class AccountQuery extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Содержит уникальный идентификатор, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, сделавшего запрос | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, сделавшего запрос | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ, сделавшего запрос. Заполняется только в том случае, если соответствующие данные есть в системе. Для запросов к
     * операторам сотовой связи обязательно.
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, сделавшего запрос | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The ChSPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ | ФИО полностью Старшего СПИ, разрешившего запрос | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ChSPIFio;
    /**
     * The ChSPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ | Код должности Старшего СПИ, разрешившего запрос. Для запросов к операторам сотовой связи обязательно.
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $ChSPIFioParts;
    /**
     * The ChSPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность старшего СПИ | Код должности Старшего СПИ, разрешившего запрос | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $ChSPIPost;
    /**
     * The AnsDate
     * Meta informations extracted from the WSDL
     * - documentation: Срок ответа | Срок ответа, установленный СПИ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AnsDate;
    /**
     * The SearchCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Страна поиска | Ограничение по стране поиска (код страны по ОКСМ) | Код страны цифровой | Цифровой код страны по ОКСМ
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $SearchCountryCode;
    /**
     * The SearchCountryName
     * Meta informations extracted from the WSDL
     * - documentation: Страна поиска | Ограничение по стране поиска (наименование страны) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $SearchCountryName;
    /**
     * The SearchRegion
     * Meta informations extracted from the WSDL
     * - documentation: Регион поиска | Ограничение по региону поиска (код региона) | Код региона по КЛАДР
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $SearchRegion;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата создания | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $CreateDate;
    /**
     * The DocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocCode;
    /**
     * The ExtractBegin
     * Meta informations extracted from the WSDL
     * - documentation: Период выписки от | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ExtractBegin;
    /**
     * The ExtractEnd
     * Meta informations extracted from the WSDL
     * - documentation: Период выписки до | В случае если дата не указана, то датой «до» считается дата ответа на запрос | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ExtractEnd;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительное производство | Сведения об исполнительном производстве
     * @var \StructType\IP
     */
    public $IP;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Используется при уточнении реквизитов должника
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for AccountQuery
     * @uses AccountQuery::setInternalKey()
     * @uses AccountQuery::setDocDate()
     * @uses AccountQuery::setDocNumber()
     * @uses AccountQuery::setSPI()
     * @uses AccountQuery::setSPIFio()
     * @uses AccountQuery::setSPIFioParts()
     * @uses AccountQuery::setSPITel()
     * @uses AccountQuery::setSPIPost()
     * @uses AccountQuery::setChSPIFio()
     * @uses AccountQuery::setChSPIFioParts()
     * @uses AccountQuery::setChSPIPost()
     * @uses AccountQuery::setAnsDate()
     * @uses AccountQuery::setSearchCountryCode()
     * @uses AccountQuery::setSearchCountryName()
     * @uses AccountQuery::setSearchRegion()
     * @uses AccountQuery::setCreateDate()
     * @uses AccountQuery::setDocCode()
     * @uses AccountQuery::setExtractBegin()
     * @uses AccountQuery::setExtractEnd()
     * @uses AccountQuery::setIP()
     * @uses AccountQuery::setData()
     * @uses AccountQuery::setAttachments()
     * @uses AccountQuery::setSignDateTime()
     * @uses AccountQuery::setSignature()
     * @uses AccountQuery::setId()
     * @param int $internalKey
     * @param string $docDate
     * @param string $docNumber
     * @param int $sPI
     * @param string $sPIFio
     * @param \StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     * @param string $chSPIFio
     * @param \StructType\FioType $chSPIFioParts
     * @param string $chSPIPost
     * @param string $ansDate
     * @param string $searchCountryCode
     * @param string $searchCountryName
     * @param string $searchRegion
     * @param string $createDate
     * @param string $docCode
     * @param string $extractBegin
     * @param string $extractEnd
     * @param \StructType\IP $iP
     * @param \StructType\Data[] $data
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $docDate = null, $docNumber = null, $sPI = null, $sPIFio = null, \StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null, $chSPIFio = null, \StructType\FioType $chSPIFioParts = null, $chSPIPost = null, $ansDate = null, $searchCountryCode = null, $searchCountryName = null, $searchRegion = null, $createDate = null, $docCode = null, $extractBegin = null, $extractEnd = null, \StructType\IP $iP = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setChSPIFio($chSPIFio)
            ->setChSPIFioParts($chSPIFioParts)
            ->setChSPIPost($chSPIPost)
            ->setAnsDate($ansDate)
            ->setSearchCountryCode($searchCountryCode)
            ->setSearchCountryName($searchCountryName)
            ->setSearchRegion($searchRegion)
            ->setCreateDate($createDate)
            ->setDocCode($docCode)
            ->setExtractBegin($extractBegin)
            ->setExtractEnd($extractEnd)
            ->setIP($iP)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\AccountQuery
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\AccountQuery
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\AccountQuery
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\AccountQuery
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\AccountQuery
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \StructType\FioType $sPIFioParts
     * @return \StructType\AccountQuery
     */
    public function setSPIFioParts(\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\AccountQuery
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\AccountQuery
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get ChSPIFio value
     * @return string|null
     */
    public function getChSPIFio()
    {
        return $this->ChSPIFio;
    }
    /**
     * Set ChSPIFio value
     * @param string $chSPIFio
     * @return \StructType\AccountQuery
     */
    public function setChSPIFio($chSPIFio = null)
    {
        $this->ChSPIFio = $chSPIFio;
        return $this;
    }
    /**
     * Get ChSPIFioParts value
     * @return \StructType\FioType|null
     */
    public function getChSPIFioParts()
    {
        return $this->ChSPIFioParts;
    }
    /**
     * Set ChSPIFioParts value
     * @param \StructType\FioType $chSPIFioParts
     * @return \StructType\AccountQuery
     */
    public function setChSPIFioParts(\StructType\FioType $chSPIFioParts = null)
    {
        $this->ChSPIFioParts = $chSPIFioParts;
        return $this;
    }
    /**
     * Get ChSPIPost value
     * @return string|null
     */
    public function getChSPIPost()
    {
        return $this->ChSPIPost;
    }
    /**
     * Set ChSPIPost value
     * @param string $chSPIPost
     * @return \StructType\AccountQuery
     */
    public function setChSPIPost($chSPIPost = null)
    {
        $this->ChSPIPost = $chSPIPost;
        return $this;
    }
    /**
     * Get AnsDate value
     * @return string|null
     */
    public function getAnsDate()
    {
        return $this->AnsDate;
    }
    /**
     * Set AnsDate value
     * @param string $ansDate
     * @return \StructType\AccountQuery
     */
    public function setAnsDate($ansDate = null)
    {
        $this->AnsDate = $ansDate;
        return $this;
    }
    /**
     * Get SearchCountryCode value
     * @return string|null
     */
    public function getSearchCountryCode()
    {
        return $this->SearchCountryCode;
    }
    /**
     * Set SearchCountryCode value
     * @param string $searchCountryCode
     * @return \StructType\AccountQuery
     */
    public function setSearchCountryCode($searchCountryCode = null)
    {
        $this->SearchCountryCode = $searchCountryCode;
        return $this;
    }
    /**
     * Get SearchCountryName value
     * @return string|null
     */
    public function getSearchCountryName()
    {
        return $this->SearchCountryName;
    }
    /**
     * Set SearchCountryName value
     * @param string $searchCountryName
     * @return \StructType\AccountQuery
     */
    public function setSearchCountryName($searchCountryName = null)
    {
        $this->SearchCountryName = $searchCountryName;
        return $this;
    }
    /**
     * Get SearchRegion value
     * @return string|null
     */
    public function getSearchRegion()
    {
        return $this->SearchRegion;
    }
    /**
     * Set SearchRegion value
     * @param string $searchRegion
     * @return \StructType\AccountQuery
     */
    public function setSearchRegion($searchRegion = null)
    {
        $this->SearchRegion = $searchRegion;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\AccountQuery
     */
    public function setCreateDate($createDate = null)
    {
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get DocCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->DocCode;
    }
    /**
     * Set DocCode value
     * @param string $docCode
     * @return \StructType\AccountQuery
     */
    public function setDocCode($docCode = null)
    {
        $this->DocCode = $docCode;
        return $this;
    }
    /**
     * Get ExtractBegin value
     * @return string|null
     */
    public function getExtractBegin()
    {
        return $this->ExtractBegin;
    }
    /**
     * Set ExtractBegin value
     * @param string $extractBegin
     * @return \StructType\AccountQuery
     */
    public function setExtractBegin($extractBegin = null)
    {
        $this->ExtractBegin = $extractBegin;
        return $this;
    }
    /**
     * Get ExtractEnd value
     * @return string|null
     */
    public function getExtractEnd()
    {
        return $this->ExtractEnd;
    }
    /**
     * Set ExtractEnd value
     * @param string $extractEnd
     * @return \StructType\AccountQuery
     */
    public function setExtractEnd($extractEnd = null)
    {
        $this->ExtractEnd = $extractEnd;
        return $this;
    }
    /**
     * Get IP value
     * @return \StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \StructType\IP $iP
     * @return \StructType\AccountQuery
     */
    public function setIP(\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\AccountQuery
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\AccountQuery
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\AccountQuery
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\AccountQuery
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\AccountQuery
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\AccountQuery
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\AccountQuery
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\AccountQuery
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
