<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о банковском счете
 * @subpackage Structs
 */
class AccountDatumType extends InformationType
{
    /**
     * The Acc
     * Meta informations extracted from the WSDL
     * - documentation: Счет | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Acc;
    /**
     * The PersonalAcc
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAcc;
    /**
     * The BicBank
     * Meta informations extracted from the WSDL
     * - documentation: БИК | Обязательно к заполнению для кредитных организаций. БИК банка (филиала) или учреждения Банка России, исполняющего решение
     * или запрос. | Банковский идентификационный код (БИК)
     * - minOccurs: 0
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BicBank;
    /**
     * The bankORGN
     * Meta informations extracted from the WSDL
     * - documentation: Основной государственный регистрационный номер кредитной организации | Основной государственный регистрационный номер
     * (ОГРН)
     * - minOccurs: 0
     * - length: 13
     * - pattern: [0-9]{13}
     * @var string
     */
    public $bankORGN;
    /**
     * The bankINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН кредитной организации | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $bankINN;
    /**
     * The bankKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП кредитной организации | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $bankKPP;
    /**
     * The contractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора банковского счета | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $contractNumber;
    /**
     * The contractStartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractStartDate;
    /**
     * The contractFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractFinDate;
    /**
     * The accountKindCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида банковского счёта
     * - minOccurs: 0
     * @var string
     */
    public $accountKindCode;
    /**
     * The accountKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование счёта | Строка длиной от 1 до 500 символов
     * - minOccurs: 0
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $accountKindName;
    /**
     * Constructor method for AccountDatumType
     * @uses AccountDatumType::setAcc()
     * @uses AccountDatumType::setPersonalAcc()
     * @uses AccountDatumType::setBicBank()
     * @uses AccountDatumType::setBankORGN()
     * @uses AccountDatumType::setBankINN()
     * @uses AccountDatumType::setBankKPP()
     * @uses AccountDatumType::setContractNumber()
     * @uses AccountDatumType::setContractStartDate()
     * @uses AccountDatumType::setContractFinDate()
     * @uses AccountDatumType::setAccountKindCode()
     * @uses AccountDatumType::setAccountKindName()
     * @param string $acc
     * @param string $personalAcc
     * @param string $bicBank
     * @param string $bankORGN
     * @param string $bankINN
     * @param string $bankKPP
     * @param string $contractNumber
     * @param string $contractStartDate
     * @param string $contractFinDate
     * @param string $accountKindCode
     * @param string $accountKindName
     */
    public function __construct($acc = null, $personalAcc = null, $bicBank = null, $bankORGN = null, $bankINN = null, $bankKPP = null, $contractNumber = null, $contractStartDate = null, $contractFinDate = null, $accountKindCode = null, $accountKindName = null)
    {
        $this
            ->setAcc($acc)
            ->setPersonalAcc($personalAcc)
            ->setBicBank($bicBank)
            ->setBankORGN($bankORGN)
            ->setBankINN($bankINN)
            ->setBankKPP($bankKPP)
            ->setContractNumber($contractNumber)
            ->setContractStartDate($contractStartDate)
            ->setContractFinDate($contractFinDate)
            ->setAccountKindCode($accountKindCode)
            ->setAccountKindName($accountKindName);
    }
    /**
     * Get Acc value
     * @return string|null
     */
    public function getAcc()
    {
        return $this->Acc;
    }
    /**
     * Set Acc value
     * @param string $acc
     * @return \StructType\AccountDatumType
     */
    public function setAcc($acc = null)
    {
        $this->Acc = $acc;
        return $this;
    }
    /**
     * Get PersonalAcc value
     * @return string|null
     */
    public function getPersonalAcc()
    {
        return $this->PersonalAcc;
    }
    /**
     * Set PersonalAcc value
     * @param string $personalAcc
     * @return \StructType\AccountDatumType
     */
    public function setPersonalAcc($personalAcc = null)
    {
        $this->PersonalAcc = $personalAcc;
        return $this;
    }
    /**
     * Get BicBank value
     * @return string|null
     */
    public function getBicBank()
    {
        return $this->BicBank;
    }
    /**
     * Set BicBank value
     * @param string $bicBank
     * @return \StructType\AccountDatumType
     */
    public function setBicBank($bicBank = null)
    {
        $this->BicBank = $bicBank;
        return $this;
    }
    /**
     * Get bankORGN value
     * @return string|null
     */
    public function getBankORGN()
    {
        return $this->bankORGN;
    }
    /**
     * Set bankORGN value
     * @param string $bankORGN
     * @return \StructType\AccountDatumType
     */
    public function setBankORGN($bankORGN = null)
    {
        $this->bankORGN = $bankORGN;
        return $this;
    }
    /**
     * Get bankINN value
     * @return string|null
     */
    public function getBankINN()
    {
        return $this->bankINN;
    }
    /**
     * Set bankINN value
     * @param string $bankINN
     * @return \StructType\AccountDatumType
     */
    public function setBankINN($bankINN = null)
    {
        $this->bankINN = $bankINN;
        return $this;
    }
    /**
     * Get bankKPP value
     * @return string|null
     */
    public function getBankKPP()
    {
        return $this->bankKPP;
    }
    /**
     * Set bankKPP value
     * @param string $bankKPP
     * @return \StructType\AccountDatumType
     */
    public function setBankKPP($bankKPP = null)
    {
        $this->bankKPP = $bankKPP;
        return $this;
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \StructType\AccountDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get contractStartDate value
     * @return string|null
     */
    public function getContractStartDate()
    {
        return $this->contractStartDate;
    }
    /**
     * Set contractStartDate value
     * @param string $contractStartDate
     * @return \StructType\AccountDatumType
     */
    public function setContractStartDate($contractStartDate = null)
    {
        $this->contractStartDate = $contractStartDate;
        return $this;
    }
    /**
     * Get contractFinDate value
     * @return string|null
     */
    public function getContractFinDate()
    {
        return $this->contractFinDate;
    }
    /**
     * Set contractFinDate value
     * @param string $contractFinDate
     * @return \StructType\AccountDatumType
     */
    public function setContractFinDate($contractFinDate = null)
    {
        $this->contractFinDate = $contractFinDate;
        return $this;
    }
    /**
     * Get accountKindCode value
     * @return string|null
     */
    public function getAccountKindCode()
    {
        return $this->accountKindCode;
    }
    /**
     * Set accountKindCode value
     * @uses \EnumType\AccountKindCodeType::valueIsValid()
     * @uses \EnumType\AccountKindCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountKindCode
     * @return \StructType\AccountDatumType
     */
    public function setAccountKindCode($accountKindCode = null)
    {
        $this->accountKindCode = $accountKindCode;
        return $this;
    }
    /**
     * Get accountKindName value
     * @return string|null
     */
    public function getAccountKindName()
    {
        return $this->accountKindName;
    }
    /**
     * Set accountKindName value
     * @param string $accountKindName
     * @return \StructType\AccountDatumType
     */
    public function setAccountKindName($accountKindName = null)
    {
        $this->accountKindName = $accountKindName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
