<?php

namespace EnumType;

/**
 * This class stands for LookupTableType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Код вида справочника
 * @subpackage Enumerations
 */
class LookupTableType
{
    /**
     * Constant for value 'MVV_CURRENCY_TYPE'
     * @return string 'MVV_CURRENCY_TYPE'
     */
    const VALUE_MVV_CURRENCY_TYPE = 'MVV_CURRENCY_TYPE';
    /**
     * Constant for value 'DIRECTORY_TYPES'
     * @return string 'DIRECTORY_TYPES'
     */
    const VALUE_DIRECTORY_TYPES = 'DIRECTORY_TYPES';
    /**
     * Constant for value 'Departments'
     * @return string 'Departments'
     */
    const VALUE_DEPARTMENTS = 'Departments';
    /**
     * Constant for value 'PIEV_FORMAT_VERSION'
     * @return string 'PIEV_FORMAT_VERSION'
     */
    const VALUE_PIEV_FORMAT_VERSION = 'PIEV_FORMAT_VERSION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MVV_CURRENCY_TYPE
     * @uses self::VALUE_DIRECTORY_TYPES
     * @uses self::VALUE_DEPARTMENTS
     * @uses self::VALUE_PIEV_FORMAT_VERSION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MVV_CURRENCY_TYPE,
            self::VALUE_DIRECTORY_TYPES,
            self::VALUE_DEPARTMENTS,
            self::VALUE_PIEV_FORMAT_VERSION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
