<?php

namespace EnumType;

/**
 * This class stands for GoodsType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений о товаре
 * @subpackage Enumerations
 */
class GoodsType
{
    /**
     * Constant for value 'MoveGoods'
     * @return string 'MoveGoods'
     */
    const VALUE_MOVE_GOODS = 'MoveGoods';
    /**
     * Constant for value 'WarehouseGoods'
     * @return string 'WarehouseGoods'
     */
    const VALUE_WAREHOUSE_GOODS = 'WarehouseGoods';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MOVE_GOODS
     * @uses self::VALUE_WAREHOUSE_GOODS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MOVE_GOODS,
            self::VALUE_WAREHOUSE_GOODS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
