<?php

namespace EnumType;

/**
 * This class stands for FileType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Показывает, какая часть передаваемых данных находится в файле. | Тип прикреплённого файла
 * - maxLength: 2
 * - minLength: 1
 * @subpackage Enumerations
 */
class FileType
{
    /**
     * Constant for value 'PACK'
     * @return string 'PACK'
     */
    const VALUE_PACK = 'PACK';
    /**
     * Constant for value 'DOCUMENT'
     * @return string 'DOCUMENT'
     */
    const VALUE_DOCUMENT = 'DOCUMENT';
    /**
     * Constant for value 'ALL_ATTACHMENTS'
     * @return string 'ALL_ATTACHMENTS'
     */
    const VALUE_ALL_ATTACHMENTS = 'ALL_ATTACHMENTS';
    /**
     * Constant for value 'SINGLE_ATTACHMENT'
     * @return string 'SINGLE_ATTACHMENT'
     */
    const VALUE_SINGLE_ATTACHMENT = 'SINGLE_ATTACHMENT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PACK
     * @uses self::VALUE_DOCUMENT
     * @uses self::VALUE_ALL_ATTACHMENTS
     * @uses self::VALUE_SINGLE_ATTACHMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PACK,
            self::VALUE_DOCUMENT,
            self::VALUE_ALL_ATTACHMENTS,
            self::VALUE_SINGLE_ATTACHMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
