<?php

namespace EnumType;

/**
 * This class stands for EQAppointmentActionType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Действия над заявкой для сервиса ЛП
 * @subpackage Enumerations
 */
class EQAppointmentActionType
{
    /**
     * Constant for value 'APPROVE'
     * @return string 'APPROVE'
     */
    const VALUE_APPROVE = 'APPROVE';
    /**
     * Constant for value 'REJECT'
     * @return string 'REJECT'
     */
    const VALUE_REJECT = 'REJECT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPROVE
     * @uses self::VALUE_REJECT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPROVE,
            self::VALUE_REJECT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
