<?php

namespace EnumType;

/**
 * This class stands for DDxMessageTypeType EnumType
 * @subpackage Enumerations
 */
class DDxMessageTypeType
{
    /**
     * Constant for value 'ARBITRARY'
     * @return string 'ARBITRARY'
     */
    const VALUE_ARBITRARY = 'ARBITRARY';
    /**
     * Constant for value 'ERROR_MSG'
     * @return string 'ERROR_MSG'
     */
    const VALUE_ERROR_MSG = 'ERROR_MSG';
    /**
     * Constant for value 'FILE_RECV'
     * @return string 'FILE_RECV'
     */
    const VALUE_FILE_RECV = 'FILE_RECV';
    /**
     * Constant for value 'FILE_SEND'
     * @return string 'FILE_SEND'
     */
    const VALUE_FILE_SEND = 'FILE_SEND';
    /**
     * Constant for value 'PACK_RECV'
     * @return string 'PACK_RECV'
     */
    const VALUE_PACK_RECV = 'PACK_RECV';
    /**
     * Constant for value 'PACK_SEND'
     * @return string 'PACK_SEND'
     */
    const VALUE_PACK_SEND = 'PACK_SEND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARBITRARY
     * @uses self::VALUE_ERROR_MSG
     * @uses self::VALUE_FILE_RECV
     * @uses self::VALUE_FILE_SEND
     * @uses self::VALUE_PACK_RECV
     * @uses self::VALUE_PACK_SEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARBITRARY,
            self::VALUE_ERROR_MSG,
            self::VALUE_FILE_RECV,
            self::VALUE_FILE_SEND,
            self::VALUE_PACK_RECV,
            self::VALUE_PACK_SEND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
