<?php

namespace EnumType;

/**
 * This class stands for BlockType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип служебного блока
 * @subpackage Enumerations
 */
class BlockType
{
    /**
     * Constant for value 'DXControl'
     * @return string 'DXControl'
     */
    const VALUE_DXCONTROL = 'DXControl';
    /**
     * Constant for value 'DXPack'
     * @return string 'DXPack'
     */
    const VALUE_DXPACK = 'DXPack';
    /**
     * Constant for value 'DXReceipt'
     * @return string 'DXReceipt'
     */
    const VALUE_DXRECEIPT = 'DXReceipt';
    /**
     * Constant for value 'DXFileData'
     * @return string 'DXFileData'
     */
    const VALUE_DXFILE_DATA = 'DXFileData';
    /**
     * Constant for value 'DXFileRequest'
     * @return string 'DXFileRequest'
     */
    const VALUE_DXFILE_REQUEST = 'DXFileRequest';
    /**
     * Constant for value 'DXFileReceipt'
     * @return string 'DXFileReceipt'
     */
    const VALUE_DXFILE_RECEIPT = 'DXFileReceipt';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DXCONTROL
     * @uses self::VALUE_DXPACK
     * @uses self::VALUE_DXRECEIPT
     * @uses self::VALUE_DXFILE_DATA
     * @uses self::VALUE_DXFILE_REQUEST
     * @uses self::VALUE_DXFILE_RECEIPT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DXCONTROL,
            self::VALUE_DXPACK,
            self::VALUE_DXRECEIPT,
            self::VALUE_DXFILE_DATA,
            self::VALUE_DXFILE_REQUEST,
            self::VALUE_DXFILE_RECEIPT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
