<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithheldDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о произведенных удержаниях
 * @subpackage Structs
 */
class WithheldDetailType extends AbstractStructBase
{
    /**
     * The WithheldType
     * Meta informations extracted from the WSDL
     * - documentation: Тип удержания
     * @var string
     */
    public $WithheldType;
    /**
     * The WithheldAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $WithheldAmount;
    /**
     * Constructor method for WithheldDetailType
     * @uses WithheldDetailType::setWithheldType()
     * @uses WithheldDetailType::setWithheldAmount()
     * @param string $withheldType
     * @param float $withheldAmount
     */
    public function __construct($withheldType = null, $withheldAmount = null)
    {
        $this
            ->setWithheldType($withheldType)
            ->setWithheldAmount($withheldAmount);
    }
    /**
     * Get WithheldType value
     * @return string|null
     */
    public function getWithheldType()
    {
        return $this->WithheldType;
    }
    /**
     * Set WithheldType value
     * @uses \EnumType\WithheldCodeType::valueIsValid()
     * @uses \EnumType\WithheldCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withheldType
     * @return \StructType\WithheldDetailType
     */
    public function setWithheldType($withheldType = null)
    {
        $this->WithheldType = $withheldType;
        return $this;
    }
    /**
     * Get WithheldAmount value
     * @return float|null
     */
    public function getWithheldAmount()
    {
        return $this->WithheldAmount;
    }
    /**
     * Set WithheldAmount value
     * @param float $withheldAmount
     * @return \StructType\WithheldDetailType
     */
    public function setWithheldAmount($withheldAmount = null)
    {
        $this->WithheldAmount = $withheldAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WithheldDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
