<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeaponDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о зарегистрированном оружии
 * @subpackage Structs
 */
class WeaponDatumType extends InformationType
{
    /**
     * The WeaponKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид оружия | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $WeaponKind;
    /**
     * The WeaponType
     * Meta informations extracted from the WSDL
     * - documentation: Тип оружия | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $WeaponType;
    /**
     * The WeaponName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование оружия | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $WeaponName;
    /**
     * The WeaponQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Количество найденных единиц оружия данной модели | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $WeaponQuantity;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDate;
    /**
     * The WeaponAdress
     * Meta informations extracted from the WSDL
     * - documentation: Место хранения оружия
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $WeaponAdress;
    /**
     * Constructor method for WeaponDatumType
     * @uses WeaponDatumType::setWeaponKind()
     * @uses WeaponDatumType::setWeaponType()
     * @uses WeaponDatumType::setWeaponName()
     * @uses WeaponDatumType::setWeaponQuantity()
     * @uses WeaponDatumType::setRegDate()
     * @uses WeaponDatumType::setWeaponAdress()
     * @param string $weaponKind
     * @param string $weaponType
     * @param string $weaponName
     * @param int $weaponQuantity
     * @param string $regDate
     * @param \StructType\AddressType $weaponAdress
     */
    public function __construct($weaponKind = null, $weaponType = null, $weaponName = null, $weaponQuantity = null, $regDate = null, \StructType\AddressType $weaponAdress = null)
    {
        $this
            ->setWeaponKind($weaponKind)
            ->setWeaponType($weaponType)
            ->setWeaponName($weaponName)
            ->setWeaponQuantity($weaponQuantity)
            ->setRegDate($regDate)
            ->setWeaponAdress($weaponAdress);
    }
    /**
     * Get WeaponKind value
     * @return string|null
     */
    public function getWeaponKind()
    {
        return $this->WeaponKind;
    }
    /**
     * Set WeaponKind value
     * @param string $weaponKind
     * @return \StructType\WeaponDatumType
     */
    public function setWeaponKind($weaponKind = null)
    {
        $this->WeaponKind = $weaponKind;
        return $this;
    }
    /**
     * Get WeaponType value
     * @return string|null
     */
    public function getWeaponType()
    {
        return $this->WeaponType;
    }
    /**
     * Set WeaponType value
     * @param string $weaponType
     * @return \StructType\WeaponDatumType
     */
    public function setWeaponType($weaponType = null)
    {
        $this->WeaponType = $weaponType;
        return $this;
    }
    /**
     * Get WeaponName value
     * @return string|null
     */
    public function getWeaponName()
    {
        return $this->WeaponName;
    }
    /**
     * Set WeaponName value
     * @param string $weaponName
     * @return \StructType\WeaponDatumType
     */
    public function setWeaponName($weaponName = null)
    {
        $this->WeaponName = $weaponName;
        return $this;
    }
    /**
     * Get WeaponQuantity value
     * @return int|null
     */
    public function getWeaponQuantity()
    {
        return $this->WeaponQuantity;
    }
    /**
     * Set WeaponQuantity value
     * @param int $weaponQuantity
     * @return \StructType\WeaponDatumType
     */
    public function setWeaponQuantity($weaponQuantity = null)
    {
        $this->WeaponQuantity = $weaponQuantity;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \StructType\WeaponDatumType
     */
    public function setRegDate($regDate = null)
    {
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get WeaponAdress value
     * @return \StructType\AddressType|null
     */
    public function getWeaponAdress()
    {
        return $this->WeaponAdress;
    }
    /**
     * Set WeaponAdress value
     * @param \StructType\AddressType $weaponAdress
     * @return \StructType\WeaponDatumType
     */
    public function setWeaponAdress(\StructType\AddressType $weaponAdress = null)
    {
        $this->WeaponAdress = $weaponAdress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WeaponDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
