<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationStepDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об этапах проверки
 * @subpackage Structs
 */
class ValidationStepDetailType extends AbstractStructBase
{
    /**
     * The IdValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор этапа проверки | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IdValidationStep;
    /**
     * The TypeValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Тип этапа проверки
     * @var string
     */
    public $TypeValidationStep;
    /**
     * The ResultValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Результат этапа проверки | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $ResultValidationStep;
    /**
     * The DescriptionValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Описание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DescriptionValidationStep;
    /**
     * Constructor method for ValidationStepDetailType
     * @uses ValidationStepDetailType::setIdValidationStep()
     * @uses ValidationStepDetailType::setTypeValidationStep()
     * @uses ValidationStepDetailType::setResultValidationStep()
     * @uses ValidationStepDetailType::setDescriptionValidationStep()
     * @param int $idValidationStep
     * @param string $typeValidationStep
     * @param bool $resultValidationStep
     * @param string $descriptionValidationStep
     */
    public function __construct($idValidationStep = null, $typeValidationStep = null, $resultValidationStep = null, $descriptionValidationStep = null)
    {
        $this
            ->setIdValidationStep($idValidationStep)
            ->setTypeValidationStep($typeValidationStep)
            ->setResultValidationStep($resultValidationStep)
            ->setDescriptionValidationStep($descriptionValidationStep);
    }
    /**
     * Get IdValidationStep value
     * @return int|null
     */
    public function getIdValidationStep()
    {
        return $this->IdValidationStep;
    }
    /**
     * Set IdValidationStep value
     * @param int $idValidationStep
     * @return \StructType\ValidationStepDetailType
     */
    public function setIdValidationStep($idValidationStep = null)
    {
        $this->IdValidationStep = $idValidationStep;
        return $this;
    }
    /**
     * Get TypeValidationStep value
     * @return string|null
     */
    public function getTypeValidationStep()
    {
        return $this->TypeValidationStep;
    }
    /**
     * Set TypeValidationStep value
     * @uses \EnumType\ValidationStepType::valueIsValid()
     * @uses \EnumType\ValidationStepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeValidationStep
     * @return \StructType\ValidationStepDetailType
     */
    public function setTypeValidationStep($typeValidationStep = null)
    {
        $this->TypeValidationStep = $typeValidationStep;
        return $this;
    }
    /**
     * Get ResultValidationStep value
     * @return bool|null
     */
    public function getResultValidationStep()
    {
        return $this->ResultValidationStep;
    }
    /**
     * Set ResultValidationStep value
     * @param bool $resultValidationStep
     * @return \StructType\ValidationStepDetailType
     */
    public function setResultValidationStep($resultValidationStep = null)
    {
        $this->ResultValidationStep = $resultValidationStep;
        return $this;
    }
    /**
     * Get DescriptionValidationStep value
     * @return string|null
     */
    public function getDescriptionValidationStep()
    {
        return $this->DescriptionValidationStep;
    }
    /**
     * Set DescriptionValidationStep value
     * @param string $descriptionValidationStep
     * @return \StructType\ValidationStepDetailType
     */
    public function setDescriptionValidationStep($descriptionValidationStep = null)
    {
        $this->DescriptionValidationStep = $descriptionValidationStep;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidationStepDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
