<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периодических выплатах, зачислениях
 * @subpackage Structs
 */
class ValidationDatumType extends InformationType
{
    /**
     * The IdDoc
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IdDoc;
    /**
     * The ValidationResult
     * Meta informations extracted from the WSDL
     * - documentation: Результат проверки | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $ValidationResult;
    /**
     * The ValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об этапах проверки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ValidationStepDetailType[]
     */
    public $ValidationStep;
    /**
     * Constructor method for ValidationDatumType
     * @uses ValidationDatumType::setIdDoc()
     * @uses ValidationDatumType::setValidationResult()
     * @uses ValidationDatumType::setValidationStep()
     * @param int $idDoc
     * @param bool $validationResult
     * @param \StructType\ValidationStepDetailType[] $validationStep
     */
    public function __construct($idDoc = null, $validationResult = null, array $validationStep = array())
    {
        $this
            ->setIdDoc($idDoc)
            ->setValidationResult($validationResult)
            ->setValidationStep($validationStep);
    }
    /**
     * Get IdDoc value
     * @return int|null
     */
    public function getIdDoc()
    {
        return $this->IdDoc;
    }
    /**
     * Set IdDoc value
     * @param int $idDoc
     * @return \StructType\ValidationDatumType
     */
    public function setIdDoc($idDoc = null)
    {
        $this->IdDoc = $idDoc;
        return $this;
    }
    /**
     * Get ValidationResult value
     * @return bool|null
     */
    public function getValidationResult()
    {
        return $this->ValidationResult;
    }
    /**
     * Set ValidationResult value
     * @param bool $validationResult
     * @return \StructType\ValidationDatumType
     */
    public function setValidationResult($validationResult = null)
    {
        $this->ValidationResult = $validationResult;
        return $this;
    }
    /**
     * Get ValidationStep value
     * @return \StructType\ValidationStepDetailType[]|null
     */
    public function getValidationStep()
    {
        return $this->ValidationStep;
    }
    /**
     * Set ValidationStep value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationStepDetailType[] $validationStep
     * @return \StructType\ValidationDatumType
     */
    public function setValidationStep(array $validationStep = array())
    {
        $this->ValidationStep = $validationStep;
        return $this;
    }
    /**
     * Add item to ValidationStep value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationStepDetailType $item
     * @return \StructType\ValidationDatumType
     */
    public function addToValidationStep(\StructType\ValidationStepDetailType $item)
    {
        $this->ValidationStep[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
