<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnaccountedForDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о пропавшем без вести
 * @subpackage Structs
 */
class UnaccountedForDatumType extends InformationType
{
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата объявления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The ComplementaryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ComplementaryInfo;
    /**
     * Constructor method for UnaccountedForDatumType
     * @uses UnaccountedForDatumType::setAktDate()
     * @uses UnaccountedForDatumType::setComplementaryInfo()
     * @param string $aktDate
     * @param string $complementaryInfo
     */
    public function __construct($aktDate = null, $complementaryInfo = null)
    {
        $this
            ->setAktDate($aktDate)
            ->setComplementaryInfo($complementaryInfo);
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \StructType\UnaccountedForDatumType
     */
    public function setAktDate($aktDate = null)
    {
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get ComplementaryInfo value
     * @return string|null
     */
    public function getComplementaryInfo()
    {
        return $this->ComplementaryInfo;
    }
    /**
     * Set ComplementaryInfo value
     * @param string $complementaryInfo
     * @return \StructType\UnaccountedForDatumType
     */
    public function setComplementaryInfo($complementaryInfo = null)
    {
        $this->ComplementaryInfo = $complementaryInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnaccountedForDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
