<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TransportDataType "Транспортное средство" | Этот тип данных используется для передачи данных о транспортных средствах,
 * имеющих государственный регистрационный знак
 * @subpackage Structs
 */
class TransportDataType extends InformationType
{
    /**
     * The AutomType
     * Meta informations extracted from the WSDL
     * - documentation: Категория транспортного средства (грузовой, автобус и др.) | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AutomType;
    /**
     * The AutomTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ТС
     * - minOccurs: 0
     * @var string
     */
    public $AutomTypeCode;
    /**
     * The RegNo
     * Meta informations extracted from the WSDL
     * - documentation: Государственный регистрационный знак | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RegNo;
    /**
     * The PreviousRegNo
     * Meta informations extracted from the WSDL
     * - documentation: Прежний регистрационный знак | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PreviousRegNo;
    /**
     * The Producer
     * Meta informations extracted from the WSDL
     * - documentation: Марка | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Producer;
    /**
     * The Model
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Model;
    /**
     * The SpecialPurposeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код специального назначения ТС | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $SpecialPurposeCode;
    /**
     * The VIN
     * Meta informations extracted from the WSDL
     * - documentation: VIN | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $VIN;
    /**
     * The Engine
     * Meta informations extracted from the WSDL
     * - documentation: Номер двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Engine;
    /**
     * The EngineVolume
     * Meta informations extracted from the WSDL
     * - documentation: Объём двигателя, см куб. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EngineVolume;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, кВт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, л.с. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The ChassisNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер шасси (рамы) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ChassisNumber;
    /**
     * The BodyNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер кузова (прицепа) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $BodyNumber;
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Color;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска автотранспортного средства | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * The DeptName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения ГИБДД | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DeptName;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * The PrimaryPTS
     * Meta informations extracted from the WSDL
     * - documentation: Первичный ПТС (уникальный номер регистрации) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PrimaryPTS;
    /**
     * The OperationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование технологической операции | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OperationName;
    /**
     * The RegDocName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование регистрационного документа | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $RegDocName;
    /**
     * The RegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Серия и номер регистрационного документа | Строка длиной от 1 до 18 символов
     * - minOccurs: 0
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $RegDocNumber;
    /**
     * The RegDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи регистрационного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDocDate;
    /**
     * Constructor method for TransportDataType
     * @uses TransportDataType::setAutomType()
     * @uses TransportDataType::setAutomTypeCode()
     * @uses TransportDataType::setRegNo()
     * @uses TransportDataType::setPreviousRegNo()
     * @uses TransportDataType::setProducer()
     * @uses TransportDataType::setModel()
     * @uses TransportDataType::setSpecialPurposeCode()
     * @uses TransportDataType::setVIN()
     * @uses TransportDataType::setEngine()
     * @uses TransportDataType::setEngineVolume()
     * @uses TransportDataType::setEnginePowerKWh()
     * @uses TransportDataType::setEnginePowerHp()
     * @uses TransportDataType::setChassisNumber()
     * @uses TransportDataType::setBodyNumber()
     * @uses TransportDataType::setColor()
     * @uses TransportDataType::setMadeYear()
     * @uses TransportDataType::setDeptCode()
     * @uses TransportDataType::setDeptName()
     * @uses TransportDataType::setRegisterDate()
     * @uses TransportDataType::setUnregisterDate()
     * @uses TransportDataType::setPrimaryPTS()
     * @uses TransportDataType::setOperationName()
     * @uses TransportDataType::setRegDocName()
     * @uses TransportDataType::setRegDocNumber()
     * @uses TransportDataType::setRegDocDate()
     * @param string $automType
     * @param string $automTypeCode
     * @param string $regNo
     * @param string $previousRegNo
     * @param string $producer
     * @param string $model
     * @param string $specialPurposeCode
     * @param string $vIN
     * @param string $engine
     * @param float $engineVolume
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param string $chassisNumber
     * @param string $bodyNumber
     * @param string $color
     * @param string $madeYear
     * @param string $deptCode
     * @param string $deptName
     * @param string $registerDate
     * @param string $unregisterDate
     * @param string $primaryPTS
     * @param string $operationName
     * @param string $regDocName
     * @param string $regDocNumber
     * @param string $regDocDate
     */
    public function __construct($automType = null, $automTypeCode = null, $regNo = null, $previousRegNo = null, $producer = null, $model = null, $specialPurposeCode = null, $vIN = null, $engine = null, $engineVolume = null, $enginePowerKWh = null, $enginePowerHp = null, $chassisNumber = null, $bodyNumber = null, $color = null, $madeYear = null, $deptCode = null, $deptName = null, $registerDate = null, $unregisterDate = null, $primaryPTS = null, $operationName = null, $regDocName = null, $regDocNumber = null, $regDocDate = null)
    {
        $this
            ->setAutomType($automType)
            ->setAutomTypeCode($automTypeCode)
            ->setRegNo($regNo)
            ->setPreviousRegNo($previousRegNo)
            ->setProducer($producer)
            ->setModel($model)
            ->setSpecialPurposeCode($specialPurposeCode)
            ->setVIN($vIN)
            ->setEngine($engine)
            ->setEngineVolume($engineVolume)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setChassisNumber($chassisNumber)
            ->setBodyNumber($bodyNumber)
            ->setColor($color)
            ->setMadeYear($madeYear)
            ->setDeptCode($deptCode)
            ->setDeptName($deptName)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate)
            ->setPrimaryPTS($primaryPTS)
            ->setOperationName($operationName)
            ->setRegDocName($regDocName)
            ->setRegDocNumber($regDocNumber)
            ->setRegDocDate($regDocDate);
    }
    /**
     * Get AutomType value
     * @return string|null
     */
    public function getAutomType()
    {
        return $this->AutomType;
    }
    /**
     * Set AutomType value
     * @param string $automType
     * @return \StructType\TransportDataType
     */
    public function setAutomType($automType = null)
    {
        $this->AutomType = $automType;
        return $this;
    }
    /**
     * Get AutomTypeCode value
     * @return string|null
     */
    public function getAutomTypeCode()
    {
        return $this->AutomTypeCode;
    }
    /**
     * Set AutomTypeCode value
     * @uses \EnumType\TransportCategoryCodeType::valueIsValid()
     * @uses \EnumType\TransportCategoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $automTypeCode
     * @return \StructType\TransportDataType
     */
    public function setAutomTypeCode($automTypeCode = null)
    {
        $this->AutomTypeCode = $automTypeCode;
        return $this;
    }
    /**
     * Get RegNo value
     * @return string|null
     */
    public function getRegNo()
    {
        return $this->RegNo;
    }
    /**
     * Set RegNo value
     * @param string $regNo
     * @return \StructType\TransportDataType
     */
    public function setRegNo($regNo = null)
    {
        $this->RegNo = $regNo;
        return $this;
    }
    /**
     * Get PreviousRegNo value
     * @return string|null
     */
    public function getPreviousRegNo()
    {
        return $this->PreviousRegNo;
    }
    /**
     * Set PreviousRegNo value
     * @param string $previousRegNo
     * @return \StructType\TransportDataType
     */
    public function setPreviousRegNo($previousRegNo = null)
    {
        $this->PreviousRegNo = $previousRegNo;
        return $this;
    }
    /**
     * Get Producer value
     * @return string|null
     */
    public function getProducer()
    {
        return $this->Producer;
    }
    /**
     * Set Producer value
     * @param string $producer
     * @return \StructType\TransportDataType
     */
    public function setProducer($producer = null)
    {
        $this->Producer = $producer;
        return $this;
    }
    /**
     * Get Model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @param string $model
     * @return \StructType\TransportDataType
     */
    public function setModel($model = null)
    {
        $this->Model = $model;
        return $this;
    }
    /**
     * Get SpecialPurposeCode value
     * @return string|null
     */
    public function getSpecialPurposeCode()
    {
        return $this->SpecialPurposeCode;
    }
    /**
     * Set SpecialPurposeCode value
     * @param string $specialPurposeCode
     * @return \StructType\TransportDataType
     */
    public function setSpecialPurposeCode($specialPurposeCode = null)
    {
        $this->SpecialPurposeCode = $specialPurposeCode;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\TransportDataType
     */
    public function setVIN($vIN = null)
    {
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get Engine value
     * @return string|null
     */
    public function getEngine()
    {
        return $this->Engine;
    }
    /**
     * Set Engine value
     * @param string $engine
     * @return \StructType\TransportDataType
     */
    public function setEngine($engine = null)
    {
        $this->Engine = $engine;
        return $this;
    }
    /**
     * Get EngineVolume value
     * @return float|null
     */
    public function getEngineVolume()
    {
        return $this->EngineVolume;
    }
    /**
     * Set EngineVolume value
     * @param float $engineVolume
     * @return \StructType\TransportDataType
     */
    public function setEngineVolume($engineVolume = null)
    {
        $this->EngineVolume = $engineVolume;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \StructType\TransportDataType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \StructType\TransportDataType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \StructType\TransportDataType
     */
    public function setChassisNumber($chassisNumber = null)
    {
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get BodyNumber value
     * @return string|null
     */
    public function getBodyNumber()
    {
        return $this->BodyNumber;
    }
    /**
     * Set BodyNumber value
     * @param string $bodyNumber
     * @return \StructType\TransportDataType
     */
    public function setBodyNumber($bodyNumber = null)
    {
        $this->BodyNumber = $bodyNumber;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\TransportDataType
     */
    public function setColor($color = null)
    {
        $this->Color = $color;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \StructType\TransportDataType
     */
    public function setMadeYear($madeYear = null)
    {
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\TransportDataType
     */
    public function setDeptCode($deptCode = null)
    {
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Get DeptName value
     * @return string|null
     */
    public function getDeptName()
    {
        return $this->DeptName;
    }
    /**
     * Set DeptName value
     * @param string $deptName
     * @return \StructType\TransportDataType
     */
    public function setDeptName($deptName = null)
    {
        $this->DeptName = $deptName;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \StructType\TransportDataType
     */
    public function setRegisterDate($registerDate = null)
    {
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \StructType\TransportDataType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Get PrimaryPTS value
     * @return string|null
     */
    public function getPrimaryPTS()
    {
        return $this->PrimaryPTS;
    }
    /**
     * Set PrimaryPTS value
     * @param string $primaryPTS
     * @return \StructType\TransportDataType
     */
    public function setPrimaryPTS($primaryPTS = null)
    {
        $this->PrimaryPTS = $primaryPTS;
        return $this;
    }
    /**
     * Get OperationName value
     * @return string|null
     */
    public function getOperationName()
    {
        return $this->OperationName;
    }
    /**
     * Set OperationName value
     * @param string $operationName
     * @return \StructType\TransportDataType
     */
    public function setOperationName($operationName = null)
    {
        $this->OperationName = $operationName;
        return $this;
    }
    /**
     * Get RegDocName value
     * @return string|null
     */
    public function getRegDocName()
    {
        return $this->RegDocName;
    }
    /**
     * Set RegDocName value
     * @param string $regDocName
     * @return \StructType\TransportDataType
     */
    public function setRegDocName($regDocName = null)
    {
        $this->RegDocName = $regDocName;
        return $this;
    }
    /**
     * Get RegDocNumber value
     * @return string|null
     */
    public function getRegDocNumber()
    {
        return $this->RegDocNumber;
    }
    /**
     * Set RegDocNumber value
     * @param string $regDocNumber
     * @return \StructType\TransportDataType
     */
    public function setRegDocNumber($regDocNumber = null)
    {
        $this->RegDocNumber = $regDocNumber;
        return $this;
    }
    /**
     * Get RegDocDate value
     * @return string|null
     */
    public function getRegDocDate()
    {
        return $this->RegDocDate;
    }
    /**
     * Set RegDocDate value
     * @param string $regDocDate
     * @return \StructType\TransportDataType
     */
    public function setRegDocDate($regDocDate = null)
    {
        $this->RegDocDate = $regDocDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
