<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSideType StructType
 * @subpackage Structs
 */
class TransactionSideType extends AbstractStructBase
{
    /**
     * The transactSideCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида стороны операции | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $transactSideCode;
    /**
     * The transactSideName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование стороны операции | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $transactSideName;
    /**
     * The companyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о юридическом лице
     * @var \StructType\CompanyDatumType
     */
    public $companyDatum;
    /**
     * The personDatumPersonDatumType
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о физическом лице
     * @var \StructType\PersonDatumType
     */
    public $personDatumPersonDatumType;
    /**
     * Constructor method for TransactionSideType
     * @uses TransactionSideType::setTransactSideCode()
     * @uses TransactionSideType::setTransactSideName()
     * @uses TransactionSideType::setCompanyDatum()
     * @uses TransactionSideType::setPersonDatumPersonDatumType()
     * @param string $transactSideCode
     * @param string $transactSideName
     * @param \StructType\CompanyDatumType $companyDatum
     * @param \StructType\PersonDatumType $personDatumPersonDatumType
     */
    public function __construct($transactSideCode = null, $transactSideName = null, \StructType\CompanyDatumType $companyDatum = null, \StructType\PersonDatumType $personDatumPersonDatumType = null)
    {
        $this
            ->setTransactSideCode($transactSideCode)
            ->setTransactSideName($transactSideName)
            ->setCompanyDatum($companyDatum)
            ->setPersonDatumPersonDatumType($personDatumPersonDatumType);
    }
    /**
     * Get transactSideCode value
     * @return string|null
     */
    public function getTransactSideCode()
    {
        return $this->transactSideCode;
    }
    /**
     * Set transactSideCode value
     * @param string $transactSideCode
     * @return \StructType\TransactionSideType
     */
    public function setTransactSideCode($transactSideCode = null)
    {
        $this->transactSideCode = $transactSideCode;
        return $this;
    }
    /**
     * Get transactSideName value
     * @return string|null
     */
    public function getTransactSideName()
    {
        return $this->transactSideName;
    }
    /**
     * Set transactSideName value
     * @param string $transactSideName
     * @return \StructType\TransactionSideType
     */
    public function setTransactSideName($transactSideName = null)
    {
        $this->transactSideName = $transactSideName;
        return $this;
    }
    /**
     * Get companyDatum value
     * @return \StructType\CompanyDatumType|null
     */
    public function getCompanyDatum()
    {
        return $this->companyDatum;
    }
    /**
     * Set companyDatum value
     * @param \StructType\CompanyDatumType $companyDatum
     * @return \StructType\TransactionSideType
     */
    public function setCompanyDatum(\StructType\CompanyDatumType $companyDatum = null)
    {
        $this->companyDatum = $companyDatum;
        return $this;
    }
    /**
     * Get personDatumPersonDatumType value
     * @return \StructType\PersonDatumType|null
     */
    public function getPersonDatumPersonDatumType()
    {
        return $this->personDatumPersonDatumType;
    }
    /**
     * Set personDatumPersonDatumType value
     * @param \StructType\PersonDatumType $personDatumPersonDatumType
     * @return \StructType\TransactionSideType
     */
    public function setPersonDatumPersonDatumType(\StructType\PersonDatumType $personDatumPersonDatumType = null)
    {
        $this->personDatumPersonDatumType = $personDatumPersonDatumType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionSideType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
