<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о финансовой операции
 * @subpackage Structs
 */
class TransactionDatumType extends InformationType
{
    /**
     * The transactKindCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа операции | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $transactKindCode;
    /**
     * The transactKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа операции | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $transactKindName;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $amount;
    /**
     * The ground
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $ground;
    /**
     * The sides
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сторонах операции
     * - maxOccurs: unbounded
     * @var \StructType\TransactionSideType[]
     */
    public $sides;
    /**
     * Constructor method for TransactionDatumType
     * @uses TransactionDatumType::setTransactKindCode()
     * @uses TransactionDatumType::setTransactKindName()
     * @uses TransactionDatumType::setAmount()
     * @uses TransactionDatumType::setGround()
     * @uses TransactionDatumType::setSides()
     * @param string $transactKindCode
     * @param string $transactKindName
     * @param float $amount
     * @param string $ground
     * @param \StructType\TransactionSideType[] $sides
     */
    public function __construct($transactKindCode = null, $transactKindName = null, $amount = null, $ground = null, array $sides = array())
    {
        $this
            ->setTransactKindCode($transactKindCode)
            ->setTransactKindName($transactKindName)
            ->setAmount($amount)
            ->setGround($ground)
            ->setSides($sides);
    }
    /**
     * Get transactKindCode value
     * @return string|null
     */
    public function getTransactKindCode()
    {
        return $this->transactKindCode;
    }
    /**
     * Set transactKindCode value
     * @param string $transactKindCode
     * @return \StructType\TransactionDatumType
     */
    public function setTransactKindCode($transactKindCode = null)
    {
        $this->transactKindCode = $transactKindCode;
        return $this;
    }
    /**
     * Get transactKindName value
     * @return string|null
     */
    public function getTransactKindName()
    {
        return $this->transactKindName;
    }
    /**
     * Set transactKindName value
     * @param string $transactKindName
     * @return \StructType\TransactionDatumType
     */
    public function setTransactKindName($transactKindName = null)
    {
        $this->transactKindName = $transactKindName;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\TransactionDatumType
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get ground value
     * @return string|null
     */
    public function getGround()
    {
        return $this->ground;
    }
    /**
     * Set ground value
     * @param string $ground
     * @return \StructType\TransactionDatumType
     */
    public function setGround($ground = null)
    {
        $this->ground = $ground;
        return $this;
    }
    /**
     * Get sides value
     * @return \StructType\TransactionSideType[]|null
     */
    public function getSides()
    {
        return $this->sides;
    }
    /**
     * Set sides value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionSideType[] $sides
     * @return \StructType\TransactionDatumType
     */
    public function setSides(array $sides = array())
    {
        $this->sides = $sides;
        return $this;
    }
    /**
     * Add item to sides value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionSideType $item
     * @return \StructType\TransactionDatumType
     */
    public function addToSides(\StructType\TransactionSideType $item)
    {
        $this->sides[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
