<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TelephoneDataType "Телефон"
 * @subpackage Structs
 */
class TelephoneDataType extends InformationType
{
    /**
     * The TelephoneNo
     * Meta informations extracted from the WSDL
     * - documentation: Номер телефона абонента | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNo;
    /**
     * The FaxNo
     * Meta informations extracted from the WSDL
     * - documentation: Номер факса | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $FaxNo;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for TelephoneDataType
     * @uses TelephoneDataType::setTelephoneNo()
     * @uses TelephoneDataType::setFaxNo()
     * @uses TelephoneDataType::setDeptCode()
     * @param string $telephoneNo
     * @param string $faxNo
     * @param string $deptCode
     */
    public function __construct($telephoneNo = null, $faxNo = null, $deptCode = null)
    {
        $this
            ->setTelephoneNo($telephoneNo)
            ->setFaxNo($faxNo)
            ->setDeptCode($deptCode);
    }
    /**
     * Get TelephoneNo value
     * @return string|null
     */
    public function getTelephoneNo()
    {
        return $this->TelephoneNo;
    }
    /**
     * Set TelephoneNo value
     * @param string $telephoneNo
     * @return \StructType\TelephoneDataType
     */
    public function setTelephoneNo($telephoneNo = null)
    {
        $this->TelephoneNo = $telephoneNo;
        return $this;
    }
    /**
     * Get FaxNo value
     * @return string|null
     */
    public function getFaxNo()
    {
        return $this->FaxNo;
    }
    /**
     * Set FaxNo value
     * @param string $faxNo
     * @return \StructType\TelephoneDataType
     */
    public function setFaxNo($faxNo = null)
    {
        $this->FaxNo = $faxNo;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\TelephoneDataType
     */
    public function setDeptCode($deptCode = null)
    {
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephoneDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
