<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncRq StructType
 * @subpackage Structs
 */
abstract class SyncRq extends AbstractStructBase
{
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя пакета
     * @var \StructType\RedAddress
     */
    public $origin;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя пакета
     * @var \StructType\RedAddress
     */
    public $target;
    /**
     * Constructor method for SyncRq
     * @uses SyncRq::setExternalKey()
     * @uses SyncRq::setOrigin()
     * @uses SyncRq::setTarget()
     * @param string $externalKey
     * @param \StructType\RedAddress $origin
     * @param \StructType\RedAddress $target
     */
    public function __construct($externalKey = null, \StructType\RedAddress $origin = null, \StructType\RedAddress $target = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setOrigin($origin)
            ->setTarget($target);
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\SyncRq
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\RedAddress $origin
     * @return \StructType\SyncRq
     */
    public function setOrigin(\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get target value
     * @return \StructType\RedAddress|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \StructType\RedAddress $target
     * @return \StructType\SyncRq
     */
    public function setTarget(\StructType\RedAddress $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncRq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
