<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvRightType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о правах на недвижимость
 * @subpackage Structs
 */
class SvedNedvRightType extends InformationType
{
    /**
     * The rightCode
     * Meta informations extracted from the WSDL
     * - documentation: Код права | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $rightCode;
    /**
     * The rightName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование права | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $rightName;
    /**
     * The rightText
     * Meta informations extracted from the WSDL
     * - documentation: Вид права | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $rightText;
    /**
     * The shareValue
     * Meta informations extracted from the WSDL
     * - documentation: Доля (значение)
     * - minOccurs: 0
     * @var \StructType\ShareType
     */
    public $shareValue;
    /**
     * The shareText
     * Meta informations extracted from the WSDL
     * - documentation: Доля (текст) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $shareText;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер государствеенной регистрации | Строка длиной от 1 до 45 символов
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * Constructor method for SvedNedvRightType
     * @uses SvedNedvRightType::setRightCode()
     * @uses SvedNedvRightType::setRightName()
     * @uses SvedNedvRightType::setRightText()
     * @uses SvedNedvRightType::setShareValue()
     * @uses SvedNedvRightType::setShareText()
     * @uses SvedNedvRightType::setRegNumber()
     * @uses SvedNedvRightType::setRegDate()
     * @param string $rightCode
     * @param string $rightName
     * @param string $rightText
     * @param \StructType\ShareType $shareValue
     * @param string $shareText
     * @param string $regNumber
     * @param string $regDate
     */
    public function __construct($rightCode = null, $rightName = null, $rightText = null, \StructType\ShareType $shareValue = null, $shareText = null, $regNumber = null, $regDate = null)
    {
        $this
            ->setRightCode($rightCode)
            ->setRightName($rightName)
            ->setRightText($rightText)
            ->setShareValue($shareValue)
            ->setShareText($shareText)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate);
    }
    /**
     * Get rightCode value
     * @return string|null
     */
    public function getRightCode()
    {
        return $this->rightCode;
    }
    /**
     * Set rightCode value
     * @param string $rightCode
     * @return \StructType\SvedNedvRightType
     */
    public function setRightCode($rightCode = null)
    {
        $this->rightCode = $rightCode;
        return $this;
    }
    /**
     * Get rightName value
     * @return string|null
     */
    public function getRightName()
    {
        return $this->rightName;
    }
    /**
     * Set rightName value
     * @param string $rightName
     * @return \StructType\SvedNedvRightType
     */
    public function setRightName($rightName = null)
    {
        $this->rightName = $rightName;
        return $this;
    }
    /**
     * Get rightText value
     * @return string|null
     */
    public function getRightText()
    {
        return $this->rightText;
    }
    /**
     * Set rightText value
     * @param string $rightText
     * @return \StructType\SvedNedvRightType
     */
    public function setRightText($rightText = null)
    {
        $this->rightText = $rightText;
        return $this;
    }
    /**
     * Get shareValue value
     * @return \StructType\ShareType|null
     */
    public function getShareValue()
    {
        return $this->shareValue;
    }
    /**
     * Set shareValue value
     * @param \StructType\ShareType $shareValue
     * @return \StructType\SvedNedvRightType
     */
    public function setShareValue(\StructType\ShareType $shareValue = null)
    {
        $this->shareValue = $shareValue;
        return $this;
    }
    /**
     * Get shareText value
     * @return string|null
     */
    public function getShareText()
    {
        return $this->shareText;
    }
    /**
     * Set shareText value
     * @param string $shareText
     * @return \StructType\SvedNedvRightType
     */
    public function setShareText($shareText = null)
    {
        $this->shareText = $shareText;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \StructType\SvedNedvRightType
     */
    public function setRegNumber($regNumber = null)
    {
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \StructType\SvedNedvRightType
     */
    public function setRegDate($regDate = null)
    {
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SvedNedvRightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
